/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ArchiveTypeDiscriminatorRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ClientModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ConnectorModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WebModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveInit;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ApplicationClientFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveCopyUtility;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ClientModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ConnectorModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EJBJarFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EJBModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ReadOnlyDirectoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootAppClientJarDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootArchiveTypeDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootEARFileDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootEJBJarDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.RootWarDescriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WARFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WebModuleRefImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.Ear12ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.Ear50NoDDImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.EjbJar11ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.NestedArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.NullLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.RarImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ReadOnlyDirectoryLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.TempZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.DeleteOnExitUtility;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;

public class CommonarchiveFactoryImpl
extends EFactoryImpl
implements CommonarchiveFactory {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    protected static String className = CommonarchiveFactoryImpl.class.getName();
    protected Map openArchives = new WeakHashMap();
    private static boolean delegateNeedsInit = true;
    private CommonarchiveFactory delegate = null;
    public static final boolean IS_BINARIES_BASED = true;
    public static final boolean IS_NOT_BINARIES_BASED = false;

    public static CommonarchiveFactory init() {
        try {
            CommonarchiveFactory theCommonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEFactory("commonarchive.xmi");
            if (theCommonarchiveFactory != null) {
                return theCommonarchiveFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
        }
        return new CommonarchiveFactoryImpl();
    }

    public CommonarchiveFactoryImpl() {
        this.initDelegate();
    }

    private void initDelegate() {
        if (delegateNeedsInit) {
            delegateNeedsInit = false;
            this.delegate = new CommonarchiveFactoryImpl(){

                public ApplicationClientFile createApplicationClientFile() {
                    return this.createApplicationClientFileGen();
                }

                public ClientModuleRef createClientModuleRef() {
                    return this.createClientModuleRefGen();
                }

                public ConnectorModuleRef createConnectorModuleRef() {
                    return this.createConnectorModuleRefGen();
                }

                public EARFile createEARFile() {
                    return this.createEARFileGen();
                }

                public EJBJarFile createEJBJarFile() {
                    return this.createEJBJarFileGen();
                }

                public EJBModuleRef createEJBModuleRef() {
                    return this.createEJBModuleRefGen();
                }

                public RARFile createRARFile() {
                    return this.createRARFileGen();
                }

                public WARFile createWARFile() {
                    return this.createWARFileGen();
                }

                public WebModuleRef createWebModuleRef() {
                    return this.createWebModuleRefGen();
                }
            };
        }
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createFile();
            }
            case 1: {
                return this.createArchive();
            }
            case 2: {
                return this.createEJBJarFile();
            }
            case 3: {
                return this.createWARFile();
            }
            case 4: {
                return this.createEARFile();
            }
            case 5: {
                return this.createApplicationClientFile();
            }
            case 8: {
                return this.createReadOnlyDirectory();
            }
            case 9: {
                return this.createRARFile();
            }
            case 11: {
                return this.createEJBModuleRef();
            }
            case 12: {
                return this.createWebModuleRef();
            }
            case 13: {
                return this.createClientModuleRef();
            }
            case 14: {
                return this.createConnectorModuleRef();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveClosed(Archive aClosedArchive) {
        Map openArchives;
        String methodName = "archiveClosed";
        logger.logp(Level.FINER, className, methodName, "Archive URI [ {0} ]", aClosedArchive.getURI());
        Map map = openArchives = this.getOpenArchives();
        synchronized (map) {
            openArchives.remove(aClosedArchive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveOpened(Archive anOpenArchive) {
        Map openArchives;
        String methodName = "archiveOpened";
        logger.logp(Level.FINER, className, methodName, "Archive URI [ {0} ]", anOpenArchive.getURI());
        Map map = openArchives = this.getOpenArchives();
        synchronized (map) {
            openArchives.put(anOpenArchive, null);
        }
    }

    public boolean canClose(Archive anArchive) {
        return !this.getOpenArchivesDependingOn(anArchive).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOpenArchives() {
        Map openArchives;
        Map map = openArchives = this.getOpenArchives();
        synchronized (map) {
            ArrayList opened = new ArrayList(openArchives.keySet());
            for (Archive anArchive : opened) {
                anArchive.close();
            }
        }
    }

    public Archive copy(Archive anArchive) {
        return new ArchiveCopyUtility().copy(anArchive);
    }

    public ModuleFile copy(ModuleFile aModuleFile) {
        return new ArchiveCopyUtility().copy(aModuleFile);
    }

    public ApplicationClientFile createApplicationClientFileInitialized(String uri) {
        ApplicationClientFile clientFile = this.createApplicationClientFile();
        this.initializeNewApplicationClientFile(clientFile, uri);
        return clientFile;
    }

    public Archive createArchiveInitialized(String uri) {
        Archive anArchive = this.createArchive();
        this.initializeNewArchive(anArchive, uri);
        return anArchive;
    }

    public Archive createArchiveInitialized(ArchiveOptions options, String uri) {
        Archive anArchive = this.createArchive();
        this.initializeNewArchive(anArchive, uri, options);
        return anArchive;
    }

    public LoadStrategy createChildLoadStrategy(String uri, LoadStrategy parent) throws IOException, FileNotFoundException {
        return this.createChildLoadStrategy(uri, parent, false);
    }

    public LoadStrategy createChildLoadStrategy(String uri, LoadStrategy parent, boolean isBinariesBased) throws IOException, FileNotFoundException {
        LoadStrategy childStrategy;
        String methodName = "createChildLoadStrategy";
        logger.logp(Level.FINER, className, methodName, "ENTRY - URI [ {0} ]", uri);
        String containerUri = parent.getContainer().getURI();
        logger.logp(Level.FINER, className, methodName, "Parent container URI [ {0} ]", containerUri);
        if (isBinariesBased) {
            logger.logp(Level.FINER, className, methodName, "Create child strategies for binaries based java archive");
            String binariesPath = parent.getBinariesPath();
            logger.logp(Level.FINER, className, methodName, "Parent binaries path [ {0} ]", binariesPath);
            java.io.File binariesFile = new java.io.File(binariesPath);
            if (binariesFile.isDirectory()) {
                logger.logp(Level.FINER, className, methodName, "Binaries location is a directory");
                String qualifiedUri = ArchiveUtil.getOSUri(binariesPath, uri);
                logger.logp(Level.FINER, className, methodName, "Combined URI [ {0} ]", qualifiedUri);
                childStrategy = this.createLoadStrategy(qualifiedUri);
            } else {
                logger.logp(Level.FINER, className, methodName, "Binaries location is a file");
                try {
                    childStrategy = this.createNestedZipFileLoadStrategy(uri, parent);
                }
                catch (ArchiveException e) {
                    logger.throwing(className, methodName, e);
                    throw new IOException("Failed to create nested zip file load strategy for [ " + uri + " ] message [ " + e.getMessage() + " ]");
                }
            }
        } else if (parent.isDirectory()) {
            logger.logp(Level.FINER, className, methodName, "Parent is a directory");
            String dirName = ((DirectoryArchiveLoadStrategy)parent).getDirectoryUri();
            logger.logp(Level.FINER, className, methodName, "Parent directory URI [ {0} ]", dirName);
            String qualifiedUri = ArchiveUtil.getOSUri(dirName, uri);
            logger.logp(Level.FINER, className, methodName, "Combined URI [ {0} ]", qualifiedUri);
            childStrategy = this.createLoadStrategy(qualifiedUri);
        } else {
            logger.logp(Level.FINER, className, methodName, "Parent is not a directory");
            childStrategy = this.createNestedLoadStrategy(uri, parent);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", childStrategy);
        return childStrategy;
    }

    public EARFile createEARFileInitialized(String uri) {
        EARFile earFile = this.createEARFile();
        this.initializeNewEARFile(earFile, uri);
        return earFile;
    }

    public EARFile createEARFileInitialized(ArchiveOptions options, String uri) {
        EARFile earFile = this.createEARFile();
        this.initializeNewEARFile(earFile, uri, options);
        return earFile;
    }

    public EJBJarFile createEJBJarFileInitialized(String uri) {
        EJBJarFile ejbJarFile = this.createEJBJarFile();
        this.initializeNewEJBJarFile(ejbJarFile, uri);
        return ejbJarFile;
    }

    public EJBJarFile createEJBJarFileInitialized(ArchiveOptions options, String uri) {
        EJBJarFile ejbJarFile = this.createEJBJarFile();
        this.initializeNewEJBJarFile(ejbJarFile, uri, options);
        return ejbJarFile;
    }

    public LoadStrategy createEmptyLoadStrategy() {
        return new NullLoadStrategyImpl();
    }

    public LoadStrategy createLoadStrategy(String uri) throws FileNotFoundException, IOException {
        String methodName = "createLoadStrategy";
        logger.logp(Level.FINER, className, methodName, "ENTRY - URI [ {0} ]", uri);
        String filename = uri.replace('/', java.io.File.separatorChar);
        java.io.File file = new java.io.File(filename);
        if (!file.exists()) {
            logger.logp(Level.FINER, className, methodName, "The following file could not be found: [ {0} ]", filename);
            logger.logp(Level.FINER, className, methodName, "RETURN Throwing FileNotFoundException");
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.file_not_found_EXC_, new Object[]{uri, file.getAbsolutePath()}));
        }
        if (file.isDirectory()) {
            DirectoryArchiveLoadStrategyImpl ls = new DirectoryArchiveLoadStrategyImpl(uri);
            logger.logp(Level.FINER, className, methodName, "RETURN Returning DirectoryArchiveLoadStrategy [ {0} ]", ls);
            return ls;
        }
        ZipFileLoadStrategyImpl ls = new ZipFileLoadStrategyImpl(file);
        logger.logp(Level.FINER, className, methodName, "RETURN Returning ZipFileLoadStrategy [ {0} ]", ls);
        return ls;
    }

    public LoadStrategy createNestedLoadStrategy(String uri, LoadStrategy parent) {
        try {
            return this.createNestedLoadStrategy(uri, parent, false, false);
        }
        catch (ArchiveException e) {
            return null;
        }
    }

    public LoadStrategy createNestedLoadStrategy(String uri, LoadStrategy parent, boolean attemptExtraction) {
        try {
            return this.createNestedLoadStrategy(uri, parent, attemptExtraction, false);
        }
        catch (ArchiveException e) {
            return null;
        }
    }

    public ZipFileLoadStrategy createNestedZipFileLoadStrategy(String uri, LoadStrategy parent) throws ArchiveException {
        return (ZipFileLoadStrategy)this.createNestedLoadStrategy(uri, parent, true, true);
    }

    public LoadStrategy createNestedLoadStrategy(String uri, LoadStrategy parentStrategy, boolean attemptExpansion, boolean requireExpansion) throws ArchiveException {
        String methodName = "createNestedLoadStrategy";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", uri);
        ArchiveOptions options = ((Archive)parentStrategy.getContainer()).getOptions();
        boolean isReadOnly = options.isReadOnly(uri);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "Attempt expansion [ {0} ]", new Boolean(attemptExpansion));
            logger.logp(Level.FINER, className, methodName, "Required expansion [ {0} ]", new Boolean(requireExpansion));
            logger.logp(Level.FINER, className, methodName, "Read-only [ {0} ]", new Boolean(isReadOnly));
        }
        if (requireExpansion) {
            ArrayList exceptions;
            LoadStrategy loadStrategy;
            if (!attemptExpansion) {
                ArchiveException archiveException = new ArchiveException("Require expansion true with attempt expansion false for [ " + uri + " ]");
                logger.throwing(className, methodName, archiveException);
                throw archiveException;
            }
            if (isReadOnly) {
                logger.logp(Level.FINER, className, methodName, "Require expansion true with read-only true for [ {0} ]", uri);
            }
            if ((loadStrategy = this.createTempZipFileStrategyIfPossible(uri, parentStrategy, exceptions = new ArrayList())) == null) {
                ArchiveException archiveException;
                if (exceptions.isEmpty()) {
                    logger.logp(Level.WARNING, className, methodName, "Strange; failed to open temp file for [ " + uri + " ] but no exception is available");
                    archiveException = new ArchiveException("Failed to open temp strategy for [ " + uri + " ]");
                } else {
                    logger.logp(Level.WARNING, className, methodName, "Could not create temp file for base URI [ {0} ]", uri);
                    Exception baseException = (Exception)exceptions.get(0);
                    archiveException = new ArchiveException("Failed to open temp strategy for [ " + uri + " ]", baseException);
                }
                logger.throwing(className, methodName, archiveException);
                throw archiveException;
            }
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", loadStrategy);
            return loadStrategy;
        }
        LoadStrategy loadStrategy = null;
        if (attemptExpansion || !isReadOnly) {
            logger.logp(Level.FINER, className, methodName, "Use of temp file is specified.");
            loadStrategy = this.createTempZipFileStrategyIfPossible(uri, parentStrategy, null);
            if (loadStrategy == null) {
                logger.logp(Level.WARNING, className, methodName, "Could not create temp file for base URI [ {0} ] and temporary directory [ {1} ]; creating nested strategy", new Object[]{uri, ArchiveUtil.getTempDirectory()});
            } else {
                logger.logp(Level.FINER, className, methodName, "Created temp file; using temp strategy");
            }
        } else {
            logger.logp(Level.FINER, className, methodName, "Read-only is specified; creating nested strategy");
        }
        if (loadStrategy == null) {
            logger.logp(Level.FINER, className, methodName, "Fall-back - creating NestedArchiveLoadStrategyImpl");
            loadStrategy = new NestedArchiveLoadStrategyImpl(parentStrategy);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", loadStrategy);
        return loadStrategy;
    }

    public RARFile createRARFileInitialized(String uri) {
        RARFile rarFile = this.createRARFile();
        this.initializeNewRARFile(rarFile, uri);
        return rarFile;
    }

    public LoadStrategy createTempZipFileStrategyIfPossible(String uri, LoadStrategy parent) {
        return this.createTempZipFileStrategyIfPossible(uri, parent, null);
    }

    public LoadStrategy createTempZipFileStrategyIfPossible(String uri, LoadStrategy parent, List exceptions) {
        TempZipFileLoadStrategyImpl result;
        FileOutputStream out;
        InputStream in;
        java.io.File tempFile;
        String methodName = "createTempZipFileStrategyIfPossible";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", uri);
        if (!ArchiveUtil.shouldUseTempDirectoryForRead()) {
            logger.logp(Level.SEVERE, className, methodName, "RETURN [ null ] use of temporary directories is unexpectedly disallowed");
            return null;
        }
        java.io.File tempDir = ArchiveUtil.getTempDirectory();
        if (tempDir != null) {
            logger.logp(Level.FINER, className, methodName, "Creating file in preset temporary directory [ {0} ]", tempDir);
            try {
                tempFile = ArchiveUtil.createTempFile(uri);
            }
            catch (IOException e) {
                tempFile = null;
                logger.logp(Level.WARNING, className, methodName, "Could not create temporary file using temporary location [ {0} ]", tempDir);
                ArchiveUtil.inform(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.make_temp_file_WARN_, new Object[]{uri}) + e.getLocalizedMessage());
                logger.throwing(className, methodName, e);
                if (exceptions != null) {
                    exceptions.add(e);
                }
            }
        } else {
            tempFile = null;
            logger.logp(Level.FINER, className, methodName, "No assigned temporary directory");
        }
        if (tempFile == null) {
            String tempDirName = this.getSystemTempDirName(uri);
            if (tempDirName == null) {
                logger.logp(Level.SEVERE, className, methodName, "Unable to retrieve system defined temporary location (java.io.tmpdir).\nFailed to create temporary file.\nA nested strategy will be used, but this usually slows performance dramatically.");
                logger.logp(Level.FINER, className, methodName, "RETURN [ null ]");
                return null;
            }
            logger.logp(Level.FINER, className, methodName, "Trying with system temporary location [ {0} ]", tempDirName);
            try {
                tempFile = ArchiveUtil.createTempFile(uri, null);
            }
            catch (IOException e) {
                logger.logp(Level.SEVERE, className, methodName, "Failed to create temporary file in system defined temporary location (java.io.tmpdir) [ {0} ].\nFailed to create temporary file.\nA nested strategy will be used, but this usually slows performance dramatically.", tempDirName);
                logger.throwing(className, methodName, e);
                if (exceptions != null) {
                    exceptions.add(e);
                }
                logger.logp(Level.FINER, className, methodName, "RETURN [ null ]");
                return null;
            }
        }
        logger.logp(Level.FINER, className, methodName, "Successful creation of temp file [ {0} ]", tempFile);
        DeleteOnExitUtility.markForDeletion(tempFile);
        try {
            in = parent.getInputStream(uri);
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, className, methodName, "Failed to open input stream on target [ {0} ].\nFailed to create temporary file.\nA nested strategy will be used, but this usually slows performance dramatically.", uri);
            logger.throwing(className, methodName, e);
            if (exceptions != null) {
                exceptions.add(e);
            }
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ]");
            return null;
        }
        try {
            out = new FileOutputStream(tempFile);
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, className, methodName, "Failed to open ouput stream on temporary file [ {0} ].\nFailed to create temporary file.\nA nested strategy will be used, but this usually slows performance dramatically.", tempFile);
            logger.throwing(className, methodName, e);
            if (exceptions != null) {
                exceptions.add(e);
            }
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ]");
            return null;
        }
        try {
            ArchiveUtil.copy(in, out);
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, className, methodName, "Failed to copy input [ {0} ] to temporary file [ {1} ].\nFailed to create temporary file.\nA nested strategy will be used, but this usually slows performance dramatically.", new Object[]{uri, tempFile});
            logger.throwing(className, methodName, e);
            if (exceptions != null) {
                exceptions.add(e);
            }
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ]");
            return null;
        }
        try {
            result = new TempZipFileLoadStrategyImpl(tempFile);
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, className, methodName, "Failed to open load strategy on temporary file [ {0} ].\nFailed to create temporary file.\nA nested strategy will be used, but this usually slows performance dramatically.", tempFile);
            logger.throwing(className, methodName, e);
            if (exceptions != null) {
                exceptions.add(e);
            }
            logger.logp(Level.FINER, className, methodName, "RETURN [ null ]");
            return null;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", result);
        return result;
    }

    public String getSystemTempDirName(String uri) {
        String methodName = "getSystemTempDirName";
        try {
            String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("java.io.tmpdir");
                }
            });
            return value;
        }
        catch (SecurityException securityException) {
            logger.logp(Level.FINER, className, methodName, "RETURN null - system temp directory name could not be retrieved");
            return null;
        }
    }

    public WARFile createWARFileInitialized(String uri) {
        WARFile warFile = this.createWARFile();
        this.initializeNewWARFile(warFile, uri);
        return warFile;
    }

    protected ArchiveOptions defaultOptions(LoadStrategy aLoadStrategy) {
        ArchiveOptions options = new ArchiveOptions();
        options.setLoadStrategy(aLoadStrategy);
        return options;
    }

    public static CommonarchiveFactory getActiveFactory() {
        CommonarchivePackage pkg = CommonarchiveFactoryImpl.getPackage();
        if (pkg != null) {
            return pkg.getCommonarchiveFactory();
        }
        return null;
    }

    public String[] getManifestClassPathValues(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        String[] result = anArchive.getManifest().getClassPathTokenized();
        anArchive.close();
        return result;
    }

    public Map getOpenArchives() {
        return this.openArchives;
    }

    protected void setOpenArchives(Map newOpenArchives) {
        this.openArchives = newOpenArchives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpenArchivesDependingOn(Archive anArchive) {
        Map openArchives;
        Map map = openArchives = this.getOpenArchives();
        synchronized (map) {
            HashSet<Archive> dependents = new HashSet<Archive>();
            for (Archive openedArchive : this.getOpenArchives().keySet()) {
                if (openedArchive == anArchive || !openedArchive.isIndexed()) continue;
                EList files = openedArchive.getFiles();
                for (int i = 0; i < files.size(); ++i) {
                    File aFile = (File)files.get(i);
                    if (aFile.getLoadingContainer() != anArchive) continue;
                    Archive outermost = openedArchive;
                    for (Container c = openedArchive.getContainer(); c != null && c.isArchive(); c = c.getContainer()) {
                        outermost = (Archive)c;
                    }
                    dependents.add(outermost);
                }
            }
            List nestedArchives = anArchive.getArchiveFiles();
            for (int i = 0; i < nestedArchives.size(); ++i) {
                dependents.addAll(this.getOpenArchivesDependingOn((Archive)nestedArchives.get(i)));
            }
            return dependents;
        }
    }

    protected static void initPrereqs() {
        ArchiveInit.invokePrereqInits(true);
        ArchiveTypeDiscriminator disc = RootArchiveTypeDescriminatorImpl.singleton();
        disc.addChild(Ear12ImportStrategyImpl.getDiscriminator());
        disc.addChild(Ear50NoDDImportStrategyImpl.getDiscriminator());
        disc.addChild(RootWarDescriminatorImpl.singleton());
        disc.addChild(RootEJBJarDescriminatorImpl.singleton());
        disc.addChild(RootAppClientJarDescriminatorImpl.singleton());
        disc.addChild(RarImportStrategyImpl.getDiscriminator());
    }

    public void initializeNewApplicationClientFile(ApplicationClientFile anArchive, String uri) {
        this.initializeNewModuleFile(anArchive, uri);
    }

    public void initializeNewArchive(Archive anArchive, String uri) {
        anArchive.setURI(uri);
        anArchive.setSize(0L);
        anArchive.setLastModified(System.currentTimeMillis());
        anArchive.setDirectoryEntry(false);
        anArchive.setLoadStrategy(this.createEmptyLoadStrategy());
    }

    public void initializeNewEARFile(EARFile anArchive, String uri) {
        this.initializeNewModuleFile(anArchive, uri);
    }

    public void initializeNewEJBJarFile(EJBJarFile anArchive, String uri) {
        this.initializeNewModuleFile(anArchive, uri);
    }

    public void initializeNewModuleFile(ModuleFile anArchive, String uri) {
        this.initializeNewArchive(anArchive, uri);
        anArchive.makeDeploymentDescriptorResource();
    }

    public void initializeNewRARFile(RARFile anArchive, String uri) {
        this.initializeNewModuleFile(anArchive, uri);
    }

    public void initializeNewWARFile(WARFile anArchive, String uri) {
        this.initializeNewModuleFile(anArchive, uri);
    }

    public void initializeNewApplicationClientFile(ApplicationClientFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewModuleFile(anArchive, uri, options);
    }

    public void initializeNewArchive(Archive anArchive, String uri, ArchiveOptions options) {
        if (options.getLoadStrategy() == null) {
            try {
                options.setLoadStrategy(this.createEmptyLoadStrategy());
            }
            catch (Exception ex) {
                logger.logp(Level.SEVERE, className, "initializeNewArchive", CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.CommonArchiveFactory_archive_init_error_0, new Object[]{ex.getMessage()}));
            }
        }
        anArchive.setURI(uri);
        anArchive.setSize(0L);
        anArchive.setLastModified(System.currentTimeMillis());
        anArchive.setDirectoryEntry(false);
        anArchive.setLoadStrategy(options.getLoadStrategy());
        anArchive.setOptions(options);
    }

    public void initializeNewEARFile(EARFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewModuleFile(anArchive, uri, options);
    }

    public void initializeNewEJBJarFile(EJBJarFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewModuleFile(anArchive, uri, options);
    }

    public void initializeNewModuleFile(ModuleFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewArchive(anArchive, uri, options);
        anArchive.makeDeploymentDescriptorResource();
    }

    public void initializeNewRARFile(RARFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewModuleFile(anArchive, uri, options);
    }

    public void initializeNewWARFile(WARFile anArchive, String uri, ArchiveOptions options) {
        this.initializeNewModuleFile(anArchive, uri, options);
    }

    public ApplicationClientFile openApplicationClientFile(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        ArchiveTypeDiscriminator disc = RootAppClientJarDescriminatorImpl.singleton();
        return (ApplicationClientFile)this.openSpecificArchive(anArchive, disc);
    }

    public ApplicationClientFile openApplicationClientFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        ArchiveTypeDiscriminator disc = RootAppClientJarDescriminatorImpl.singleton();
        return (ApplicationClientFile)this.openSpecificArchive(anArchive, disc);
    }

    public ApplicationClientFile openApplicationClientFile(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        ArchiveTypeDiscriminator disc = RootAppClientJarDescriminatorImpl.singleton();
        return (ApplicationClientFile)this.openSpecificArchive(anArchive, disc);
    }

    public Archive openArchive(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        return this.openSpecificArchive(anArchive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        return this.openSpecificArchive(anArchive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        return this.openSpecificArchive(anArchive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public Archive openArchive(String uri, String extraClassPath) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        anArchive.setExtraClasspath(extraClassPath);
        return this.openSpecificArchive(anArchive, RootArchiveTypeDescriminatorImpl.singleton());
    }

    public EARFile openEARFile(ArchiveOptions options, String uri) throws OpenFailureException {
        boolean containsXMIBinding;
        String methodName = "openEARFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} }", uri);
        Archive anArchive = this.primOpenArchive(options, uri);
        ArchiveTypeDiscriminator disc = RootEARFileDescriminatorImpl.singleton();
        EARFile ear = (EARFile)this.openSpecificArchive(anArchive, disc);
        Application application = ear.getDeploymentDescriptor();
        if (application.getJ2EEVersionID() >= 50 && (containsXMIBinding = ear.containsFile("META-INF/ibm-application-bnd.xmi"))) {
            try {
                logger.logp(Level.FINER, className, methodName, "Removing XMI-based Bindings for JEE5 or higher application.");
                File appXMIBndFile = ear.getFile("META-INF/ibm-application-bnd.xmi");
                ear.remove(appXMIBndFile);
            }
            catch (FileNotFoundException fnfe) {
                logger.throwing(className, methodName, fnfe);
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", ear);
        return ear;
    }

    public EARFile openEARFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        ArchiveTypeDiscriminator disc = RootEARFileDescriminatorImpl.singleton();
        return (EARFile)this.openSpecificArchive(anArchive, disc);
    }

    public EARFile openEARFile(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        ArchiveTypeDiscriminator disc = RootEARFileDescriminatorImpl.singleton();
        return (EARFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJB11JarFile(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        ArchiveTypeDiscriminator disc = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJB11JarFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        ArchiveTypeDiscriminator disc = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJB11JarFile(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        ArchiveTypeDiscriminator disc = EjbJar11ImportStrategyImpl.getDiscriminator();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJBJarFile(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        RootEJBJarDescriminatorImpl disc = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJBJarFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        RootEJBJarDescriminatorImpl disc = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJBJarFile(LoadStrategy aLoadStrategy, String uri, String extraClassPath) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        anArchive.setExtraClasspath(extraClassPath);
        RootEJBJarDescriminatorImpl disc = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJBJarFile(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        RootEJBJarDescriminatorImpl disc = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public EJBJarFile openEJBJarFile(String uri, String extraClassPath) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        anArchive.setExtraClasspath(extraClassPath);
        RootEJBJarDescriminatorImpl disc = (RootEJBJarDescriminatorImpl)RootEJBJarDescriminatorImpl.singleton();
        return (EJBJarFile)this.openSpecificArchive(anArchive, disc);
    }

    public Archive openNestedArchive(LooseArchive loose, Archive parent) throws OpenFailureException {
        String methodName = "openNestedArchive - loose";
        String uri = loose.getUri();
        logger.entering(className, methodName, uri);
        LoadStrategy childStrategy = null;
        ArchiveOptions options = null;
        try {
            String binariesPath = loose.getBinariesPath();
            if (binariesPath == null) {
                logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.CommonArchiveFactory_binaries_path_missing_0, new Object[]{uri}));
                this.logLooseArchiveCharacteristics(Level.FINER, className, methodName, loose, parent);
                logger.exiting(className, methodName, "Throwing OpenFailureException");
                throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.open_nested_EXC_, new Object[]{uri, parent.getURI()}), null);
            }
            java.io.File file = new java.io.File(binariesPath);
            if (!file.exists() && parent != null) {
                childStrategy = ArchiveUtil.createExpandedLoadStrategy(uri, parent);
                childStrategy.setLooseArchivePrim(loose);
            } else {
                childStrategy = this.createLoadStrategy(binariesPath);
                childStrategy.setLooseArchive(loose);
            }
            options = parent.getOptions().cloneWith(childStrategy, loose.getUri());
            Archive a = this.openArchive(options, uri);
            logger.logp(Level.FINER, className, methodName, "RETURN primOpenArchive returned [ {0} ]", a);
            return a;
        }
        catch (IOException ex) {
            logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.CommonArchiveFactory_open_nested_archive_failure_0, new Object[]{ex.getMessage()}));
            this.logLooseArchiveCharacteristics(Level.FINER, className, methodName, loose, parent);
            logger.exiting(className, methodName, "Throwing OpenFailureException");
            throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.open_nested_EXC_, new Object[]{uri, parent.getURI()}), ex);
        }
    }

    public Archive openNestedArchive(String uri, Archive parent) throws OpenFailureException {
        return this.openNestedArchive(uri, parent, false);
    }

    public Archive openNestedArchive(String uri, Archive parent, boolean isBinariesBased) throws OpenFailureException {
        String methodName = "openNestedArchive";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", uri);
            if (parent != null) {
                logger.logp(Level.FINER, className, methodName, "Parent archive [ {0} ]", parent.getURI());
            } else {
                logger.logp(Level.SEVERE, className, methodName, "Parent archive is null (a NPE will result)");
            }
        }
        LoadStrategy childStrategy = null;
        ArchiveOptions options = null;
        try {
            childStrategy = this.createChildLoadStrategy(uri, parent.getLoadStrategy(), isBinariesBased);
            options = parent.getOptions().cloneWith(childStrategy, uri);
            if (options.shouldDiscriminateNestedArchives()) {
                Archive a = this.openArchive(options, uri);
                logger.logp(Level.FINER, className, methodName, "RETURN openArchive returned [ {0} ]", a);
                return a;
            }
            Archive a = this.primOpenArchive(options, uri);
            logger.logp(Level.FINER, className, methodName, "RETURN primOpenArchive returned [ {0} ]", a);
            return a;
        }
        catch (Exception ex) {
            logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.CommonArchiveFactory_open_nested_archive_failure_0, new Object[]{ex.getMessage()}));
            logger.throwing(className, methodName, ex);
            this.logArchiveCharacteristics(Level.FINER, className, methodName, parent);
            OpenFailureException e = new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.open_nested_EXC_, new Object[]{uri, parent.getURI()}), ex);
            logger.throwing(className, methodName, (Throwable)((Object)e));
            throw e;
        }
    }

    public RARFile openRARFile(ArchiveOptions options, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(options, uri);
        ArchiveTypeDiscriminator disc = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(anArchive, disc);
    }

    public RARFile openRARFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        ArchiveTypeDiscriminator disc = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(anArchive, disc);
    }

    public RARFile openRARFile(String uri) throws OpenFailureException {
        Archive anArchive = this.primOpenArchive(uri);
        ArchiveTypeDiscriminator disc = RarImportStrategyImpl.getDiscriminator();
        return (RARFile)this.openSpecificArchive(anArchive, disc);
    }

    public ReadOnlyDirectory openReadOnlyDirectory(String uri) throws IOException {
        java.io.File aFile = new java.io.File(uri);
        if (!aFile.exists()) {
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.could_not_find_dir_EXC_, new Object[]{uri}));
        }
        if (!aFile.isDirectory()) {
            throw new IOException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.not_a_dir_EXC_, new Object[]{uri}));
        }
        ReadOnlyDirectoryLoadStrategyImpl strategy = new ReadOnlyDirectoryLoadStrategyImpl(uri);
        ReadOnlyDirectory container = this.createReadOnlyDirectory();
        container.setURI(uri);
        container.setLoadStrategy(strategy);
        container.setLastModified(aFile.lastModified());
        return container;
    }

    protected Archive openSpecificArchive(Archive anArchive, ArchiveTypeDiscriminator disc) throws OpenFailureException {
        String methodName = "openSpecificArchive";
        String uri = anArchive.getURI();
        logger.entering(className, methodName, new Object[]{uri, disc});
        if (!disc.canImport(anArchive)) {
            anArchive.close();
            this.logArchiveCharacteristics(Level.FINER, className, methodName, anArchive);
            logger.exiting(className, methodName, "Throwing OpenFailureException");
            throw new OpenFailureException(disc.getUnableToOpenMessage());
        }
        Archive specificArchive = disc.openArchive(anArchive);
        specificArchive.initializeAfterOpen();
        this.logArchiveCharacteristics(Level.CONFIG, className, methodName, specificArchive);
        logger.exiting(className, methodName, specificArchive);
        return specificArchive;
    }

    protected Archive openSpecificArchive(Archive anArchive, RootEJBJarDescriminatorImpl disc) throws OpenFailureException {
        String methodName = "openSpecificArchive - ejbjar";
        String uri = anArchive.getURI();
        logger.entering(className, methodName, new Object[]{uri, disc});
        Archive specific = this.openSpecificArchive(anArchive, (ArchiveTypeDiscriminator)disc);
        if (specific == anArchive) {
            anArchive.close();
            this.logArchiveCharacteristics(Level.FINER, className, methodName, anArchive);
            logger.exiting(className, methodName, "Throwing OpenFailureException");
            throw new OpenFailureException(disc.getUnableToOpenMessage());
        }
        logger.exiting(className, methodName, specific);
        return specific;
    }

    public WARFile openWARFile(ArchiveOptions options, String uri) throws OpenFailureException {
        String methodName = "openWARFile - options";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", uri);
        Archive anArchive = this.primOpenArchive(options, uri);
        RootWarDescriminatorImpl disc = (RootWarDescriminatorImpl)RootWarDescriminatorImpl.singleton();
        WARFile war = (WARFile)this.openSpecificArchive(anArchive, disc);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", war);
        return war;
    }

    public WARFile openWARFile(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        String methodName = "openWARFile - LoadStrategy";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", uri);
        Archive anArchive = this.primOpenArchive(aLoadStrategy, uri);
        RootWarDescriminatorImpl disc = (RootWarDescriminatorImpl)RootWarDescriminatorImpl.singleton();
        WARFile war = (WARFile)this.openSpecificArchive(anArchive, disc);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", war);
        return war;
    }

    public WARFile openWARFile(String uri) throws OpenFailureException {
        String methodName = "openWARFile - uri";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", uri);
        Archive anArchive = this.primOpenArchive(uri);
        RootWarDescriminatorImpl disc = (RootWarDescriminatorImpl)RootWarDescriminatorImpl.singleton();
        WARFile war = (WARFile)this.openSpecificArchive(anArchive, disc);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", war);
        return war;
    }

    public Archive primOpenArchive(ArchiveOptions options, String uri) throws OpenFailureException {
        String methodName = "primOpenArchive";
        logger.entering(className, methodName, uri);
        if (options.getLoadStrategy() == null) {
            try {
                logger.logp(Level.FINER, className, methodName, "Create a LoadStrategy");
                options.setLoadStrategy(this.createLoadStrategy(uri));
            }
            catch (IOException ex) {
                logger.exiting(className, methodName, "Throwing OpenFailureException");
                throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.could_not_open_EXC_, new Object[]{uri}), ex);
            }
        }
        Archive anArchive = this.createArchive();
        anArchive.setURI(uri);
        anArchive.setOriginalURI(uri);
        anArchive.setLoadStrategy(options.getLoadStrategy());
        anArchive.setOptions(options);
        ArchiveTypeDiscriminatorRegistry.getInstance().contributeTypes(anArchive);
        logger.exiting(className, methodName, anArchive);
        return anArchive;
    }

    public Archive primOpenArchive(LoadStrategy aLoadStrategy, String uri) throws OpenFailureException {
        return this.primOpenArchive(this.defaultOptions(aLoadStrategy), uri);
    }

    public Archive primOpenArchive(String uri) throws OpenFailureException {
        return this.primOpenArchive(new ArchiveOptions(), uri);
    }

    public WARFile createWARFileGen() {
        WARFileImpl warFile = new WARFileImpl();
        return warFile;
    }

    public EJBJarFile createEJBJarFileGen() {
        EJBJarFileImpl ejbJarFile = new EJBJarFileImpl();
        return ejbJarFile;
    }

    public ApplicationClientFile createApplicationClientFileGen() {
        ApplicationClientFileImpl applicationClientFile = new ApplicationClientFileImpl();
        return applicationClientFile;
    }

    public EARFile createEARFileGen() {
        EARFileImpl earFile = new EARFileImpl();
        return earFile;
    }

    public RARFile createRARFileGen() {
        RARFileImpl rarFile = new RARFileImpl();
        return rarFile;
    }

    public File createFile() {
        FileImpl file = new FileImpl();
        return file;
    }

    public ReadOnlyDirectory createReadOnlyDirectory() {
        ReadOnlyDirectoryImpl readOnlyDirectory = new ReadOnlyDirectoryImpl();
        return readOnlyDirectory;
    }

    public CommonarchivePackage getCommonarchivePackage() {
        return (CommonarchivePackage)this.getEPackage();
    }

    public static CommonarchivePackage getPackage() {
        return CommonarchivePackage.eINSTANCE;
    }

    public EJBModuleRef createEJBModuleRefGen() {
        EJBModuleRefImpl ejbModuleRef = new EJBModuleRefImpl();
        return ejbModuleRef;
    }

    public WebModuleRef createWebModuleRefGen() {
        WebModuleRefImpl webModuleRef = new WebModuleRefImpl();
        return webModuleRef;
    }

    public ClientModuleRef createClientModuleRefGen() {
        ClientModuleRefImpl clientModuleRef = new ClientModuleRefImpl();
        return clientModuleRef;
    }

    public ConnectorModuleRef createConnectorModuleRefGen() {
        ConnectorModuleRefImpl connectorModuleRef = new ConnectorModuleRefImpl();
        return connectorModuleRef;
    }

    public ClientModuleRef createClientModuleRef(ApplicationClientFile clientFile) {
        ClientModuleRef ref = this.createClientModuleRef();
        ref.setModuleFile(clientFile);
        return ref;
    }

    public ConnectorModuleRef createConnectorModuleRef(RARFile rarFile) {
        ConnectorModuleRef ref = this.createConnectorModuleRef();
        ref.setModuleFile(rarFile);
        return ref;
    }

    public EJBModuleRef createEJBModuleRef(EJBJarFile ejbJarFile) {
        EJBModuleRef ref = this.createEJBModuleRef();
        ref.setModuleFile(ejbJarFile);
        return ref;
    }

    public WebModuleRef createWebModuleRef(WARFile warFile) {
        WebModuleRef ref = this.createWebModuleRef();
        ref.setModuleFile(warFile);
        return ref;
    }

    public Archive createArchive() {
        ArchiveImpl archive = new ArchiveImpl();
        return archive;
    }

    public ApplicationClientFile createApplicationClientFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createApplicationClientFile();
    }

    public ClientModuleRef createClientModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createClientModuleRef();
    }

    public ConnectorModuleRef createConnectorModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createConnectorModuleRef();
    }

    public EARFile createEARFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createEARFile();
    }

    public EJBJarFile createEJBJarFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createEJBJarFile();
    }

    public EJBModuleRef createEJBModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createEJBModuleRef();
    }

    public RARFile createRARFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createRARFile();
    }

    public WARFile createWARFile() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createWARFile();
    }

    public WebModuleRef createWebModuleRef() {
        return CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().createWebModuleRef();
    }

    public CommonarchiveFactory getDelegate() {
        return this.delegate;
    }

    private void logLooseArchiveCharacteristics(Level loglevel, String className, String methodName, LooseArchive loose, Archive parent) {
        if (!logger.isLoggable(loglevel)) {
            return;
        }
        StringBuffer sb = null;
        if (loose != null) {
            sb = new StringBuffer("Loose Archive [ ").append(loose.getUri()).append(" ] characteristics:\n");
            sb.append("\n\nLoose Archive [ ").append(loose).append(" ]");
            sb.append("\n    Loose Archive URI    [ ").append(loose.getUri()).append(" ]");
            String path = loose.getBinariesPath();
            sb.append("\n        Binaries Path    [ ").append(this.confirmedPath(path)).append(" ]");
            path = loose.getResourcesPath();
            sb.append("\n        Resources Path   [ ").append(this.confirmedPath(path)).append(" ]");
            LooseApplication looseApp = loose.getLooseApp();
            sb.append("\n        Loose App        [ ").append(looseApp).append(" ]");
            if (looseApp != null) {
                sb.append("\n            App URI      [ ").append(looseApp.getUri()).append(" ]");
                path = looseApp.getBinariesPath();
                sb.append("\n            Binaries Path[ ").append(this.confirmedPath(path)).append(" ]");
                path = looseApp.getResourcesPath();
                sb.append("\n            ResourcesPath[ ").append(this.confirmedPath(path)).append(" ]");
            }
        } else {
            sb = new StringBuffer("Loose Archive is null");
        }
        logger.logp(loglevel, className, methodName, sb.toString());
        this.logArchiveCharacteristics(loglevel, className, methodName, parent);
    }

    private void logArchiveCharacteristics(Level loglevel, String className, String methodName, Archive archive) {
        if (!logger.isLoggable(loglevel)) {
            return;
        }
        StringBuffer sb = null;
        if (archive != null) {
            String path;
            sb = new StringBuffer("Archive [ ").append(archive.getURI()).append(" ] characteristics:\n");
            sb.append("\n\nArchive                               [ ").append(archive.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append(" ]");
            sb.append("\n    Archive URI                       [ ").append(archive.getURI()).append(" ]");
            sb.append("\n        isOpen                        [ ").append(archive.isOpen()).append(" ]");
            try {
                path = archive.getAbsolutePath();
                sb.append("\n        Absolute Path                 [ ").append(this.confirmedPath(path)).append(" ]");
            }
            catch (FileNotFoundException e1) {
                sb.append("\n        Absolute Path                 [ unknown ]");
            }
            try {
                path = archive.getBinariesPath();
                sb.append("\n        Binaries Path                 [ ").append(this.confirmedPath(path)).append(" ]");
            }
            catch (FileNotFoundException e1) {
                sb.append("\n        Binaries Path                 [ unknown ]");
            }
            try {
                path = archive.getResourcesPath();
                sb.append("\n        Resources Path                [ ").append(this.confirmedPath(path)).append(" ]");
            }
            catch (FileNotFoundException e) {
                sb.append("\n        Resources Path                [ unknown ]");
            }
            ArchiveOptions ao = archive.getOptions();
            sb.append("\n        Archive Options               [ ").append(ao).append(" ]");
            if (ao != null) {
                String path2 = ao.getParentEarBinariesPath();
                sb.append("\n            EAR ParentEarBinariesPath [ ").append(this.confirmedPath(path2)).append(" ]");
                if (ao.isSetAltBinariesPath()) {
                    path2 = ao.getAltBinariesPath();
                    sb.append("\n            EAR AltBinariesPath       [ ").append(this.confirmedPath(path2)).append(" ]");
                } else {
                    sb.append("\n            EAR AltBinariesPath       [ <unset> ]");
                }
                sb.append("\n            Use Java Reflection       [ ").append(ao.useJavaReflection()).append(" ]");
            }
            if (archive.isOpen()) {
                ArchiveManifest m = archive.getManifest();
                sb.append("\n        Manifest                      [ ").append(m).append(" ]");
                if (m != null) {
                    sb.append("\n            Manifest classpath        [ ").append(m.getClassPath()).append(" ]");
                }
            }
            LoadStrategy loadStrategy = archive.getLoadStrategy();
            sb.append("\n        Load Strategy                 [ ").append(loadStrategy).append(" ]");
        } else {
            sb = new StringBuffer("Archive is null");
        }
        sb.append("\n    ArchiveImpl                       [ ").append("@(#) 1.29 IES/ws/code/jst.j2ee.core.archive/src/org/eclipse/jst/j2ee/commonarchivecore/internal/impl/CommonarchiveFactoryImpl.java, WAS.prereq.ies, CC70.IES, q0834.07 8/24/08 06:46:36 [8/27/08 15:17:21]").append(" ]\n");
        logger.logp(loglevel, className, methodName, sb.toString());
        ArchiveUtil.dumpStackTrace(className, methodName);
    }

    private String confirmedPath(String path) {
        java.io.File ioFile;
        if (path != null && !(ioFile = new java.io.File(path)).exists()) {
            java.io.File parentFile = new java.io.File(ioFile.getParent());
            if (parentFile.exists() && parentFile.isFile()) {
                return "FILE DOES NOT EXIST (but parent file does) : " + path;
            }
            return "FILE DOES NOT EXIST : " + path;
        }
        return path;
    }

    static {
        CommonarchiveFactoryImpl.initPrereqs();
    }
}

