/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.helpers;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.LifeCycleTrackerElement;

public class LifeCycleTracker {
    protected static String className = LifeCycleTracker.class.getName();
    private Hashtable singleton = new Hashtable();
    private Logger loggerLCT;

    public LifeCycleTracker() {
        this.loggerLCT = Logger.getLogger("com.ibm.config.eclipse.wtp.lct");
    }

    public LifeCycleTracker(String targetLogger) {
        this.loggerLCT = Logger.getLogger(targetLogger);
    }

    public LifeCycleTracker(Logger initializedLogger) {
        this.loggerLCT = initializedLogger;
    }

    public String add(Object value) {
        String methodName = "add(Object)";
        String hash = String.valueOf(value.hashCode());
        this.loggerLCT.logp(Level.FINEST, className, methodName, "Hash: " + hash);
        if (hash == null) {
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Object cannot be added.  Null hash.");
        } else {
            if (!this.singleton.containsKey(hash)) {
                this.singleton.put(hash, value);
                this.loggerLCT.logp(Level.FINEST, className, methodName, "Object added.");
                return hash;
            }
            if (this.singleton.get(hash).equals(value)) {
                this.loggerLCT.logp(Level.FINEST, className, methodName, "Object already added.");
            } else {
                this.loggerLCT.logp(Level.FINEST, className, methodName, "Conflicting hashes.");
                this.loggerLCT.logp(Level.FINEST, className, methodName, "Stored Object: " + this.singleton.get(hash));
                hash = null;
            }
        }
        return hash;
    }

    public String add(String hash, Object value) {
        String methodName = "add(String,Object)";
        this.loggerLCT.logp(Level.FINEST, className, methodName, "Hash: " + hash);
        if (hash == null) {
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Object cannot be added.  Null hash.");
        } else if (!this.singleton.containsKey(hash)) {
            this.singleton.put(hash, value);
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Object added.");
        } else if (this.singleton.get(hash).equals(value)) {
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Object already added.");
        } else {
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Conflicting hashes.");
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Stored Object: " + this.singleton.get(hash));
            hash = null;
        }
        return hash;
    }

    public void remove(Object value) {
        String methodName = "remove(Object)";
        String hash = String.valueOf(value.hashCode());
        this.loggerLCT.logp(Level.FINEST, className, methodName, "Hash: " + hash);
        if (hash == null) {
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Object cannot be removed.  Null hash.");
        } else if (this.singleton.containsKey(hash)) {
            this.singleton.remove(hash);
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Object removed.");
        } else {
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Object not present.");
        }
    }

    public void remove(String hash) {
        String methodName = "remove(String)";
        this.loggerLCT.logp(Level.FINEST, className, methodName, "Hash: " + hash);
        if (hash == null) {
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Object cannot be removed.  Null hash.");
        } else if (this.singleton.containsKey(hash)) {
            this.singleton.remove(hash);
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Object removed.");
        } else {
            this.loggerLCT.logp(Level.FINEST, className, methodName, "Object not present.");
        }
    }

    public String printHash() {
        return this.printHash(null);
    }

    public String printHash(String selector) {
        Enumeration singletonEnum = this.singleton.keys();
        StringBuffer sb = new StringBuffer();
        while (singletonEnum.hasMoreElements()) {
            String hash = (String)singletonEnum.nextElement();
            LifeCycleTrackerElement val = (LifeCycleTrackerElement)this.singleton.get(hash);
            if (selector != null && !val.matches(selector)) continue;
            sb.append("\n  Hash : ").append(hash).append("\n");
            sb.append(val);
        }
        String msg = sb.toString();
        return msg;
    }
}

