/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.impl;

import java.net.URI;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.higgins.sts.IAddressingInformation;
import org.eclipse.higgins.sts.IAppliesTo;
import org.eclipse.higgins.sts.IAppliesToMapping;
import org.eclipse.higgins.sts.IConstants;
import org.eclipse.higgins.sts.IEndpointReference;
import org.eclipse.higgins.sts.IRequestSecurityToken;
import org.eclipse.higgins.sts.ISTSRequest;
import org.eclipse.higgins.sts.ISTSResponse;
import org.eclipse.higgins.sts.impl.ExtensionMappingKey;
import org.eclipse.higgins.sts.impl.Fault;
import org.eclipse.higgins.sts.server.ISecurityTokenService;
import org.eclipse.higgins.sts.server.ISecurityTokenServiceExtension;
import org.eclipse.higgins.sts.utilities.ExceptionHelper;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.ObjectFactoryHelper;
import org.eclipse.higgins.sts.utilities.URIHelper;

public class SecurityTokenService
implements ISecurityTokenService {
    private final LogHelper log = new LogHelper(SecurityTokenService.class.getName());
    private Hashtable htExtensionConfiguration2Class = new Hashtable();
    private Map mapAppliesTo2AppliesToMapping = null;
    private Map mapExtensionMappingKey2Configuration = null;
    private boolean bInitialized = false;

    protected SecurityTokenService() throws Exception {
        this.log.trace("SecurityTokenService::SecurityTokenService");
    }

    public void initialize() {
        this.log.trace("CancelHandler::initialize");
    }

    public void destroy() {
        this.log.trace("SecurityTokenService::destroy");
    }

    public void configure(Map map, Map map2, Map map3, Map map4) throws Exception {
        this.log.trace("SecurityTokenService::initialize");
        this.mapAppliesTo2AppliesToMapping = map;
        this.mapExtensionMappingKey2Configuration = map2;
        this.bInitialized = false;
        Set set = map3.keySet();
        for (String string : set) {
            String string2 = (String)map3.get(string);
            this.log.trace("Loading Extension: " + string);
            this.log.trace(" Class: " + string2);
            if (null == string2) {
                this.log.error("No Extension Factory Class Mapped for Configuration: " + string);
                return;
            }
            try {
                ISecurityTokenServiceExtension iSecurityTokenServiceExtension = (ISecurityTokenServiceExtension)ObjectFactoryHelper.getFromFactory(string2);
                if (null == iSecurityTokenServiceExtension) {
                    this.log.error("Failed to load Extension Factory Class: " + string2);
                    return;
                }
                Map map5 = (Map)map4.get(string);
                if (null == map5) {
                    this.log.error("No Configuration Properties Mapped for Configuration: " + string);
                    return;
                }
                iSecurityTokenServiceExtension.initialize();
                iSecurityTokenServiceExtension.configure(map5);
                this.log.trace("Extension Configuration: " + string + " Instance: " + iSecurityTokenServiceExtension.toString());
                this.htExtensionConfiguration2Class.put(string, iSecurityTokenServiceExtension);
            }
            catch (Exception exception) {
                ExceptionHelper.Log(this.log, exception);
                throw exception;
            }
        }
        this.bInitialized = true;
        this.log.trace("SecurityTokenService::initialize DONE");
    }

    public void invoke(ISTSRequest iSTSRequest, ISTSResponse iSTSResponse, IConstants iConstants) {
        this.log.trace("SecurityTokenService::invoke");
        if (!this.bInitialized) {
            this.log.error("Not Initialized");
            Fault fault = new Fault(iConstants.getWSTrustNamespace(), "wst", iConstants.getRequestFailedFaultCode(), "The specified request failed", "Not initialized.");
            iSTSResponse.setFault(fault);
            return;
        }
        String string = this.getHandlerConfiguration(iSTSRequest, iConstants);
        ISecurityTokenServiceExtension iSecurityTokenServiceExtension = null;
        if (null == string) {
            this.log.error("No Configuration Found.");
            Fault fault = new Fault(iConstants.getWSTrustNamespace(), "wst", iConstants.getRequestFailedFaultCode(), "The specified request failed", "No Configuration Found.");
            iSTSResponse.setFault(fault);
            return;
        }
        iSecurityTokenServiceExtension = (ISecurityTokenServiceExtension)this.htExtensionConfiguration2Class.get(string);
        this.log.trace("Instance: " + iSecurityTokenServiceExtension.toString());
        if (null != iSecurityTokenServiceExtension) {
            iSecurityTokenServiceExtension.invoke(iSTSRequest, iSTSResponse, iConstants);
        } else {
            this.log.error("No Extension for Configuration.");
            Fault fault = new Fault(iConstants.getWSTrustNamespace(), "wst", iConstants.getRequestFailedFaultCode(), "The specified request failed", "No Extension for Configuration.");
            iSTSResponse.setFault(fault);
        }
    }

    public String getHandlerConfiguration(ISTSRequest iSTSRequest, IConstants iConstants) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        this.log.trace("SecurityTokenService::getHandlerConfiguration");
        if (!this.bInitialized) {
            this.log.error("Not Initialized");
            return null;
        }
        List list = iSTSRequest.getRequestSecurityTokenCollection();
        IRequestSecurityToken iRequestSecurityToken = (IRequestSecurityToken)list.get(0);
        URI uRI = iRequestSecurityToken.getTokenType();
        URI uRI2 = iRequestSecurityToken.getRequestType();
        IAppliesTo iAppliesTo = iRequestSecurityToken.getAppliesTo();
        IAddressingInformation iAddressingInformation = iSTSRequest.getAddressingInformation();
        URI uRI3 = null;
        if (null != iAddressingInformation) {
            uRI3 = iAddressingInformation.getAction();
        }
        IEndpointReference iEndpointReference = iRequestSecurityToken.getIssuer();
        URI uRI4 = null;
        if (null != iEndpointReference) {
            uRI4 = iEndpointReference.getAddress();
        }
        if ((string = iRequestSecurityToken.getContext()) != null) {
            this.log.trace("Context: " + string);
        }
        if (null != uRI3) {
            this.log.trace("Action: " + uRI3.toString());
        }
        String string2 = null;
        if (uRI2 != null) {
            string2 = uRI2.toString();
            this.log.trace("RequestType: " + string2);
        }
        if (iAppliesTo != null) {
            object4 = iAppliesTo.getEndpointReference();
            object3 = object4.getAddress();
            this.log.trace("AppliesTo: " + ((URI)object3).toString() + "(" + ((URI)object3).hashCode() + ")");
            object2 = (IAppliesToMapping)this.mapAppliesTo2AppliesToMapping.get(object3);
            if (null == object2) {
                this.log.trace("No Mapping Found - trying wildcard mapping");
                object = URIHelper.toURI("urn:any");
                object2 = (IAppliesToMapping)this.mapAppliesTo2AppliesToMapping.get(object);
            }
            if (null != object2) {
                uRI = object2.getTokenType();
                uRI4 = object2.getIssuer();
            }
        }
        if (null != uRI) {
            this.log.trace("TokenType: " + uRI.toString());
        }
        if (null != uRI4) {
            this.log.trace("Issuer: " + uRI4.toString() + "(" + uRI4.hashCode() + ")");
        }
        object4 = new ExtensionMappingKey(uRI3, uRI, uRI2, uRI4);
        if (null != uRI3) {
            this.log.trace("Action: " + uRI3.toString() + "(" + uRI3.hashCode() + ")");
        } else {
            this.log.trace("Action: (null)");
        }
        if (null != uRI) {
            this.log.trace(" TokenType: " + uRI.toString() + "(" + uRI.hashCode() + ")");
        } else {
            this.log.trace(" TokenType: (null)");
        }
        if (null != uRI4) {
            this.log.trace(" Issuer: " + uRI4.toString() + "(" + uRI4.hashCode() + ")");
        } else {
            this.log.trace(" Issuer: (null)");
        }
        if (null != uRI2) {
            this.log.trace(" RequestType: " + uRI2.toString() + "(" + uRI2.hashCode() + ")");
        } else {
            this.log.trace(" RequestType: (null)");
        }
        this.log.trace(" Hashcode: " + object4.hashCode());
        object3 = (String)this.mapExtensionMappingKey2Configuration.get(object4);
        if (null == object3) {
            object2 = this.htExtensionConfiguration2Class.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                ISecurityTokenServiceExtension iSecurityTokenServiceExtension = (ISecurityTokenServiceExtension)this.htExtensionConfiguration2Class.get(object);
                if (!iSecurityTokenServiceExtension.canHandle(iSTSRequest, iConstants)) continue;
                object3 = object;
                break;
            }
        }
        return object3;
    }
}

