/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.RMHeaderPart;

public class SequenceAcknowledgement
implements RMHeaderPart {
    private Identifier identifier;
    private ArrayList acknowledgementRangeList;
    private ArrayList nackList;
    private String namespaceValue = null;
    private OMNamespace omNamespace = null;
    private boolean ackNone = false;
    private boolean ackFinal = false;
    private OMElement originalSequenceAckElement;

    public SequenceAcknowledgement(String namespaceValue) {
        this.namespaceValue = namespaceValue;
        this.omNamespace = "http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceValue) ? Sandesha2Constants.SPEC_2005_02.OM_NS_URI : Sandesha2Constants.SPEC_2007_02.OM_NS_URI;
        this.acknowledgementRangeList = new ArrayList();
        this.nackList = new ArrayList();
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromHeaderBlock(SOAPHeaderBlock sequenceAckElement) throws OMException, SandeshaException {
        this.originalSequenceAckElement = sequenceAckElement;
        OMElement identifierPart = null;
        Iterator childElements = sequenceAckElement.getChildElements();
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            String elementNamespace = element.getQName().getNamespaceURI();
            String elementLocalName = element.getQName().getLocalPart();
            if (!this.namespaceValue.equals(elementNamespace)) continue;
            if ("AcknowledgementRange".equals(elementLocalName)) {
                String lowerAttribValue = element.getAttributeValue(new QName("Lower"));
                String upperAttribValue = element.getAttributeValue(new QName("Upper"));
                if (lowerAttribValue == null || upperAttribValue == null) {
                    throw new OMException(SandeshaMessageHelper.getMessage("noUpperOrLowerAttributesInElement", ((Object)element).toString()));
                }
                try {
                    long lower = Long.parseLong(lowerAttribValue);
                    long upper = Long.parseLong(upperAttribValue);
                    this.acknowledgementRangeList.add(new Range(lower, upper));
                    continue;
                }
                catch (Exception ex) {
                    throw new OMException(SandeshaMessageHelper.getMessage("ackRandDoesNotHaveCorrectValues", ((Object)element).toString()));
                }
            }
            if ("Nack".equals(elementLocalName)) {
                try {
                    Long nack = Long.valueOf(element.getText());
                    this.nackList.add(nack);
                    continue;
                }
                catch (Exception ex) {
                    throw new OMException(SandeshaMessageHelper.getMessage("nackDoesNotContainValidLongValue"));
                }
            }
            if ("Identifier".equals(elementLocalName)) {
                identifierPart = element;
                continue;
            }
            String rmSpecVersion = SpecSpecificConstants.getSpecVersionString(this.namespaceValue);
            if (SpecSpecificConstants.isAckFinalAllowed(rmSpecVersion) && "Final".equals(elementLocalName)) {
                this.ackFinal = true;
            }
            if (!SpecSpecificConstants.isAckNoneAllowed(rmSpecVersion) || !"None".equals(elementLocalName)) continue;
            this.ackNone = true;
        }
        this.identifier = new Identifier(this.namespaceValue);
        this.identifier.fromOMElement(identifierPart);
        sequenceAckElement.setProcessed();
        return this;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void setAckRanges(ArrayList acknowledgementRagngesList) {
        this.acknowledgementRangeList = acknowledgementRagngesList;
    }

    public Long addNack(Long nack) {
        this.nackList.add(nack);
        return nack;
    }

    public Range addAcknowledgementRanges(Range ackRange) {
        this.acknowledgementRangeList.add(ackRange);
        return ackRange;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public List getAcknowledgementRanges() {
        return this.acknowledgementRangeList;
    }

    public List getNackList() {
        return this.nackList;
    }

    public boolean getAckFinal() {
        return this.ackFinal;
    }

    public void setAckFinal(boolean ackFinal) {
        this.ackFinal = ackFinal;
    }

    public boolean getAckNone() {
        return this.ackNone;
    }

    public void setAckNone(boolean ackNone) {
        this.ackNone = ackNone;
    }

    public OMElement getOriginalSequenceAckElement() {
        return this.originalSequenceAckElement;
    }

    public void toHeader(SOAPHeader header) throws SandeshaException {
        SOAPHeaderBlock sequenceAcknowledgementHeaderBlock = header.addHeaderBlock("SequenceAcknowledgement", this.omNamespace);
        if (this.identifier == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("invalidIdentifier", header.toString()));
        }
        sequenceAcknowledgementHeaderBlock.setMustUnderstand(true);
        this.identifier.toOMElement(sequenceAcknowledgementHeaderBlock, this.omNamespace);
        for (Range ackRange : this.acknowledgementRangeList) {
            if (ackRange.upperValue <= 0L || ackRange.lowerValue <= 0L || ackRange.lowerValue > ackRange.upperValue) {
                throw new OMException(SandeshaMessageHelper.getMessage("ackRandDoesNotHaveCorrectValues", ackRange.upperValue + ":" + ackRange.lowerValue));
            }
            OMFactory factory = sequenceAcknowledgementHeaderBlock.getOMFactory();
            OMAttribute lowerAttrib = factory.createOMAttribute("Lower", null, Long.toString(ackRange.lowerValue));
            OMAttribute upperAttrib = factory.createOMAttribute("Upper", null, Long.toString(ackRange.upperValue));
            OMElement acknowledgementRangeElement = factory.createOMElement("AcknowledgementRange", this.omNamespace);
            acknowledgementRangeElement.addAttribute(lowerAttrib);
            acknowledgementRangeElement.addAttribute(upperAttrib);
            sequenceAcknowledgementHeaderBlock.addChild(acknowledgementRangeElement);
        }
        for (Long nack : this.nackList) {
            if (nack <= 0L) {
                throw new OMException(SandeshaMessageHelper.getMessage("nackDoesNotContainValidLongValue"));
            }
            OMElement nackElement = sequenceAcknowledgementHeaderBlock.getOMFactory().createOMElement("Nack", this.omNamespace);
            nackElement.setText(nack.toString());
            sequenceAcknowledgementHeaderBlock.addChild(nackElement);
        }
        String rmSpecVersion = SpecSpecificConstants.getSpecVersionString(this.namespaceValue);
        if (!this.ackNone && this.acknowledgementRangeList.size() == 0 && this.nackList.size() == 0 && SpecSpecificConstants.isAckNoneAllowed(rmSpecVersion)) {
            this.ackNone = true;
        }
        if (this.ackNone) {
            if (!SpecSpecificConstants.isAckNoneAllowed(rmSpecVersion)) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("noneNotAllowedNamespace", rmSpecVersion));
            }
            if (this.acknowledgementRangeList.size() > 0) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("noneNotAllowedAckRangesPresent"));
            }
            if (this.nackList.size() > 0) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("noneNotAllowedNackPresent"));
            }
            OMElement noneElement = sequenceAcknowledgementHeaderBlock.getOMFactory().createOMElement("None", this.omNamespace);
            sequenceAcknowledgementHeaderBlock.addChild(noneElement);
        }
        if (this.ackFinal) {
            if (!SpecSpecificConstants.isAckFinalAllowed(rmSpecVersion)) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("finalNotAllowedNamespace"));
            }
            if (this.nackList.size() > 0) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotHaveFinalWithNack"));
            }
            OMElement finalElement = sequenceAcknowledgementHeaderBlock.getOMFactory().createOMElement("Final", this.omNamespace);
            sequenceAcknowledgementHeaderBlock.addChild(finalElement);
        }
    }
}

