/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;

public class MakeConnection
implements IOMRMPart {
    Identifier identifier = null;
    String address = null;
    QName unexpectedElement = null;

    public void toSOAPEnvelope(SOAPEnvelope envelope) {
        SOAPBody body = envelope.getBody();
        OMElement elem = body.getFirstChildWithName(new QName("http://docs.oasis-open.org/ws-rx/wsmc/200702", "MakeConnection"));
        if (elem != null) {
            elem.detach();
        }
        this.toOMElement(body);
    }

    public Object fromOMElement(OMElement makeConnectionElement) throws OMException, AxisFault {
        Iterator childElements = makeConnectionElement.getChildElements();
        OMElement identifierElement = null;
        OMElement addressElement = null;
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            if (Sandesha2Constants.SPEC_2007_02.QNames.Identifier.getLocalPart().equals(element.getLocalName())) {
                identifierElement = element;
                continue;
            }
            if ("Address".equals(element.getLocalName())) {
                addressElement = element;
                continue;
            }
            this.unexpectedElement = element.getQName();
        }
        if (identifierElement != null) {
            this.identifier = new Identifier(identifierElement.getNamespace().getNamespaceURI());
            this.identifier.fromOMElement(identifierElement);
        }
        if (addressElement != null) {
            this.address = addressElement.getText();
            if (this.address == null || "".equals(this.address)) {
                throw new OMException(SandeshaMessageHelper.getMessage("cannotFindAddressText", ((Object)addressElement).toString()));
            }
        }
        return this;
    }

    public OMElement toOMElement(OMElement body) throws OMException {
        if (body == null || !(body instanceof SOAPBody)) {
            String message = "MakeConnection element can only be added to a SOAP Body ";
            throw new OMException(SandeshaMessageHelper.getMessage(message));
        }
        OMFactory factory = body.getOMFactory();
        OMElement makeConnectionElement = factory.createOMElement("MakeConnection", Sandesha2Constants.SPEC_2007_02.OM_MC_NS_URI);
        if (this.identifier != null) {
            this.identifier.toOMElement(makeConnectionElement, Sandesha2Constants.SPEC_2007_02.OM_NS_URI);
        }
        if (this.address != null) {
            if (this.address == null || this.address.length() == 0) {
                throw new OMException(SandeshaMessageHelper.getMessage("addressNotValid"));
            }
            OMElement addressElement = factory.createOMElement("Address", Sandesha2Constants.SPEC_2007_02.OM_MC_NS_URI);
            addressElement.setText(this.address);
            makeConnectionElement.addChild(addressElement);
        }
        if (this.unexpectedElement != null) {
            OMElement unexElement = factory.createOMElement(this.unexpectedElement);
            makeConnectionElement.addChild(unexElement);
        }
        body.addChild(makeConnectionElement);
        return body;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void setUnexpectedElement(QName unexpectedElement) {
        this.unexpectedElement = unexpectedElement;
    }

    public QName getUnexpectedElement() {
        return this.unexpectedElement;
    }

    public String getNamespaceValue() {
        return "http://docs.oasis-open.org/ws-rx/wsmc/200702";
    }

    public boolean isNamespaceSupported(String namespaceName) {
        return "http://docs.oasis-open.org/ws-rx/wsmc/200702".equals(namespaceName);
    }
}

