/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.OperationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.MessageRetransmissionAdjuster;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.SandeshaWorker;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.Sequence;
import org.apache.sandesha2.wsrm.TerminateSequence;

public class SenderWorker
extends SandeshaWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(SenderWorker.class);
    private ConfigurationContext configurationContext = null;
    private SenderBean senderBean = null;
    private RMMsgContext messageToSend = null;
    private String rmVersion = null;

    public SenderWorker(ConfigurationContext configurationContext, SenderBean senderBean, String rmVersion) {
        this.configurationContext = configurationContext;
        this.senderBean = senderBean;
        this.rmVersion = rmVersion;
    }

    public void setMessage(RMMsgContext msg) {
        this.messageToSend = msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block77: {
            if (SenderWorker.log.isDebugEnabled()) {
                SenderWorker.log.debug("Enter: SenderWorker::run");
            }
            if (this.lock != null && !this.lock.ownsLock(this.workId, this)) {
                if (SenderWorker.log.isDebugEnabled() == false) return;
                SenderWorker.log.debug("Exit: SenderWorker::run, another worker holds the lock");
                return;
            }
            transaction = null;
            try {
                block85: {
                    block84: {
                        block83: {
                            block82: {
                                block81: {
                                    block79: {
                                        block80: {
                                            block78: {
                                                storageManager = SandeshaUtil.getSandeshaStorageManager(this.configurationContext, this.configurationContext.getAxisConfiguration());
                                                senderBeanMgr = storageManager.getSenderBeanMgr();
                                                transaction = storageManager.getTransaction();
                                                key = this.senderBean.getMessageContextRefKey();
                                                msgCtx = null;
                                                rmMsgCtx = null;
                                                if (this.messageToSend == null) break block78;
                                                msgCtx = this.messageToSend.getMessageContext();
                                                rmMsgCtx = this.messageToSend;
                                                break block79;
                                            }
                                            msgCtx = storageManager.retrieveMessageContext(key, this.configurationContext);
                                            if (msgCtx != null) break block80;
                                            if (transaction != null && transaction.isActive()) {
                                                transaction.commit();
                                            }
                                            transaction = null;
                                            var24_8 = null;
                                            if (this.lock != null && this.workId != null) {
                                                this.lock.removeWork(this.workId);
                                            }
                                            if (transaction == null) return;
                                            if (transaction.isActive() == false) return;
                                            ** GOTO lbl245
                                        }
                                        rmMsgCtx = MsgInitializer.initializeMessage(msgCtx);
                                    }
                                    qualifiedForSending = (String)msgCtx.getProperty("Sandesha2QualifiedForSending");
                                    if (qualifiedForSending == null || qualifiedForSending.equals("true")) break block81;
                                    if (SenderWorker.log.isDebugEnabled()) {
                                        SenderWorker.log.debug("Exit: SenderWorker::run, !qualified for sending");
                                    }
                                    if (transaction != null && transaction.isActive()) {
                                        transaction.commit();
                                        transaction = null;
                                    }
                                    ** GOTO lbl252
                                }
                                if (msgCtx != null) break block82;
                                if (SenderWorker.log.isDebugEnabled()) {
                                    SenderWorker.log.debug(SandeshaMessageHelper.getMessage("sendHasUnavailableMsgEntry"));
                                }
                                if (transaction != null && transaction.isActive()) {
                                    transaction.commit();
                                    transaction = null;
                                }
                                ** GOTO lbl264
                            }
                            msgsNotToSend = SandeshaUtil.getPropertyBean(msgCtx.getAxisOperation()).getMsgTypesToDrop();
                            if (msgsNotToSend == null || !msgsNotToSend.contains(new Integer(rmMsgCtx.getMessageType()))) break block83;
                            if (SenderWorker.log.isDebugEnabled()) {
                                SenderWorker.log.debug("Exit: SenderWorker::run, message type to be dropped " + rmMsgCtx.getMessageType());
                            }
                            if (transaction != null && transaction.isActive()) {
                                transaction.commit();
                                transaction = null;
                            }
                            ** GOTO lbl276
                        }
                        makeConnection = (Boolean)msgCtx.getProperty("MakeConnectionResponse");
                        toEPR = msgCtx.getTo();
                        inMsg = null;
                        op = msgCtx.getOperationContext();
                        t = (RequestResponseTransport)msgCtx.getProperty("RequestResponseTransportControl");
                        if (t == null) {
                            if (op != null) {
                                inMsg = op.getMessageContext("In");
                            }
                            if (inMsg != null) {
                                t = (RequestResponseTransport)inMsg.getProperty("RequestResponseTransportControl");
                            }
                        }
                        if (toEPR != null && !toEPR.hasAnonymousAddress() || makeConnection != null && makeConnection.booleanValue() || t != null && t.getStatus().equals(RequestResponseTransport.RequestResponseTransportStatus.WAITING)) break block84;
                        bean = senderBeanMgr.retrieve(this.senderBean.getMessageID());
                        if (bean != null && bean.isTransportAvailable()) {
                            bean.setTransportAvailable(false);
                            senderBeanMgr.update(bean);
                        }
                        if (transaction != null && transaction.isActive()) {
                            transaction.commit();
                        }
                        transaction = null;
                        if (SenderWorker.log.isDebugEnabled()) {
                            SenderWorker.log.debug("Exit: SenderWorker::run, no response transport for anonymous message");
                        }
                        ** GOTO lbl288
                    }
                    messageType = this.senderBean.getMessageType();
                    if (this.isAckPiggybackableMsgType(messageType)) {
                        if (transaction != null && transaction.isActive()) {
                            transaction.commit();
                        }
                        transaction = storageManager.getTransaction();
                        AcknowledgementManager.piggybackAcksIfPresent(rmMsgCtx, storageManager);
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    if ((transaction = storageManager.getTransaction()) != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = storageManager.getTransaction();
                    this.senderBean = this.updateMessage(rmMsgCtx, this.senderBean, storageManager);
                    if (this.senderBean != null) break block85;
                    if (SenderWorker.log.isDebugEnabled()) {
                        SenderWorker.log.debug("Exit: SenderWorker::run, !continueSending");
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.rollback();
                        transaction = null;
                    }
                    ** GOTO lbl300
                }
                if (this.senderBean.isReSend()) {
                    senderBeanMgr.update(this.senderBean);
                }
                successfullySent = false;
                if (3 != this.senderBean.getMessageType()) {
                    if (SenderWorker.log.isDebugEnabled()) {
                        SenderWorker.log.debug("Redecorate EPR : " + msgCtx.getEnvelope().getHeader());
                    }
                    if ((replyToEPR = msgCtx.getReplyTo()) != null) {
                        replyToEPR = SandeshaUtil.getEPRDecorator(msgCtx.getConfigurationContext()).decorateEndpointReference(replyToEPR);
                        msgCtx.setReplyTo(replyToEPR);
                    }
                }
                if (transaction != null) {
                    transaction.commit();
                    transaction = null;
                }
                msgCtx.getOptions().setTimeOutInMilliSeconds(1000000L);
                processResponseForFaults = false;
                try {
                    response = Handler.InvocationResponse.CONTINUE;
                    if (storageManager.requiresMessageSerialization()) {
                        if (msgCtx.isPaused()) {
                            if (SenderWorker.log.isDebugEnabled()) {
                                SenderWorker.log.debug("Resuming a send for message : " + msgCtx.getEnvelope().getHeader());
                            }
                            msgCtx.setPaused(false);
                            msgCtx.setProperty("transportNonBlocking", Boolean.FALSE);
                            response = AxisEngine.resumeSend(msgCtx);
                        } else {
                            if (SenderWorker.log.isDebugEnabled()) {
                                SenderWorker.log.debug("Sending a message : " + msgCtx.getEnvelope().getHeader());
                            }
                            msgCtx.setProperty("transportNonBlocking", Boolean.FALSE);
                            AxisEngine.send(msgCtx);
                        }
                    } else {
                        retransmittablePhases = (ArrayList)msgCtx.getProperty("RMRetransmittablePhases");
                        if (retransmittablePhases != null) {
                            msgCtx.setExecutionChain(retransmittablePhases);
                        } else {
                            emptyExecutionChain = new ArrayList<E>();
                            msgCtx.setExecutionChain(emptyExecutionChain);
                        }
                        msgCtx.setCurrentHandlerIndex(0);
                        msgCtx.setCurrentPhaseIndex(0);
                        msgCtx.setPaused(false);
                        if (SenderWorker.log.isDebugEnabled()) {
                            SenderWorker.log.debug("Resuming a send for message : " + msgCtx.getEnvelope().getHeader());
                        }
                        msgCtx.setProperty("transportNonBlocking", Boolean.FALSE);
                        response = AxisEngine.resumeSend(msgCtx);
                    }
                    if (SenderWorker.log.isDebugEnabled()) {
                        SenderWorker.log.debug("Engine resume returned " + response);
                    }
                    if (response != Handler.InvocationResponse.SUSPEND && t != null) {
                        if (SenderWorker.log.isDebugEnabled()) {
                            SenderWorker.log.debug("Signalling transport in " + t);
                        }
                        t.signalResponseReady();
                    }
                    successfullySent = true;
                }
                catch (AxisFault e) {
                    processResponseForFaults = true;
                    this.recordError(e, rmMsgCtx, storageManager);
                }
                catch (Exception e) {
                    message = SandeshaMessageHelper.getMessage("sendMsgError", e.toString());
                    if (SenderWorker.log.isDebugEnabled()) {
                        SenderWorker.log.debug(message, e);
                    }
                    this.recordError(e, rmMsgCtx, storageManager);
                }
                transaction = storageManager.getTransaction();
                bean1 = senderBeanMgr.retrieve(this.senderBean.getMessageID());
                if (bean1 != null) {
                    if (this.senderBean.isReSend()) {
                        bean1.setTimeToSend(this.senderBean.getTimeToSend());
                        senderBeanMgr.update(bean1);
                    } else {
                        senderBeanMgr.delete(bean1.getMessageID());
                        messageStoredKey = bean1.getMessageContextRefKey();
                        storageManager.removeMessageContext(messageStoredKey);
                    }
                }
                if (transaction != null) {
                    transaction.commit();
                }
                transaction = null;
                if ((processResponseForFaults || successfullySent) && !msgCtx.isServerSide()) {
                    this.checkForSyncResponses(msgCtx);
                }
                if (rmMsgCtx.getMessageType() != 7 || !"http://schemas.xmlsoap.org/ws/2005/02/rm".equals(rmMsgCtx.getRMNamespaceValue())) ** GOTO lbl312
                try {
                    transaction = storageManager.getTransaction();
                    terminateSequence = rmMsgCtx.getTerminateSequence();
                    sequenceID = terminateSequence.getIdentifier().getIdentifier();
                    rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sequenceID);
                    TerminateManager.terminateSendingSide(rmsBean, storageManager, false);
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = null;
                    var22_44 = null;
                    if (transaction != null && transaction.isActive()) {
                    }
                    ** GOTO lbl312
                }
                catch (Throwable var21_46) {
                    var22_45 = null;
                    if (transaction == null) throw var21_46;
                    if (transaction.isActive() == false) throw var21_46;
                    transaction.rollback();
                    transaction = null;
                    throw var21_46;
                }
                transaction.rollback();
                transaction = null;
                ** GOTO lbl312
            }
            catch (Exception e) {
                if (SenderWorker.log.isDebugEnabled()) {
                    SenderWorker.log.debug("Caught exception", e);
                }
                var24_15 = null;
                if (this.lock != null && this.workId != null) {
                    this.lock.removeWork(this.workId);
                }
                if (transaction == null || !transaction.isActive()) break block77;
                try {
                    transaction.rollback();
                }
                catch (SandeshaStorageException e) {
                    if (SenderWorker.log.isWarnEnabled()) {
                        SenderWorker.log.warn("Caught exception rolling back transaction", e);
                    }
                    break block77;
                }
            }
            {
                catch (Throwable var23_47) {
                    var24_16 = null;
                    if (this.lock != null && this.workId != null) {
                        this.lock.removeWork(this.workId);
                    }
                    if (transaction == null) throw var23_47;
                    if (transaction.isActive() == false) throw var23_47;
                    ** try [egrp 4[TRYBLOCK] [20 : 1706->1715)] { 
lbl239:
                    // 1 sources

                    transaction.rollback();
                    throw var23_47;
lbl241:
                    // 1 sources

                    catch (SandeshaStorageException e) {
                        if (SenderWorker.log.isWarnEnabled() == false) throw var23_47;
                        SenderWorker.log.warn("Caught exception rolling back transaction", e);
                    }
                    throw var23_47;
                }
lbl245:
                // 1 sources

                ** try [egrp 4[TRYBLOCK] [20 : 1706->1715)] { 
lbl246:
                // 1 sources

                transaction.rollback();
                return;
lbl248:
                // 1 sources

                catch (SandeshaStorageException e) {
                    if (SenderWorker.log.isWarnEnabled() == false) return;
                    SenderWorker.log.warn("Caught exception rolling back transaction", e);
                }
                return;
lbl252:
                // 1 sources

                var24_9 = null;
                if (this.lock != null && this.workId != null) {
                    this.lock.removeWork(this.workId);
                }
                if (transaction == null) return;
                if (transaction.isActive() == false) return;
                ** try [egrp 4[TRYBLOCK] [20 : 1706->1715)] { 
lbl258:
                // 1 sources

                transaction.rollback();
                return;
lbl260:
                // 1 sources

                catch (SandeshaStorageException e) {
                    if (SenderWorker.log.isWarnEnabled() == false) return;
                    SenderWorker.log.warn("Caught exception rolling back transaction", e);
                }
                return;
lbl264:
                // 1 sources

                var24_10 = null;
                if (this.lock != null && this.workId != null) {
                    this.lock.removeWork(this.workId);
                }
                if (transaction == null) return;
                if (transaction.isActive() == false) return;
                ** try [egrp 4[TRYBLOCK] [20 : 1706->1715)] { 
lbl270:
                // 1 sources

                transaction.rollback();
                return;
lbl272:
                // 1 sources

                catch (SandeshaStorageException e) {
                    if (SenderWorker.log.isWarnEnabled() == false) return;
                    SenderWorker.log.warn("Caught exception rolling back transaction", e);
                }
                return;
lbl276:
                // 1 sources

                var24_11 = null;
                if (this.lock != null && this.workId != null) {
                    this.lock.removeWork(this.workId);
                }
                if (transaction == null) return;
                if (transaction.isActive() == false) return;
                ** try [egrp 4[TRYBLOCK] [20 : 1706->1715)] { 
lbl282:
                // 1 sources

                transaction.rollback();
                return;
lbl284:
                // 1 sources

                catch (SandeshaStorageException e) {
                    if (SenderWorker.log.isWarnEnabled() == false) return;
                    SenderWorker.log.warn("Caught exception rolling back transaction", e);
                }
                return;
lbl288:
                // 1 sources

                var24_12 = null;
                if (this.lock != null && this.workId != null) {
                    this.lock.removeWork(this.workId);
                }
                if (transaction == null) return;
                if (transaction.isActive() == false) return;
                ** try [egrp 4[TRYBLOCK] [20 : 1706->1715)] { 
lbl294:
                // 1 sources

                transaction.rollback();
                return;
lbl296:
                // 1 sources

                catch (SandeshaStorageException e) {
                    if (SenderWorker.log.isWarnEnabled() == false) return;
                    SenderWorker.log.warn("Caught exception rolling back transaction", e);
                }
                return;
lbl300:
                // 1 sources

                var24_13 = null;
                if (this.lock != null && this.workId != null) {
                    this.lock.removeWork(this.workId);
                }
                if (transaction == null) return;
                if (transaction.isActive() == false) return;
                ** try [egrp 4[TRYBLOCK] [20 : 1706->1715)] { 
lbl306:
                // 1 sources

                transaction.rollback();
                return;
lbl308:
                // 1 sources

                catch (SandeshaStorageException e) {
                    if (SenderWorker.log.isWarnEnabled() == false) return;
                    SenderWorker.log.warn("Caught exception rolling back transaction", e);
                }
                return;
lbl312:
                // 3 sources

                var24_14 = null;
                if (this.lock != null && this.workId != null) {
                    this.lock.removeWork(this.workId);
                }
                if (transaction == null || !transaction.isActive()) break block77;
                ** try [egrp 4[TRYBLOCK] [20 : 1706->1715)] { 
lbl317:
                // 1 sources

                transaction.rollback();
lbl319:
                // 1 sources

                catch (SandeshaStorageException e) {}
                if (!SenderWorker.log.isWarnEnabled()) break block77;
                SenderWorker.log.warn("Caught exception rolling back transaction", e);
            }
        }
        if (SenderWorker.log.isDebugEnabled() == false) return;
        SenderWorker.log.debug("Exit: SenderWorker::run");
    }

    private SenderBean updateMessage(RMMsgContext rmMsgContext, SenderBean senderBean, StorageManager storageManager) throws AxisFault {
        senderBean = storageManager.getSenderBeanMgr().retrieve(senderBean.getMessageID());
        if (senderBean == null) {
            return senderBean;
        }
        int messageType = senderBean.getMessageType();
        boolean continueSending = MessageRetransmissionAdjuster.adjustRetransmittion(rmMsgContext, senderBean, rmMsgContext.getConfigurationContext(), storageManager);
        if (!continueSending) {
            return null;
        }
        Identifier id = null;
        if (messageType == 3 || messageType == 12) {
            String namespace = SpecSpecificConstants.getRMNamespaceValue(this.rmVersion);
            Sequence sequence = rmMsgContext.getSequence();
            if (sequence == null) {
                sequence = new Sequence(namespace);
                sequence.setMessageNumber(senderBean.getMessageNumber());
                if (senderBean.isLastMessage() && SpecSpecificConstants.isLastMessageIndicatorRequired(this.rmVersion)) {
                    sequence.setLastMessage(true);
                }
                id = new Identifier(namespace);
                sequence.setIdentifier(id);
                rmMsgContext.setSequence(sequence);
            }
        } else if (messageType == 7) {
            TerminateSequence terminate = rmMsgContext.getTerminateSequence();
            id = terminate.getIdentifier();
        } else if (messageType == 5) {
            CloseSequence close = rmMsgContext.getCloseSequence();
            id = close.getIdentifier();
        } else if (messageType == 8) {
            Iterator ackRequests = rmMsgContext.getAckRequests();
            AckRequested ackRequest = (AckRequested)ackRequests.next();
            if (ackRequests.hasNext()) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("ackRequestMultipleParts"));
            }
            id = ackRequest.getIdentifier();
        }
        boolean ackPresent = false;
        Iterator it = rmMsgContext.getSequenceAcknowledgements();
        if (it.hasNext()) {
            ackPresent = true;
        }
        if (!ackPresent && rmMsgContext.getMessageContext().isServerSide() && (messageType == 3 || messageType == 3 || messageType == 0 || messageType == 12)) {
            String inboundSequenceId = senderBean.getInboundSequenceId();
            if (inboundSequenceId == null) {
                throw new SandeshaException("InboundSequenceID is not set for the sequence:" + id);
            }
            RMDBean incomingSequenceBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, inboundSequenceId);
            if (incomingSequenceBean != null) {
                RMMsgCreator.addAckMessage(rmMsgContext, inboundSequenceId, incomingSequenceBean, false);
            }
        }
        if (id != null && !senderBean.getSequenceID().equals(id.getIdentifier())) {
            id.setIndentifer(senderBean.getSequenceID());
            rmMsgContext.addSOAPEnvelope();
        } else if (rmMsgContext.getProperty("ackToBeWritten") != null) {
            rmMsgContext.addSOAPEnvelope();
        }
        return senderBean;
    }

    private boolean isAckPiggybackableMsgType(int messageType) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SenderWorker::isAckPiggybackableMsgType, " + messageType);
        }
        boolean piggybackable = true;
        if (messageType == 4) {
            piggybackable = false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SenderWorker::isAckPiggybackableMsgType, " + piggybackable);
        }
        return piggybackable;
    }

    private void checkForSyncResponses(MessageContext msgCtx) {
        block28: {
            if (log.isDebugEnabled()) {
                log.debug("Enter: SenderWorker::checkForSyncResponses, " + msgCtx.getEnvelope().getHeader());
            }
            try {
                StAXBuilder sb;
                SOAPEnvelope env;
                boolean transportInPresent;
                MessageContext responseMessageContext = msgCtx.getOperationContext().getMessageContext("In");
                SOAPEnvelope resenvelope = null;
                if (responseMessageContext != null) {
                    resenvelope = responseMessageContext.getEnvelope();
                }
                boolean bl = transportInPresent = msgCtx.getProperty("TRANSPORT_IN") != null;
                if (!(transportInPresent || responseMessageContext != null && responseMessageContext.getEnvelope() != null)) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: SenderWorker::checkForSyncResponses, no response present");
                    }
                    return;
                }
                boolean syncResponseBuilt = false;
                if (responseMessageContext == null || responseMessageContext.getEnvelope() == null) {
                    AxisOperation operation;
                    if (responseMessageContext == null) {
                        responseMessageContext = new MessageContext();
                    }
                    OperationContext requestMsgOpCtx = msgCtx.getOperationContext();
                    SandeshaUtil.copyConfiguredProperties(msgCtx, responseMessageContext);
                    responseMessageContext.setProperty("CHARACTER_SET_ENCODING", requestMsgOpCtx.getProperty("CHARACTER_SET_ENCODING"));
                    responseMessageContext.setProperty("ContentType", requestMsgOpCtx.getProperty("ContentType"));
                    responseMessageContext.setProperty("MTOM_RECEIVED", requestMsgOpCtx.getProperty("MTOM_RECEIVED"));
                    HashMap transportInfoMap = (HashMap)msgCtx.getProperty("TransportInfoMap");
                    if (transportInfoMap != null) {
                        responseMessageContext.setProperty("ContentType", transportInfoMap.get("ContentType"));
                        responseMessageContext.setProperty("CHARACTER_SET_ENCODING", transportInfoMap.get("CHARACTER_SET_ENCODING"));
                    }
                    responseMessageContext.setConfigurationContext(msgCtx.getConfigurationContext());
                    responseMessageContext.setTransportIn(msgCtx.getTransportIn());
                    responseMessageContext.setTransportOut(msgCtx.getTransportOut());
                    responseMessageContext.setProperty("TRANSPORT_IN", msgCtx.getProperty("TRANSPORT_IN"));
                    responseMessageContext.setServiceGroupContext(msgCtx.getServiceGroupContext());
                    responseMessageContext.setProperty("Sandesha2MakeConnectionEntry", msgCtx.getProperty("Sandesha2MakeConnectionEntry"));
                    responseMessageContext.setDoingREST(msgCtx.isDoingREST());
                    resenvelope = responseMessageContext.getEnvelope();
                    try {
                        if (resenvelope == null) {
                            resenvelope = TransportUtils.createSOAPMessage(responseMessageContext, true);
                            responseMessageContext.setEnvelope(resenvelope);
                            syncResponseBuilt = true;
                        }
                    }
                    catch (AxisFault e) {
                        if (log.isDebugEnabled()) {
                            log.debug(SandeshaMessageHelper.getMessage("soapEnvNotSet"));
                            log.debug("Caught exception", e);
                        }
                        return;
                    }
                    int messageType = MsgInitializer.initializeMessage(msgCtx).getMessageType();
                    RMMsgContext responseRMMessage = MsgInitializer.initializeMessage(responseMessageContext);
                    int responseMessageType = responseRMMessage.getMessageType();
                    if (log.isDebugEnabled()) {
                        log.debug("inboundMsgType" + responseMessageType + "outgoing message type " + messageType);
                    }
                    if (messageType == 3 && responseMessageType == 3 || responseMessageType != 3) {
                        if (log.isDebugEnabled()) {
                            log.debug("setting service ctx on msg as this is NOT a makeConnection>appResponse exchange pattern");
                        }
                        responseMessageContext.setServiceContext(msgCtx.getServiceContext());
                    } else {
                        responseMessageContext.setAxisService(msgCtx.getAxisService());
                        if (log.isDebugEnabled()) {
                            log.debug("NOT setting service ctx for response type " + messageType + ", current srvc ctx =" + responseMessageContext.getServiceContext());
                        }
                    }
                    Boolean addressingDisabled = (Boolean)msgCtx.getProperty("disableAddressingForOutMessages");
                    if (addressingDisabled != null && Boolean.TRUE.equals(addressingDisabled)) {
                        OperationContext responseMsgOpCtx = requestMsgOpCtx;
                        if (requestMsgOpCtx.getAxisOperation().getMessageReceiver() == null) {
                            ServiceContext serviceCtx = responseMessageContext.getServiceContext();
                            AxisOperation op = msgCtx.getAxisService().getOperation(Sandesha2Constants.RM_IN_ONLY_OPERATION);
                            responseMsgOpCtx = OperationContextFactory.createOperationContext(op.getAxisSpecificMEPConstant(), op, serviceCtx);
                        }
                        responseMessageContext.setOperationContext(responseMsgOpCtx);
                    }
                    if ((operation = msgCtx.getAxisOperation()) != null && responseMessageContext.getAxisMessage() == null && !(operation instanceof OutOnlyAxisOperation)) {
                        responseMessageContext.setAxisMessage(operation.getMessage("In"));
                    }
                    if (responseRMMessage.getMessageType() == 4) {
                        responseMessageContext.setAxisOperation(SpecSpecificConstants.getWSRMOperation(4, responseRMMessage.getRMSpecVersion(), responseMessageContext.getAxisService()));
                        responseMessageContext.setOperationContext(null);
                    }
                }
                if (msgCtx.getOptions().isUseSeparateListener() && !syncResponseBuilt) {
                    return;
                }
                responseMessageContext.setServerSide(true);
                if (responseMessageContext.getSoapAction() == null) {
                    responseMessageContext.setSoapAction("");
                }
                Handler.InvocationResponse response = null;
                if (resenvelope != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("SenderWorker::disable addressing inbound checks, driving response through axis engine " + responseMessageContext);
                    }
                    responseMessageContext.setProperty("addressing.validateInvocationPattern", Boolean.FALSE);
                    response = AxisEngine.receive(responseMessageContext);
                }
                if (!Handler.InvocationResponse.SUSPEND.equals(response) && (env = responseMessageContext.getEnvelope()) != null && (sb = (StAXBuilder)responseMessageContext.getEnvelope().getBuilder()) != null) {
                    sb.close();
                }
            }
            catch (Exception e) {
                String message = SandeshaMessageHelper.getMessage("noValidSyncResponse");
                if (!log.isDebugEnabled()) break block28;
                log.debug(message, e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SenderWorker::checkForSyncResponses");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recordError(Exception e, RMMsgContext outRMMsg, StorageManager storageManager) throws SandeshaStorageException {
        Transaction transaction = null;
        try {
            try {
                String internalSequenceId = (String)outRMMsg.getProperty("Sandesha2InternalSequenceId");
                if (internalSequenceId == null) {
                    internalSequenceId = this.senderBean.getInternalSequenceID();
                }
                if (internalSequenceId != null) {
                    transaction = storageManager.getTransaction();
                    RMSBean bean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
                    if (bean != null) {
                        bean.setLastSendError(e);
                        bean.setLastSendErrorTimestamp(System.currentTimeMillis());
                        storageManager.getRMSBeanMgr().update(bean);
                    }
                    if (transaction != null) {
                        transaction.commit();
                        return;
                    }
                }
            }
            catch (Exception e1) {
                if (log.isDebugEnabled()) {
                    log.debug(e1);
                }
                Object var8_9 = null;
                if (transaction == null) return;
                transaction.rollback();
                return;
            }
            Object var8_8 = null;
            if (transaction == null) return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (transaction == null) throw throwable;
            transaction.rollback();
            transaction = null;
            throw throwable;
        }
        transaction.rollback();
    }
}

