/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SequenceManager;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.workers.SenderWorker;
import org.apache.sandesha2.workers.SequenceEntry;

public class Sender
extends SandeshaThread {
    private static final Log log = LogFactory.getLog(Sender.class);
    int nextIndex = 0;
    boolean processedMessage = false;
    long lastHousekeeping = 0L;
    long lastRanCleanup = 0L;
    private static int HOUSEKEEPING_INTERVAL = 20000;
    private ConcurrentHashMap ackMap = new ConcurrentHashMap();
    private ConcurrentHashMap warnedAlreadyOrphans = new ConcurrentHashMap();

    public Sender() {
        super(500);
    }

    public void scheduleAddressableAcknowledgement(String sequenceId, long ackInterval, RMMsgContext ref) {
        AckHolder ackH = new AckHolder();
        ackH.tts = System.currentTimeMillis() + ackInterval;
        ackH.refMsg = ref;
        this.ackMap.putIfAbsent(sequenceId, ackH);
    }

    public void removeScheduledAcknowledgement(String sequenceId) {
        this.ackMap.remove(sequenceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean internalRun() {
        block56: {
            block54: {
                block55: {
                    block52: {
                        block53: {
                            block50: {
                                block51: {
                                    block48: {
                                        block49: {
                                            if (Sender.log.isDebugEnabled()) {
                                                Sender.log.debug("Enter: Sender::internalRun");
                                            }
                                            transaction = null;
                                            sleep = false;
                                            allSequencesList = this.getSequences();
                                            size = allSequencesList.size();
                                            if (Sender.log.isDebugEnabled()) {
                                                Sender.log.debug("Choosing one from " + size + " sequences");
                                            }
                                            if (this.nextIndex < size) break block48;
                                            this.nextIndex = 0;
                                            if (size == 0 || !this.processedMessage) {
                                                sleep = true;
                                            }
                                            this.processedMessage = false;
                                            if (System.currentTimeMillis() - this.lastHousekeeping > (long)Sender.HOUSEKEEPING_INTERVAL) {
                                                this.deleteTerminatedSequences(this.storageManager);
                                                this.unblockTransportThreads(this.storageManager);
                                                this.checkForOrphanMessages(this.storageManager);
                                                this.lastHousekeeping = System.currentTimeMillis();
                                            }
                                            if (Sender.log.isDebugEnabled()) {
                                                Sender.log.debug("Exit: Sender::internalRun, looped over all sequences, sleep " + sleep);
                                            }
                                            var5_7 = sleep;
                                            var15_9 = null;
                                            if (transaction == null || !transaction.isActive()) break block49;
                                            try {
                                                transaction.rollback();
                                                transaction = null;
                                            }
                                            catch (Exception e) {
                                                message = SandeshaMessageHelper.getMessage("rollbackError", e.toString());
                                                Sender.log.debug(message, e);
                                            }
                                        }
                                        return var5_7;
                                    }
                                    transaction = this.storageManager.getTransaction();
                                    entry = (SequenceEntry)allSequencesList.get(this.nextIndex++);
                                    sequenceId = entry.getSequenceId();
                                    if (Sender.log.isDebugEnabled()) {
                                        Sender.log.debug("Chose sequence " + sequenceId);
                                    }
                                    rmVersion = null;
                                    found = false;
                                    if (entry.isRmSource()) {
                                        rms = null;
                                        if (entry.rmsKey == null) {
                                            matcher = new RMSBean();
                                            matcher.setInternalSequenceID(sequenceId);
                                            matcher.setTerminated(false);
                                            rms = this.storageManager.getRMSBeanMgr().findUnique(matcher);
                                            if (rms != null) {
                                                entry.rmsKey = rms.getCreateSeqMsgID();
                                            }
                                        } else {
                                            rms = this.storageManager.getRMSBeanMgr().retrieve(entry.rmsKey);
                                            if (rms == null) {
                                                if (Sender.log.isDebugEnabled()) {
                                                    Sender.log.debug("debug @tpm 13-08-08");
                                                }
                                                matcher = new RMSBean();
                                                matcher.setInternalSequenceID(sequenceId);
                                                matcher.setTerminated(false);
                                                rms = this.storageManager.getRMSBeanMgr().findUnique(matcher);
                                            }
                                        }
                                        if (rms != null && !rms.isTerminated() && !rms.isTimedOut()) {
                                            sequenceId = rms.getSequenceID();
                                            if (SequenceManager.hasSequenceTimedOut(rms, sequenceId, this.storageManager)) {
                                                SequenceManager.finalizeTimedOutSequence(rms.getInternalSequenceID(), null, this.storageManager);
                                            } else {
                                                found = true;
                                            }
                                            rmVersion = rms.getRMVersion();
                                        }
                                    } else {
                                        rmd = SandeshaUtil.getRMDBeanFromSequenceId(this.storageManager, sequenceId);
                                        if (rmd != null && !rmd.isTerminated()) {
                                            found = true;
                                            rmVersion = rmd.getRMVersion();
                                        }
                                    }
                                    if (found) break block50;
                                    this.stopThreadForSequence(sequenceId, entry.isRmSource());
                                    if (Sender.log.isDebugEnabled()) {
                                        Sender.log.debug("Exit: Sender::internalRun, sequence has ended");
                                    }
                                    if (transaction != null && transaction.isActive()) {
                                        transaction.commit();
                                        transaction = null;
                                    }
                                    rmd = false;
                                    var15_10 = null;
                                    if (transaction == null || !transaction.isActive()) break block51;
                                    try {
                                        transaction.rollback();
                                        transaction = null;
                                    }
                                    catch (Exception e) {
                                        message = SandeshaMessageHelper.getMessage("rollbackError", e.toString());
                                        Sender.log.debug(message, e);
                                    }
                                }
                                return rmd;
                            }
                            if (sequenceId != null && (acktts = (AckHolder)this.ackMap.get(sequenceId)) != null && acktts.tts < System.currentTimeMillis()) {
                                this.ackMap.remove(sequenceId);
                                rmd = this.storageManager.getRMDBeanMgr().retrieve(sequenceId);
                                if (rmd != null) {
                                    ackRMMsgContext = AcknowledgementManager.generateAckMessage(acktts.refMsg, rmd, sequenceId, this.storageManager, true);
                                    AcknowledgementManager.addAckBeanEntry(ackRMMsgContext, sequenceId, acktts.tts, this.storageManager);
                                    transaction.commit();
                                    transaction = this.storageManager.getTransaction();
                                }
                            }
                            if ((senderBean = (mgr = this.storageManager.getSenderBeanMgr()).getNextMsgToSend(sequenceId)) != null) break block52;
                            if (Sender.log.isDebugEnabled()) {
                                Sender.log.debug("Exit: Sender::internalRun, no message for this sequence");
                            }
                            if (transaction != null && transaction.isActive()) {
                                transaction.commit();
                                transaction = null;
                            }
                            ackRMMsgContext = false;
                            var15_11 = null;
                            if (transaction == null || !transaction.isActive()) break block53;
                            try {
                                transaction.rollback();
                                transaction = null;
                            }
                            catch (Exception e) {
                                message = SandeshaMessageHelper.getMessage("rollbackError", e.toString());
                                Sender.log.debug(message, e);
                            }
                        }
                        return ackRMMsgContext;
                    }
                    workId = senderBean.getMessageID() + senderBean.getTimeToSend();
                    if (!this.getWorkerLock().isWorkPresent(workId)) break block54;
                    if (Sender.log.isDebugEnabled()) {
                        message = SandeshaMessageHelper.getMessage("workAlreadyAssigned", workId);
                        Sender.log.debug("Exit: Sender::internalRun, " + message + ", sleeping");
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                        transaction = null;
                    }
                    message = true;
                    var15_12 = null;
                    if (transaction == null || !transaction.isActive()) break block55;
                    try {
                        transaction.rollback();
                        transaction = null;
                    }
                    catch (Exception e) {
                        message = SandeshaMessageHelper.getMessage("rollbackError", e.toString());
                        Sender.log.debug(message, e);
                    }
                }
                return message;
            }
            try {
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = null;
                worker = new SenderWorker(this.context, senderBean, rmVersion);
                worker.setLock(this.getWorkerLock());
                worker.setWorkId(workId);
                try {
                    this.getWorkerLock().addWork(workId, worker);
                    this.threadPool.execute(worker);
                }
                catch (Exception e) {
                    this.getWorkerLock().removeWork(workId);
                }
                this.processedMessage = true;
                var15_13 = null;
                ** if (transaction == null || !transaction.isActive()) goto lbl-1000
            }
            catch (Throwable var14_42) {
                var15_15 = null;
                if (transaction != null && transaction.isActive()) {
                    try {
                        transaction.rollback();
                        transaction = null;
                    }
                    catch (Exception e) {
                        message = SandeshaMessageHelper.getMessage("rollbackError", e.toString());
                        Sender.log.debug(message, e);
                    }
                }
                throw var14_42;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    transaction.rollback();
                    transaction = null;
                }
                catch (Exception e) {
                    message = SandeshaMessageHelper.getMessage("rollbackError", e.toString());
                    Sender.log.debug(message, e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block56;
                catch (Exception e) {
                    message = SandeshaMessageHelper.getMessage("sendMsgError", e.toString());
                    Sender.log.debug(message, e);
                    var15_14 = null;
                    if (transaction != null && transaction.isActive()) {
                        try {
                            transaction.rollback();
                            transaction = null;
                        }
                        catch (Exception e) {
                            message = SandeshaMessageHelper.getMessage("rollbackError", e.toString());
                            Sender.log.debug(message, e);
                        }
                    }
                }
            }
        }
        if (Sender.log.isDebugEnabled()) {
            Sender.log.debug("Exit: Sender::internalRun, not sleeping");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void deleteTerminatedSequences(StorageManager storageManager) {
        block24: {
            if (Sender.log.isDebugEnabled()) {
                Sender.log.debug("Enter: Sender::deleteTerminatedSequences");
            }
            finderBean = new RMSBean();
            finderBean.setTerminated(true);
            transaction = null;
            try {
                block23: {
                    transaction = storageManager.getTransaction();
                    propertyBean = SandeshaUtil.getPropertyBean(storageManager.getContext().getAxisConfiguration());
                    deleteTime = propertyBean.getSequenceRemovalTimeoutInterval();
                    if (deleteTime < 0L) {
                        deleteTime = 0L;
                    }
                    if (deleteTime > 0L) {
                        rmsBeans = storageManager.getRMSBeanMgr().find(finderBean);
                        this.deleteRMSBeans(rmsBeans, propertyBean, deleteTime);
                        finderBean.setTerminated(false);
                        finderBean.setTimedOut(true);
                        rmsBeans = storageManager.getRMSBeanMgr().find(finderBean);
                        this.deleteRMSBeans(rmsBeans, propertyBean, deleteTime);
                        finderRMDBean = new RMDBean();
                        finderRMDBean.setTerminated(true);
                        rmdBeans = storageManager.getRMDBeanMgr().find(finderRMDBean);
                        for (RMDBean rmdBean : rmdBeans) {
                            timeNow = System.currentTimeMillis();
                            lastActivated = rmdBean.getLastActivatedTime();
                            if (lastActivated + deleteTime >= timeNow) continue;
                            if (Sender.log.isDebugEnabled()) {
                                Sender.log.debug("Deleting RMDBean " + deleteTime + " : " + rmdBean);
                            }
                            storageManager.getRMDBeanMgr().delete(rmdBean.getSequenceID());
                        }
                    }
                    if (propertyBean.getInactivityTimeoutInterval() > 0L) {
                        finderRMDBean = new RMDBean();
                        finderRMDBean.setTerminated(false);
                        rmdBeans = storageManager.getRMDBeanMgr().find(finderRMDBean);
                        for (RMDBean rmdBean : rmdBeans) {
                            timeNow = System.currentTimeMillis();
                            lastActivated = rmdBean.getLastActivatedTime();
                            if (lastActivated + propertyBean.getInactivityTimeoutInterval() >= timeNow) continue;
                            rmdBean.setTerminated(true);
                            rmdBean.setLastActivatedTime(timeNow);
                            if (Sender.log.isDebugEnabled()) {
                                Sender.log.debug(System.currentTimeMillis() + "Marking RMDBean as terminated " + rmdBean);
                            }
                            storageManager.getRMDBeanMgr().update(rmdBean);
                        }
                    }
                    if (transaction == null || !transaction.isActive()) break block23;
                    transaction.commit();
                }
                var17_16 = null;
                ** if (transaction == null || !transaction.isActive()) goto lbl-1000
            }
            catch (Throwable var16_22) {
                block25: {
                    var17_18 = null;
                    if (transaction != null && transaction.isActive()) {
                        try {
                            transaction.rollback();
                        }
                        catch (SandeshaStorageException e) {
                            if (!Sender.log.isDebugEnabled()) break block25;
                            Sender.log.debug("Caught exception rolling back transaction", e);
                        }
                    }
                }
                throw var16_22;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    transaction.rollback();
                }
                catch (SandeshaStorageException e) {
                    if (Sender.log.isDebugEnabled()) {
                        Sender.log.debug("Caught exception rolling back transaction", e);
                    }
                }
            }
lbl-1000:
            // 4 sources

            {
                break block24;
                catch (SandeshaException e) {
                    if (Sender.log.isErrorEnabled()) {
                        Sender.log.error(e);
                    }
                    var17_17 = null;
                    if (transaction != null && transaction.isActive()) {
                        try {
                            transaction.rollback();
                        }
                        catch (SandeshaStorageException e) {
                            if (Sender.log.isDebugEnabled()) {
                                Sender.log.debug("Caught exception rolling back transaction", e);
                            }
                        }
                    }
                }
            }
        }
        if (Sender.log.isDebugEnabled()) {
            Sender.log.debug("Exit: Sender::deleteTerminatedSequences");
        }
    }

    private void deleteRMSBeans(List rmsBeans, SandeshaPolicyBean propertyBean, long deleteTime) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: Sender::deleteRMSBeans");
        }
        for (RMSBean rmsBean : rmsBeans) {
            long timeNow = System.currentTimeMillis();
            long lastActivated = rmsBean.getLastActivatedTime();
            if (lastActivated + deleteTime >= timeNow) continue;
            if (log.isDebugEnabled()) {
                log.debug("Removing RMSBean " + rmsBean);
            }
            this.storageManager.getRMSBeanMgr().delete(rmsBean.getCreateSeqMsgID());
            this.storageManager.removeMessageContext(rmsBean.getReferenceMessageStoreKey());
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: Sender::deleteRMSBeans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unblockTransportThreads(StorageManager manager) throws SandeshaStorageException {
        block18: {
            if (log.isDebugEnabled()) {
                log.debug("Enter: Sender::unblockTransportThreads");
            }
            Transaction transaction = null;
            try {
                try {
                    transaction = manager.getTransaction();
                    SenderBean finder = new SenderBean();
                    finder.setSend(false);
                    finder.setTransportAvailable(true);
                    finder.setTimeToSend(System.currentTimeMillis() - 60000L);
                    List beans = manager.getSenderBeanMgr().find(finder);
                    for (SenderBean bean : beans) {
                        EndpointReference acksToEPR;
                        MessageContext msgCtx = manager.retrieveMessageContext(bean.getMessageContextRefKey(), this.context);
                        RequestResponseTransport t = null;
                        MessageContext inMsg = null;
                        OperationContext op = msgCtx.getOperationContext();
                        if (op != null) {
                            inMsg = op.getMessageContext("In");
                        }
                        if (inMsg != null) {
                            t = (RequestResponseTransport)inMsg.getProperty("RequestResponseTransportControl");
                        }
                        if (t == null || !RequestResponseTransport.RequestResponseTransportStatus.WAITING.equals(t.getStatus())) continue;
                        if (log.isWarnEnabled()) {
                            String message = SandeshaMessageHelper.getMessage("freeingTransport");
                            log.warn(message);
                        }
                        boolean sendAck = false;
                        RMDBean inbound = null;
                        String inboundSeq = bean.getInboundSequenceId();
                        if (inboundSeq != null) {
                            inbound = SandeshaUtil.getRMDBeanFromSequenceId(manager, inboundSeq);
                        }
                        if (inbound != null && (acksToEPR = inbound.getAcksToEndpointReference()) != null && acksToEPR.hasAnonymousAddress()) {
                            sendAck = true;
                        }
                        if (sendAck) {
                            RMMsgContext rmMsgCtx = MsgInitializer.initializeMessage(msgCtx);
                            RMMsgContext ackRMMsgCtx = AcknowledgementManager.generateAckMessage(rmMsgCtx, inbound, inbound.getSequenceID(), this.storageManager, true);
                            AcknowledgementManager.sendAckNow(ackRMMsgCtx);
                            TransportUtils.setResponseWritten(msgCtx, true);
                        } else {
                            TransportUtils.setResponseWritten(msgCtx, false);
                        }
                        bean.setTransportAvailable(false);
                        bean.setTimeToSend(System.currentTimeMillis());
                        manager.getSenderBeanMgr().update(bean);
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = null;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exception", e);
                    }
                    Object var17_19 = null;
                    if (transaction != null && transaction.isActive()) {
                        transaction.rollback();
                    }
                    break block18;
                }
                Object var17_18 = null;
                if (transaction == null || !transaction.isActive()) break block18;
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
                throw throwable;
            }
            transaction.rollback();
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: Sender::unblockTransportThreads");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkForOrphanMessages(StorageManager manager) throws SandeshaStorageException {
        block21: {
            if (log.isDebugEnabled()) {
                log.debug("Enter: Sender::checkForOrphanMessages");
            }
            Transaction tran = null;
            try {
                try {
                    tran = manager.getTransaction();
                    SenderBean finder = new SenderBean();
                    finder.setSend(true);
                    finder.setTransportAvailable(false);
                    finder.setTimeToSend(System.currentTimeMillis() - 60000L);
                    List beans = manager.getSenderBeanMgr().find(finder);
                    for (SenderBean bean : beans) {
                        int messageType;
                        if (log.isWarnEnabled()) {
                            String message = null;
                            String internalSequenceID = bean.getInternalSequenceID();
                            String sequenceID = bean.getSequenceID();
                            if (!this.warnedAlreadyOrphans.containsKey(sequenceID)) {
                                if (bean.getMessageType() == 3) {
                                    message = SandeshaMessageHelper.getMessage("noPolling", sequenceID, internalSequenceID);
                                } else {
                                    String messageType2 = Integer.toString(bean.getMessageType());
                                    message = SandeshaMessageHelper.getMessage("noPollingProtocol", messageType2, sequenceID, internalSequenceID);
                                }
                                this.warnedAlreadyOrphans.put(sequenceID, System.currentTimeMillis());
                                log.warn(message);
                            }
                        }
                        if (7 == (messageType = bean.getMessageType()) || 9 == messageType) {
                            String id = bean.getSequenceID();
                            if (log.isDebugEnabled()) {
                                log.debug("Sender::checkForOrphanMessages.  Orphaned message of type TERMINATE_SEQ or TERMINATE_SEQ_RESPONSE found.  Deleting this message with a sequence ID of : " + id);
                            }
                            manager.getSenderBeanMgr().delete(id);
                        } else {
                            bean.setTimeToSend(System.currentTimeMillis());
                            manager.getSenderBeanMgr().update(bean);
                        }
                        long currentTime = System.currentTimeMillis();
                        if (this.lastRanCleanup == 0L) {
                            this.lastRanCleanup = System.currentTimeMillis();
                        }
                        if (this.warnedAlreadyOrphans.size() <= 1000 && currentTime <= this.lastRanCleanup + 600000L) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("Sender::checkForOrphanMessages.  Cleaning up list of orphans");
                        }
                        long timeAnHourAgo = currentTime - 3600000L;
                        for (Object key : this.warnedAlreadyOrphans.keySet()) {
                            long ageOfThisOrphan = (Long)this.warnedAlreadyOrphans.get(key);
                            if (ageOfThisOrphan >= timeAnHourAgo) continue;
                            this.warnedAlreadyOrphans.remove(key);
                        }
                        this.lastRanCleanup = System.currentTimeMillis();
                    }
                    if (tran != null && tran.isActive()) {
                        tran.commit();
                    }
                    tran = null;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exception", e);
                    }
                    Object var17_19 = null;
                    if (tran != null && tran.isActive()) {
                        tran.rollback();
                    }
                    break block21;
                }
                Object var17_18 = null;
                if (tran == null || !tran.isActive()) break block21;
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                if (tran != null && tran.isActive()) {
                    tran.rollback();
                }
                throw throwable;
            }
            tran.rollback();
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: Sender::checkForOrphanMessages");
        }
    }

    private static class AckHolder {
        public long tts = 0L;
        public RMMsgContext refMsg;

        private AckHolder() {
        }
    }
}

