/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.workers.SequenceEntry;
import org.apache.sandesha2.workers.WorkerLock;

public abstract class SandeshaThread
extends Thread {
    private static final Log log = LogFactory.getLog(SandeshaThread.class);
    private boolean runThread = false;
    private boolean hasStoppedRunning = false;
    private boolean hasPausedRunning = false;
    private boolean pauseRequired = false;
    private boolean stopRequested = false;
    private int sleepTime;
    private WorkerLock lock = null;
    private ArrayList workingSequences = new ArrayList();
    protected transient ThreadFactory threadPool;
    protected ConfigurationContext context = null;
    protected StorageManager storageManager = null;
    private boolean reRunThread;

    public SandeshaThread(int sleepTime) {
        this.sleepTime = sleepTime;
        this.setDaemon(true);
        this.lock = new WorkerLock();
    }

    public final WorkerLock getWorkerLock() {
        return this.lock;
    }

    public synchronized void stopThreadForSequence(String sequenceID, boolean rmSource) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaThread::stopThreadForSequence, " + sequenceID);
        }
        this.workingSequences.remove(new SequenceEntry(sequenceID, rmSource));
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaThread::stopThreadForSequence");
        }
    }

    public synchronized void blockForPause() {
        while (this.pauseRequired) {
            try {
                this.wait(this.sleepTime);
            }
            catch (InterruptedException e) {}
        }
        this.pauseRequired = true;
        if (this.hasStoppedRunning() || !this.isThreadStarted()) {
            throw new IllegalStateException(SandeshaMessageHelper.getMessage("cannotPauseThread"));
        }
        while (!this.hasPausedRunning) {
            try {
                this.wait(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void finishPause() {
        this.pauseRequired = false;
        this.notifyAll();
    }

    public synchronized void stopRunning() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaThread::stopRunning, " + this);
        }
        if (this.isThreadStarted()) {
            this.runThread = false;
            this.stopRequested = true;
            while (!this.hasStoppedRunning()) {
                try {
                    this.wait(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaThread::stopRunning");
        }
    }

    public synchronized boolean isThreadStarted() {
        if (!this.runThread && log.isDebugEnabled()) {
            log.debug("SandeshaThread not started");
        }
        return this.runThread;
    }

    public synchronized void runThreadForSequence(ConfigurationContext context, String sequenceID, boolean rmSource) {
        SequenceEntry entry;
        if (log.isDebugEnabled()) {
            log.debug("Entry: SandeshaThread::runThreadForSequence, " + this + ", " + sequenceID + ", " + rmSource);
        }
        if (!this.workingSequences.contains(entry = new SequenceEntry(sequenceID, rmSource))) {
            this.workingSequences.add(entry);
        }
        if (!this.isThreadStarted() && !this.stopRequested) {
            if (log.isDebugEnabled()) {
                log.debug("Starting thread");
            }
            this.context = context;
            this.threadPool = context.getThreadPool();
            this.runThread = true;
            super.start();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        SandeshaThread.this.setContextClassLoader(Thread.currentThread().getContextClassLoader());
                        return null;
                    }
                });
            }
            catch (Exception e) {
                log.error(e);
                throw new RuntimeException(e);
            }
        } else if (!this.stopRequested) {
            if (log.isDebugEnabled()) {
                log.debug("Waking thread");
            }
            this.wakeThread();
        } else if (this.stopRequested && log.isDebugEnabled()) {
            log.debug("Can't start thread as it has been stopped");
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaThread::runThreadForSequence");
        }
    }

    public synchronized ArrayList getSequences() {
        ArrayList result = new ArrayList();
        result.addAll(this.workingSequences);
        return result;
    }

    protected synchronized boolean hasStoppedRunning() {
        return this.hasStoppedRunning;
    }

    protected synchronized void doPauseIfNeeded() {
        while (this.pauseRequired) {
            if (!this.hasPausedRunning) {
                this.hasPausedRunning = true;
                this.notifyAll();
            }
            try {
                this.wait(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.hasPausedRunning = false;
    }

    public synchronized void wakeThread() {
        this.reRunThread = true;
        if (!this.hasPausedRunning) {
            this.notifyAll();
        }
    }

    public synchronized void setRanMainLoop() {
        this.reRunThread = false;
    }

    protected synchronized boolean runMainLoop() {
        return this.reRunThread;
    }

    protected abstract boolean internalRun();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            boolean sleep = false;
            while (this.isThreadStarted()) {
                try {
                    SandeshaThread sandeshaThread = this;
                    synchronized (sandeshaThread) {
                        if (sleep && !this.runMainLoop()) {
                            this.wait(this.sleepTime);
                        }
                        this.setRanMainLoop();
                    }
                }
                catch (InterruptedException e1) {
                    log.debug("SandeshaThread was interupted...");
                    log.debug(e1.getMessage());
                    log.debug("End printing Interrupt...");
                }
                this.doPauseIfNeeded();
                if (this.context == null) {
                    String message = SandeshaMessageHelper.getMessage("configContextNotSet");
                    message = SandeshaMessageHelper.getMessage("cannotCointinueSender", message);
                    log.debug(message);
                    throw new RuntimeException(message);
                }
                if (this.storageManager == null) {
                    try {
                        this.storageManager = SandeshaUtil.getSandeshaStorageManager(this.context, this.context.getAxisConfiguration());
                    }
                    catch (SandeshaException e2) {
                        String message = SandeshaMessageHelper.getMessage("cannotCointinueSender", e2.toString());
                        log.debug(message);
                        throw new RuntimeException(message);
                    }
                }
                sleep = this.internalRun();
            }
        }
        finally {
            SandeshaThread sandeshaThread = this;
            synchronized (sandeshaThread) {
                if (log.isDebugEnabled()) {
                    log.debug("SandeshaThread really stopping " + this);
                }
                this.hasStoppedRunning = true;
                this.notifyAll();
            }
        }
    }
}

