/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.context.ContextManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.SandeshaStorageTransientException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.SandeshaWorker;
import org.apache.sandesha2.workers.WorkerLock;

public class InvokerWorker
extends SandeshaWorker
implements Runnable {
    static final Log log = LogFactory.getLog(InvokerWorker.class);
    static final WorkerLock lock = new WorkerLock();
    private ConfigurationContext configurationContext;
    private String sequence;
    private long messageNumber;
    private String messageContextKey;
    private boolean ignoreNextMsg;
    private boolean pooledThread;
    boolean lastMessageInvoked;

    public InvokerWorker(ConfigurationContext configurationContext, InvokerBean bean) {
        this.setLock(lock);
        this.configurationContext = configurationContext;
        this.initializeFromBean(bean);
    }

    public void forceOutOfOrder() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InvokerWorker::forceOutOfOrder");
        }
        this.ignoreNextMsg = true;
        if (log.isDebugEnabled()) {
            log.debug("Exit: InvokerWorker::forceOutOfOrder");
        }
    }

    public void setPooled() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InvokerWorker::setPooled");
        }
        this.pooledThread = true;
        if (log.isDebugEnabled()) {
            log.debug("Exit: InvokerWorker::setPooled");
        }
    }

    private void initializeFromBean(InvokerBean bean) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InvokerWorker::initializeFromBean " + bean);
        }
        this.sequence = bean.getSequenceID();
        this.messageNumber = bean.getMsgNo();
        this.messageContextKey = bean.getMessageContextRefKey();
        if (log.isDebugEnabled()) {
            log.debug("Exit: InvokerWorker::initializeFromBean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InvokerWorker::run, message " + this.messageNumber + ", sequence " + this.sequence);
        }
        Transaction tran = null;
        try {
            block22: {
                try {
                    InvokerWorker nextWorker = null;
                    Runnable nextRunnable = null;
                    this.lastMessageInvoked = this.invokeMessage(null);
                    while (!this.ignoreNextMsg && this.lastMessageInvoked) {
                        if (log.isDebugEnabled()) {
                            log.debug("InvokerWorker:: looking for next msg to invoke");
                        }
                        InvokerBean finder = new InvokerBean();
                        finder.setSequenceID(this.sequence);
                        finder.setMsgNo(this.messageNumber + 1L);
                        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(this.configurationContext, this.configurationContext.getAxisConfiguration());
                        tran = storageManager.getTransaction();
                        InvokerBeanMgr mgr = storageManager.getInvokerBeanMgr();
                        InvokerBean nextBean = mgr.findUnique(finder);
                        if (nextBean != null) {
                            if (this.pooledThread) {
                                if (log.isDebugEnabled()) {
                                    log.debug("InvokerWorker:: pooledThread");
                                }
                                this.initializeFromBean(nextBean);
                                final Transaction theTran = tran;
                                Runnable work = new Runnable(){

                                    public void run() {
                                        InvokerWorker.this.lastMessageInvoked = InvokerWorker.this.invokeMessage(theTran);
                                    }
                                };
                                ContextManager contextMgr = SandeshaUtil.getContextManager(this.configurationContext);
                                if (contextMgr != null) {
                                    work = contextMgr.wrapWithContext(work, nextBean.getContext());
                                }
                                work.run();
                                tran = null;
                            } else {
                                if (log.isDebugEnabled()) {
                                    log.debug("InvokerWorker:: not pooled thread");
                                }
                                nextWorker = new InvokerWorker(this.configurationContext, nextBean);
                                nextWorker.setPooled();
                                nextWorker.setWorkId(this.workId);
                                ContextManager contextMgr = SandeshaUtil.getContextManager(this.configurationContext);
                                nextRunnable = contextMgr != null ? contextMgr.wrapWithContext(nextWorker, nextBean.getContext()) : nextWorker;
                            }
                        }
                        if (tran != null) {
                            tran.commit();
                        }
                        tran = null;
                        if (nextBean != null && nextWorker == null) continue;
                        break;
                    }
                    if (this.workId != null && lock != null) {
                        lock.removeWork(this.workId);
                    }
                    if (nextWorker == null) break block22;
                    lock.addWork(this.workId, nextWorker);
                    this.configurationContext.getThreadPool().execute(nextRunnable);
                }
                catch (SandeshaException e) {
                    log.debug("Exception within InvokerWorker", e);
                    if (tran != null) {
                        try {
                            tran.rollback();
                        }
                        catch (SandeshaException e2) {
                            log.debug("Exception rolling back tran", e2);
                        }
                    }
                    Object var12_14 = null;
                    if (this.workId != null && lock != null && lock.ownsLock(this.workId, this)) {
                        lock.removeWork(this.workId);
                    }
                }
            }
            Object var12_13 = null;
            if (this.workId != null && lock != null && lock.ownsLock(this.workId, this)) {
                lock.removeWork(this.workId);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (this.workId != null && lock != null && lock.ownsLock(this.workId, this)) {
                lock.removeWork(this.workId);
            }
            throw throwable;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: InvokerWorker::run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean invokeMessage(Transaction tran) {
        block54: {
            block52: {
                block53: {
                    block50: {
                        block51: {
                            block48: {
                                block49: {
                                    if (InvokerWorker.log.isDebugEnabled()) {
                                        InvokerWorker.log.debug("Enter: InvokerWorker::invokeMessage");
                                    }
                                    transaction = null;
                                    msgToInvoke = null;
                                    messageInvoked = true;
                                    if (InvokerWorker.lock != null && !InvokerWorker.lock.ownsLock(this.workId, this)) {
                                        if (InvokerWorker.log.isDebugEnabled()) {
                                            InvokerWorker.log.debug("Exit: InvokerWorker::run, another worker holds the lock");
                                        }
                                        return false;
                                    }
                                    storageManager = SandeshaUtil.getSandeshaStorageManager(this.configurationContext, this.configurationContext.getAxisConfiguration());
                                    invokerBeanMgr = storageManager.getInvokerBeanMgr();
                                    transaction = tran == null ? storageManager.getTransaction() : tran;
                                    invokerBean = invokerBeanMgr.retrieve(this.messageContextKey);
                                    msgToInvoke = storageManager.retrieveMessageContext(this.messageContextKey, this.configurationContext);
                                    if (msgToInvoke != null) break block48;
                                    if (InvokerWorker.log.isDebugEnabled()) {
                                        InvokerWorker.log.debug("null msg");
                                    }
                                    var8_9 = false;
                                    var17_11 = null;
                                    if (transaction == null || !transaction.isActive()) break block49;
                                    try {
                                        transaction.rollback();
                                    }
                                    catch (SandeshaStorageException e) {
                                        if (!InvokerWorker.log.isWarnEnabled()) break block49;
                                        InvokerWorker.log.warn("Caught exception rolling back transaction", e);
                                    }
                                }
                                return var8_9;
                            }
                            if (transaction != null) {
                                transaction.commit();
                                transaction = storageManager.getTransaction();
                            }
                            rmMsg = MsgInitializer.initializeMessage(msgToInvoke);
                            rMDBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, invokerBean.getSequenceID());
                            highestMessage = false;
                            if (this.ignoreNextMsg) ** GOTO lbl61
                            nextMsgNo = rMDBean.getNextMsgNoToProcess();
                            if (invokerBean.getMsgNo() == nextMsgNo) break block50;
                            if (InvokerWorker.log.isDebugEnabled()) {
                                InvokerWorker.log.debug("Operated message number is different from the Next Message Number to invoke");
                            }
                            var13_30 = false;
                            var17_12 = null;
                            if (transaction == null || !transaction.isActive()) break block51;
                            try {
                                transaction.rollback();
                            }
                            catch (SandeshaStorageException e) {
                                if (!InvokerWorker.log.isWarnEnabled()) break block51;
                                InvokerWorker.log.warn("Caught exception rolling back transaction", e);
                            }
                        }
                        return var13_30;
                    }
                    rMDBean.setNextMsgNoToProcess(++nextMsgNo);
                    storageManager.getRMDBeanMgr().update(rMDBean);
lbl61:
                    // 2 sources

                    if (rmMsg.getMessageType() == 3) {
                        sequence = rmMsg.getSequence();
                        if (sequence.getLastMessage()) {
                            highestMessage = true;
                        } else if (rMDBean != null && rMDBean.isTerminated()) {
                            highestInMsgNo = rMDBean.getHighestInMessageNumber();
                            if (invokerBean.getMsgNo() == highestInMsgNo) {
                                highestMessage = true;
                            }
                        }
                    }
                    invokerBeanMgr.delete(this.messageContextKey);
                    storageManager.removeMessageContext(this.messageContextKey);
                    postFailureInvocation = false;
                    postFaulureProperty = (String)msgToInvoke.getProperty("PostFailureMessage");
                    if (postFaulureProperty != null && "true".equals(postFaulureProperty)) {
                        postFailureInvocation = true;
                    }
                    response = null;
                    if (postFailureInvocation) {
                        this.makeMessageReadyForReinjection(msgToInvoke);
                        if (InvokerWorker.log.isDebugEnabled()) {
                            InvokerWorker.log.debug("Receiving message, key=" + this.messageContextKey + ", msgCtx=" + msgToInvoke.getEnvelope().getHeader());
                        }
                        response = AxisEngine.receive(msgToInvoke);
                    } else {
                        if (InvokerWorker.log.isDebugEnabled()) {
                            InvokerWorker.log.debug("Resuming message, key=" + this.messageContextKey + ", msgCtx=" + msgToInvoke.getEnvelope().getHeader());
                        }
                        msgToInvoke.setPaused(false);
                        response = AxisEngine.resumeReceive(msgToInvoke);
                    }
                    if (!Handler.InvocationResponse.SUSPEND.equals(response) && (env = msgToInvoke.getEnvelope()) != null && (sb = (StAXBuilder)msgToInvoke.getEnvelope().getBuilder()) != null) {
                        sb.close();
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                        transaction = storageManager.getTransaction();
                    }
                    if (!highestMessage) break block52;
                    TerminateManager.cleanReceivingSideAfterInvocation(invokerBean.getSequenceID(), storageManager);
                    if (InvokerWorker.log.isDebugEnabled()) {
                        InvokerWorker.log.debug("Exit: InvokerWorker::invokeMessage Last message return " + messageInvoked);
                    }
                    var14_35 = messageInvoked;
                    var17_13 = null;
                    if (transaction == null || !transaction.isActive()) break block53;
                    try {
                        transaction.rollback();
                    }
                    catch (SandeshaStorageException e) {
                        if (!InvokerWorker.log.isWarnEnabled()) break block53;
                        InvokerWorker.log.warn("Caught exception rolling back transaction", e);
                    }
                }
                return var14_35;
            }
            try {
                block56: {
                    break block56;
                    {
                        catch (SandeshaStorageTransientException e) {
                            if (InvokerWorker.log.isDebugEnabled()) {
                                InvokerWorker.log.debug("SandeshaStorageTransientException :", e);
                            }
                            if (transaction != null && transaction.isActive()) {
                                transaction.rollback();
                            }
                            messageInvoked = false;
                        }
                        catch (Exception e) {
                            if (InvokerWorker.log.isDebugEnabled()) {
                                InvokerWorker.log.debug("Exception :", e);
                            }
                            if (transaction != null && transaction.isActive()) {
                                transaction.rollback();
                            }
                            messageInvoked = false;
                            this.handleFault(rmMsg, e);
                        }
                    }
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = null;
                var17_14 = null;
                ** if (transaction == null || !transaction.isActive()) goto lbl-1000
            }
            catch (Throwable var16_37) {
                block55: {
                    var17_16 = null;
                    if (transaction != null && transaction.isActive()) {
                        try {
                            transaction.rollback();
                        }
                        catch (SandeshaStorageException e) {
                            if (!InvokerWorker.log.isWarnEnabled()) break block55;
                            InvokerWorker.log.warn("Caught exception rolling back transaction", e);
                        }
                    }
                }
                throw var16_37;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    transaction.rollback();
                }
                catch (SandeshaStorageException e) {
                    if (InvokerWorker.log.isWarnEnabled()) {
                        InvokerWorker.log.warn("Caught exception rolling back transaction", e);
                    }
                }
            }
lbl-1000:
            // 4 sources

            {
                break block54;
                catch (Exception e) {
                    if (InvokerWorker.log.isErrorEnabled()) {
                        InvokerWorker.log.error(e.toString(), e);
                    }
                    messageInvoked = false;
                    var17_15 = null;
                    if (transaction != null && transaction.isActive()) {
                        try {
                            transaction.rollback();
                        }
                        catch (SandeshaStorageException e) {
                            if (InvokerWorker.log.isWarnEnabled()) {
                                InvokerWorker.log.warn("Caught exception rolling back transaction", e);
                            }
                        }
                    }
                }
            }
        }
        if (InvokerWorker.log.isDebugEnabled()) {
            InvokerWorker.log.debug("Exit: InvokerWorker::invokeMessage " + messageInvoked);
        }
        return messageInvoked;
    }

    private void makeMessageReadyForReinjection(MessageContext messageContext) {
        messageContext.setProperty("WSAddressingVersion", null);
        messageContext.getOptions().setMessageId(null);
        messageContext.getOptions().setTo(null);
        messageContext.getOptions().setAction(null);
        messageContext.setProperty("Sandesha2AppProcessingDone", "true");
    }

    private void handleFault(RMMsgContext inRMMsgContext, Exception e) {
        block7: {
            MessageContext inMsgContext = inRMMsgContext.getMessageContext();
            try {
                MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(inMsgContext, e);
                faultContext.setProperty("ContentType", inMsgContext.getProperty("ContentType"));
                EndpointReference faultEPR = inRMMsgContext.getFaultTo();
                if (faultEPR == null) {
                    faultEPR = inRMMsgContext.getReplyTo();
                }
                if ("Spec_2005_02".equals(inRMMsgContext.getRMSpecVersion()) && (faultEPR == null || faultEPR.hasAnonymousAddress())) {
                    RequestResponseTransport requestResponseTransport = (RequestResponseTransport)inRMMsgContext.getProperty("RequestResponseTransportControl");
                    AxisFault fault = new AxisFault("Sandesha2 got a fault when doing the invocation", faultContext);
                    if (requestResponseTransport != null) {
                        requestResponseTransport.signalFaultReady(fault);
                    } else {
                        AxisEngine.sendFault(faultContext);
                    }
                } else {
                    AxisEngine.sendFault(faultContext);
                }
            }
            catch (AxisFault e1) {
                if (!log.isErrorEnabled()) break block7;
                log.error("Unable to send fault message ", e1);
            }
        }
    }
}

