/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaListener;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.SequenceEntry;
import org.apache.sandesha2.wsrm.CreateSequence;

public class SequenceManager {
    private static Log log = LogFactory.getLog(SequenceManager.class);

    public static RMDBean setupNewSequence(RMMsgContext createSequenceMsg, StorageManager storageManager, SecurityManager securityManager, SecurityToken token) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SequenceManager::setupNewSequence");
        }
        RMDBean rmdBean = new RMDBean();
        EndpointReference to = createSequenceMsg.getTo();
        if (to == null) {
            String message = SandeshaMessageHelper.getMessage("toEPRNotValid", null);
            log.debug(message);
            throw new AxisFault(message);
        }
        EndpointReference replyTo = createSequenceMsg.getReplyTo();
        CreateSequence createSequence = createSequenceMsg.getCreateSequence();
        if (createSequence == null) {
            String message = SandeshaMessageHelper.getMessage("createSeqEntryNotFound");
            log.debug(message);
            throw new AxisFault(message);
        }
        EndpointReference acksTo = createSequence.getAcksTo().getEPR();
        if (acksTo == null) {
            log.error(SandeshaMessageHelper.getMessage("acksToInvalid", ""));
            FaultManager.makeCreateSequenceRefusedFault(createSequenceMsg, SandeshaMessageHelper.getMessage("noAcksToPartInCreateSequence"), new Exception(), null);
            return null;
        }
        if (acksTo.getAddress().equals("http://www.w3.org/2005/08/addressing/none")) {
            log.error(SandeshaMessageHelper.getMessage("acksToInvalid", acksTo.getAddress()));
            FaultManager.makeCreateSequenceRefusedFault(createSequenceMsg, "AcksTo can not be http://www.w3.org/2005/08/addressing/none", new Exception(), null);
            return null;
        }
        MessageContext createSeqContext = createSequenceMsg.getMessageContext();
        SequenceEntry entry = (SequenceEntry)createSeqContext.getProperty("Sandesha2MakeConnectionEntry");
        if (log.isDebugEnabled()) {
            log.debug("This message is associated with sequence entry: " + entry);
        }
        if (entry != null && entry.isRmSource()) {
            rmdBean.setOutboundInternalSequence(entry.getSequenceId());
        }
        rmdBean.setServerCompletedMessages(new RangeString());
        rmdBean.setReplyToEndpointReference(to);
        rmdBean.setAcksToEndpointReference(acksTo);
        if (replyTo != null) {
            rmdBean.setToEndpointReference(replyTo);
        }
        if (token != null) {
            String tokenData = securityManager.getTokenRecoveryData(token);
            rmdBean.setSecurityTokenData(tokenData);
        }
        rmdBean.setSequenceID(SandeshaUtil.getUUID());
        rmdBean.setNextMsgNoToProcess(1L);
        rmdBean.setToAddress(to.getAddress());
        if (to.hasAnonymousAddress()) {
            String newKey = SandeshaUtil.getUUID();
            rmdBean.setPollingMode(true);
            rmdBean.setReferenceMessageKey(newKey);
            storageManager.storeMessageContext(newKey, createSeqContext);
        }
        String messageRMNamespace = createSequence.getNamespaceValue();
        String specVersion = null;
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(messageRMNamespace)) {
            specVersion = "Spec_2005_02";
        } else if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(messageRMNamespace)) {
            specVersion = "Spec_2007_02";
        } else {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotDecideRMVersion"));
        }
        rmdBean.setRMVersion(specVersion);
        rmdBean.setLastActivatedTime(System.currentTimeMillis());
        storageManager.getRMDBeanMgr().insert(rmdBean);
        if (log.isDebugEnabled()) {
            log.debug("Exit: SequenceManager::setupNewSequence, " + rmdBean);
        }
        return rmdBean;
    }

    public void removeSequence(String sequence) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static RMSBean setupNewClientSequence(MessageContext firstAplicationMsgCtx, String internalSequenceId, StorageManager storageManager) throws SandeshaException {
        Object avoidAutoTermination;
        EndpointReference replyToEPR;
        EndpointReference acksToEPR;
        String specVersion;
        RMSBean rmsBean;
        block20: {
            String acksTo;
            if (log.isDebugEnabled()) {
                log.debug("Enter: SequenceManager::setupNewClientSequence");
            }
            rmsBean = new RMSBean();
            rmsBean.setInternalSequenceID(internalSequenceId);
            String inboundSequence = null;
            RMDBean inboundBean = null;
            if (firstAplicationMsgCtx.isServerSide() && (inboundSequence = (String)firstAplicationMsgCtx.getProperty("Sandesha2InboundSequenceId")) != null) {
                inboundBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, inboundSequence);
                if (log.isDebugEnabled()) {
                    log.debug("SequenceManager:: server side app msg: inboundBean=" + inboundBean);
                }
            }
            specVersion = SequenceManager.getSpecVersion(firstAplicationMsgCtx, storageManager);
            rmsBean.setRMVersion(specVersion);
            EndpointReference toEPR = firstAplicationMsgCtx.getTo();
            if (toEPR == null) {
                String message = SandeshaMessageHelper.getMessage("toEPRNotValid", null);
                log.debug(message);
                throw new SandeshaException(message);
            }
            rmsBean.setToEndpointReference(toEPR);
            acksToEPR = null;
            replyToEPR = null;
            if (firstAplicationMsgCtx.isServerSide()) {
                EndpointReference strippedReplyToEpr = SequenceManager.stripAddress(inboundBean.getReplyToEndpointReference());
                if (inboundBean != null && strippedReplyToEpr != null) {
                    acksToEPR = strippedReplyToEpr;
                    replyToEPR = strippedReplyToEpr;
                    break block20;
                } else {
                    String beanInfo = inboundBean == null ? "null" : inboundBean.toString();
                    String message = SandeshaMessageHelper.getMessage("cannotChooseAcksTo", inboundSequence, beanInfo);
                    SandeshaException e = new SandeshaException(message);
                    if (log.isDebugEnabled()) {
                        log.debug("Throwing", e);
                    }
                    throw e;
                }
            }
            replyToEPR = firstAplicationMsgCtx.getReplyTo();
            if (replyToEPR != null && replyToEPR.hasNoneAddress()) {
                replyToEPR = null;
            }
            if ((acksTo = (String)firstAplicationMsgCtx.getProperty("Sandesha2AcksTo")) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Using explicit AcksTo, addr=" + acksTo);
                }
                acksToEPR = new EndpointReference(acksTo);
            } else if (replyToEPR != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Using replyTo EPR as AcksTo, addr=" + replyToEPR.getAddress());
                }
                acksToEPR = replyToEPR;
            }
        }
        ConfigurationContext config2 = firstAplicationMsgCtx.getConfigurationContext();
        if ("Spec_2007_02".equals(specVersion)) {
            replyToEPR = SandeshaUtil.rewriteEPR(rmsBean, replyToEPR, config2);
            acksToEPR = SandeshaUtil.rewriteEPR(rmsBean, acksToEPR, config2);
        }
        if (replyToEPR != null) {
            rmsBean.setReplyToEndpointReference(replyToEPR);
        }
        if (acksToEPR != null) {
            rmsBean.setAcksToEndpointReference(acksToEPR);
        }
        rmsBean.setClientCompletedMessages(new RangeString());
        String transportTo = (String)firstAplicationMsgCtx.getProperty("TransportURL");
        if (transportTo != null) {
            rmsBean.setTransportTo(transportTo);
        }
        rmsBean.setSoapVersion(SandeshaUtil.getSOAPVersion(firstAplicationMsgCtx.getEnvelope()));
        if (!firstAplicationMsgCtx.isServerSide() && (avoidAutoTermination = firstAplicationMsgCtx.getProperty("AviodAutoTermination")) != null && JavaUtils.isTrueExplicitly(avoidAutoTermination)) {
            rmsBean.setAvoidAutoTermination(true);
        }
        rmsBean.setLastActivatedTime(System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug("Exit: SequenceManager::setupNewClientSequence " + rmsBean);
        }
        return rmsBean;
    }

    public static boolean hasSequenceTimedOut(RMSBean rmsBean, String internalSequenceId, StorageManager storageManager) throws SandeshaException {
        SandeshaPolicyBean propertyBean = SandeshaUtil.getPropertyBean(storageManager.getContext().getAxisConfiguration());
        if (propertyBean.getInactivityTimeoutInterval() <= 0L) {
            return false;
        }
        boolean sequenceTimedOut = false;
        long lastActivatedTime = rmsBean.getLastActivatedTime();
        long timeNow = System.currentTimeMillis();
        if (lastActivatedTime > 0L && lastActivatedTime + propertyBean.getInactivityTimeoutInterval() < timeNow) {
            sequenceTimedOut = true;
        }
        return sequenceTimedOut;
    }

    public static void finalizeTimedOutSequence(String internalSequenceID, MessageContext messageContext, StorageManager storageManager) throws SandeshaException {
        SandeshaListener listener;
        ConfigurationContext configurationContext;
        block6: {
            if (log.isDebugEnabled()) {
                log.debug("Enter: SequenceManager::finalizeTimedOutSequence:" + internalSequenceID);
            }
            configurationContext = null;
            configurationContext = messageContext == null ? storageManager.getContext() : messageContext.getConfigurationContext();
            AxisFault fault = new AxisFault(SandeshaMessageHelper.getMessage("cannotSendMsgAsSequenceTimedout", internalSequenceID));
            FaultManager.notifyClientsOfFault(internalSequenceID, storageManager, configurationContext, fault);
            try {
                RMSBean bean = new RMSBean();
                bean.setInternalSequenceID(internalSequenceID);
                storageManager.getRMSBeanMgr().findUnique(bean);
                if (bean != null) {
                    TerminateManager.checkAndTerminate(configurationContext, storageManager, bean);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("SequenceManager::finalizeTimedOutSequence:Error caught:" + e);
            }
        }
        TerminateManager.timeOutSendingSideSequence(internalSequenceID, storageManager);
        if (messageContext != null && (listener = (SandeshaListener)messageContext.getProperty("Sandesha2Listener")) != null) {
            SequenceReport report = SandeshaClient.getOutgoingSequenceReport(internalSequenceID, configurationContext, false);
            listener.onTimeOut(report);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SequenceManager::finalizeTimedOutSequence");
        }
    }

    public static String getSpecVersion(MessageContext applicationMessage, StorageManager storageManager) throws SandeshaException {
        String specVersion = null;
        if (applicationMessage.isServerSide()) {
            String inboundSequence = null;
            RMSequenceBean inboundBean = null;
            if (applicationMessage.isServerSide() && (inboundSequence = (String)applicationMessage.getProperty("Sandesha2InboundSequenceId")) != null) {
                inboundBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, inboundSequence);
            }
            if (inboundBean == null || inboundBean.getRMVersion() == null) {
                String beanInfo = inboundBean == null ? "null" : ((RMDBean)inboundBean).toString();
                String message = SandeshaMessageHelper.getMessage("cannotChooseSpecLevel", inboundSequence, beanInfo);
                SandeshaException e = new SandeshaException(message);
                if (log.isDebugEnabled()) {
                    log.debug("Throwing", e);
                }
                throw e;
            }
            specVersion = inboundBean.getRMVersion();
        } else {
            specVersion = (String)applicationMessage.getProperty("Sandesha2RMSpecVersion");
            Parameter opLevel = applicationMessage.getAxisOperation().getParameter("Sandesha2RMSpecVersion");
            if (specVersion == null && opLevel != null) {
                specVersion = (String)opLevel.getValue();
            }
        }
        if (specVersion == null) {
            specVersion = SpecSpecificConstants.getDefaultSpecVersion();
        }
        return specVersion;
    }

    private static EndpointReference stripAddress(EndpointReference eprIn) {
        if (log.isDebugEnabled()) {
            log.debug("stripAddress from EndpointReference : " + eprIn);
        }
        EndpointReference epr = new EndpointReference(eprIn.getAddress());
        return epr;
    }
}

