/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.Iterator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.CloseSequenceResponse;
import org.apache.sandesha2.wsrm.CreateSequence;
import org.apache.sandesha2.wsrm.CreateSequenceResponse;
import org.apache.sandesha2.wsrm.MakeConnection;
import org.apache.sandesha2.wsrm.Sequence;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;
import org.apache.sandesha2.wsrm.TerminateSequence;
import org.apache.sandesha2.wsrm.TerminateSequenceResponse;

public class MsgInitializer {
    public static RMMsgContext initializeMessage(MessageContext ctx) throws AxisFault {
        RMMsgContext rmMsgCtx = new RMMsgContext(ctx);
        MsgInitializer.populateRMMsgContext(ctx, rmMsgCtx);
        return rmMsgCtx;
    }

    private static void populateRMMsgContext(MessageContext msgCtx, RMMsgContext rmMsgContext) throws AxisFault {
        AckRequested ackRequest;
        rmMsgContext.fromSOAPEnvelope(msgCtx.getEnvelope(), msgCtx.getWSAAction());
        String sequenceID = null;
        CreateSequence createSequence = rmMsgContext.getCreateSequence();
        CreateSequenceResponse createSequenceResponse = rmMsgContext.getCreateSequenceResponse();
        TerminateSequence terminateSequence = rmMsgContext.getTerminateSequence();
        TerminateSequenceResponse terminateSequenceResponse = rmMsgContext.getTerminateSequenceResponse();
        Iterator sequenceAcknowledgementsIter = rmMsgContext.getSequenceAcknowledgements();
        Sequence sequence = rmMsgContext.getSequence();
        Iterator ackRequestedIter = rmMsgContext.getAckRequests();
        CloseSequence closeSequence = rmMsgContext.getCloseSequence();
        CloseSequenceResponse closeSequenceResponse = rmMsgContext.getCloseSequenceResponse();
        MakeConnection makeConnection = rmMsgContext.getMakeConnection();
        String rmNamespace = null;
        if (createSequence != null) {
            rmNamespace = createSequence.getNamespaceValue();
        }
        if (createSequenceResponse != null) {
            rmNamespace = createSequenceResponse.getNamespaceValue();
        }
        if (sequence != null) {
            rmNamespace = sequence.getNamespaceValue();
        }
        while (sequenceAcknowledgementsIter.hasNext()) {
            SequenceAcknowledgement sequenceAck = (SequenceAcknowledgement)sequenceAcknowledgementsIter.next();
            rmNamespace = sequenceAck.getNamespaceValue();
        }
        if (terminateSequence != null) {
            rmNamespace = terminateSequence.getNamespaceValue();
        }
        if (terminateSequenceResponse != null) {
            rmNamespace = terminateSequenceResponse.getNamespaceValue();
        }
        while (ackRequestedIter.hasNext()) {
            ackRequest = (AckRequested)ackRequestedIter.next();
            rmNamespace = ackRequest.getNamespaceValue();
        }
        if (closeSequence != null) {
            rmNamespace = closeSequence.getNamespaceValue();
        }
        if (closeSequenceResponse != null) {
            rmNamespace = closeSequenceResponse.getNamespaceValue();
        }
        if (makeConnection != null && "http://docs.oasis-open.org/ws-rx/wsmc/200702".equals(makeConnection.getNamespaceValue())) {
            rmNamespace = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
        }
        if (rmMsgContext.getMessagePending() != null) {
            rmNamespace = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
        }
        if (rmNamespace != null) {
            rmMsgContext.setRMNamespaceValue(rmNamespace);
        }
        sequenceAcknowledgementsIter = rmMsgContext.getSequenceAcknowledgements();
        ackRequestedIter = rmMsgContext.getAckRequests();
        if (createSequence != null) {
            rmMsgContext.setMessageType(1);
        } else if (createSequenceResponse != null) {
            rmMsgContext.setMessageType(2);
            sequenceID = createSequenceResponse.getIdentifier().getIdentifier();
        } else if (terminateSequence != null) {
            rmMsgContext.setMessageType(7);
            sequenceID = terminateSequence.getIdentifier().getIdentifier();
        } else if (terminateSequenceResponse != null) {
            rmMsgContext.setMessageType(9);
            sequenceID = terminateSequenceResponse.getIdentifier().getIdentifier();
        } else if (sequence != null) {
            Sequence seq = rmMsgContext.getSequence();
            boolean lastMessage = seq.getLastMessage();
            SOAPEnvelope envelope = rmMsgContext.getSOAPEnvelope();
            if (lastMessage && envelope.getBody().getFirstOMChild() == null) {
                rmMsgContext.setMessageType(12);
            } else {
                rmMsgContext.setMessageType(3);
            }
            sequenceID = sequence.getIdentifier().getIdentifier();
        } else if (makeConnection != null) {
            rmMsgContext.setMessageType(11);
            if (makeConnection.getIdentifier() != null) {
                sequenceID = makeConnection.getIdentifier().getIdentifier();
            } else if (makeConnection.getAddress() != null) {
                // empty if block
            }
        } else if (ackRequestedIter.hasNext()) {
            rmMsgContext.setMessageType(8);
            ackRequest = (AckRequested)ackRequestedIter.next();
            if (!ackRequestedIter.hasNext()) {
                sequenceID = ackRequest.getIdentifier().getIdentifier();
            }
        } else if (closeSequence != null) {
            rmMsgContext.setMessageType(5);
            sequenceID = closeSequence.getIdentifier().getIdentifier();
        } else if (closeSequenceResponse != null) {
            rmMsgContext.setMessageType(6);
            sequenceID = closeSequenceResponse.getIdentifier().getIdentifier();
        } else if (sequenceAcknowledgementsIter.hasNext()) {
            rmMsgContext.setMessageType(4);
            SequenceAcknowledgement sequenceAcknowledgement = (SequenceAcknowledgement)sequenceAcknowledgementsIter.next();
            if (!sequenceAcknowledgementsIter.hasNext()) {
                sequenceID = sequenceAcknowledgement.getIdentifier().getIdentifier();
            }
        } else {
            rmMsgContext.setMessageType(0);
        }
        if (sequenceID != null) {
            rmMsgContext.setProperty("WSRMSequenceId", sequenceID);
        }
    }
}

