/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.inmemory;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMBean;
import org.apache.sandesha2.storage.inmemory.InMemoryStorageManager;
import org.apache.sandesha2.util.LoggingControl;

public class InMemoryTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog(InMemoryTransaction.class);
    private InMemoryStorageManager manager;
    private String threadName;
    private ArrayList enlistedBeans = new ArrayList();
    private boolean sentMessages = false;
    private boolean active = true;
    private Thread thread;
    private boolean useSerialization;

    InMemoryTransaction(InMemoryStorageManager manager, Thread thread, boolean useSerialization) {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Entry: InMemoryTransaction::<init>");
        }
        this.manager = manager;
        this.thread = thread;
        this.threadName = thread.getName();
        this.useSerialization = useSerialization;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: InMemoryTransaction::<init>, " + this);
        }
    }

    public void commit() {
        this.releaseLocks();
        if (this.sentMessages && this.useSerialization) {
            this.manager.getSender().wakeThread();
        }
        this.active = false;
    }

    public void rollback() {
        this.releaseLocks();
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enlist(RMBean bean) {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Entry: InMemoryTransaction::enlist, " + bean);
        }
        if (bean != null) {
            DummyTransaction tran = null;
            RMBean rMBean = bean;
            synchronized (rMBean) {
                tran = (DummyTransaction)bean.getTransaction();
                if (tran == null) {
                    tran = new DummyTransaction();
                    bean.setTransaction(tran);
                }
            }
            boolean locked = false;
            while (!locked) {
                locked = tran.tryLock();
                if (!locked) {
                    try {
                        locked = tran.tryLock(5L, TimeUnit.SECONDS);
                        if (!locked && log.isDebugEnabled()) {
                            log.debug("Waiting for bean lock 5 seconds");
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.enlistedBeans.add(bean);
            }
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: InMemoryTransaction::enlist");
        }
    }

    private void releaseLocks() {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Entry: InMemoryTransaction::releaseLocks, " + this);
        }
        this.manager.removeTransaction(this);
        for (RMBean bean : this.enlistedBeans) {
            DummyTransaction tran = (DummyTransaction)bean.getTransaction();
            tran.unlock();
        }
        this.enlistedBeans.clear();
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: InMemoryTransaction::releaseLocks");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[InMemoryTransaction, thread:");
        result.append(this.thread);
        result.append(", name: ");
        result.append(this.threadName);
        result.append(", locks: ");
        result.append(this.enlistedBeans.size());
        result.append("]");
        return result.toString();
    }

    public void setSentMessages(boolean sentMessages) {
        this.sentMessages = sentMessages;
    }

    public Thread getThread() {
        return this.thread;
    }

    private class DummyTransaction
    extends ReentrantLock
    implements Transaction {
        private static final long serialVersionUID = -8095723965216941864L;

        private DummyTransaction() {
        }

        public void commit() throws SandeshaStorageException {
            throw new SandeshaStorageException("Not supported");
        }

        public boolean isActive() {
            return false;
        }

        public void rollback() throws SandeshaStorageException {
            throw new SandeshaStorageException("Not supported");
        }
    }
}

