/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.inmemory;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.AbstractContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.storage.inmemory.InMemoryBeanMgr;
import org.apache.sandesha2.storage.inmemory.InMemoryStorageManager;
import org.apache.sandesha2.util.LoggingControl;

public class InMemorySenderBeanMgr
extends InMemoryBeanMgr
implements SenderBeanMgr {
    private static final Log log = LogFactory.getLog(InMemorySenderBeanMgr.class);
    ConcurrentHashMap sequenceIdandMessNum2MessageId = new ConcurrentHashMap();

    public InMemorySenderBeanMgr(InMemoryStorageManager mgr, AbstractContext context) {
        super(mgr, context, "RetransmitterBeanMap");
    }

    public boolean delete(String MessageId) throws SandeshaStorageException {
        SenderBean bean = (SenderBean)super.delete(MessageId);
        if (bean.getSequenceID() != null && bean.getMessageNumber() > 0L) {
            this.sequenceIdandMessNum2MessageId.remove(bean.getSequenceID() + ":" + bean.getMessageNumber());
        }
        return bean != null;
    }

    public SenderBean retrieve(String MessageId) throws SandeshaStorageException {
        return (SenderBean)super.retrieve(MessageId);
    }

    public SenderBean retrieve(String sequnceId, long messageNumber) throws SandeshaStorageException {
        String MessageId = (String)this.sequenceIdandMessNum2MessageId.get(sequnceId + ":" + messageNumber);
        if (MessageId == null) {
            return null;
        }
        return (SenderBean)super.retrieve(MessageId);
    }

    public boolean insert(SenderBean bean) throws SandeshaStorageException {
        if (bean.getMessageID() == null) {
            throw new SandeshaStorageException(SandeshaMessageHelper.getMessage("nullMsgId"));
        }
        boolean result = super.insert(bean.getMessageID(), bean);
        if (bean.getSequenceID() != null && bean.getMessageNumber() > 0L) {
            this.sequenceIdandMessNum2MessageId.put(bean.getSequenceID() + ":" + bean.getMessageNumber(), bean.getMessageID());
        }
        this.mgr.getInMemoryTransaction().setSentMessages(true);
        return result;
    }

    public List find(String internalSequenceID) throws SandeshaStorageException {
        SenderBean temp = new SenderBean();
        temp.setInternalSequenceID(internalSequenceID);
        return super.find(temp);
    }

    public List find(SenderBean bean) throws SandeshaStorageException {
        return super.find(bean);
    }

    public SenderBean getNextMsgToSend(String sequenceId) throws SandeshaStorageException {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Entry: InMemorySenderBeanManager::getNextMessageToSend " + sequenceId);
        }
        SenderBean matcher = new SenderBean();
        matcher.setSend(true);
        matcher.setSequenceID(sequenceId);
        matcher.setTimeToSend(System.currentTimeMillis());
        matcher.setTransportAvailable(true);
        List matches = super.findNoLock(matcher);
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Found " + matches.size() + " messages");
        }
        SenderBean result = null;
        for (SenderBean bean : matches) {
            if (bean.getTimeToSend() < 0L || bean.getSentCount() > 0 && !bean.isReSend() || !bean.match(matcher)) continue;
            if (result == null) {
                result = bean;
                continue;
            }
            if (result.getTimeToSend() <= bean.getTimeToSend()) continue;
            result = bean;
        }
        if (result != null && !(result = this.retrieve(result.getMessageID())).match(matcher)) {
            result = null;
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug("Exit: InMemorySenderBeanManager::getNextMessageToSend " + result);
        }
        return result;
    }

    public boolean update(SenderBean bean) throws SandeshaStorageException {
        boolean result = super.update(bean.getMessageID(), bean);
        if (bean.getSequenceID() != null && bean.getMessageNumber() > 0L) {
            this.sequenceIdandMessNum2MessageId.put(bean.getSequenceID() + ":" + bean.getMessageNumber(), bean.getMessageID());
        }
        this.mgr.getInMemoryTransaction().setSentMessages(true);
        return result;
    }

    public SenderBean findUnique(SenderBean bean) throws SandeshaException {
        return (SenderBean)super.findUnique(bean);
    }

    public SenderBean retrieveFromMessageRefKey(String messageContextRefKey) {
        throw new UnsupportedOperationException("Deprecated method");
    }
}

