/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.inmemory;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.context.AbstractContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.inmemory.InMemoryBeanMgr;
import org.apache.sandesha2.storage.inmemory.InMemoryStorageManager;
import org.apache.sandesha2.util.LoggingControl;

public class InMemoryInvokerBeanMgr
extends InMemoryBeanMgr
implements InvokerBeanMgr {
    private static final Log log = LogFactory.getLog(InMemoryInvokerBeanMgr.class);
    private Lock lock = new ReentrantLock();

    public InMemoryInvokerBeanMgr(InMemoryStorageManager mgr, AbstractContext context) {
        super(mgr, context, "StorageMapBeanMap");
    }

    public boolean insert(InvokerBean bean) throws SandeshaStorageException {
        InvokerBean finder = new InvokerBean();
        finder.setMsgNo(bean.getMsgNo());
        finder.setSequenceID(bean.getSequenceID());
        this.lock.lock();
        boolean result = false;
        if (super.findUnique(finder) != null) {
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug("InMemoryInvokerBeanMgr insert failed due to existing invoker bean");
            }
            result = false;
        } else {
            result = super.insert(bean.getMessageContextRefKey(), bean);
        }
        this.lock.unlock();
        return result;
    }

    public boolean delete(String key) throws SandeshaStorageException {
        this.lock.lock();
        boolean result = super.delete(key) != null;
        this.lock.unlock();
        return result;
    }

    public InvokerBean retrieve(String key) throws SandeshaStorageException {
        return (InvokerBean)super.retrieve(key);
    }

    public List find(InvokerBean bean) throws SandeshaStorageException {
        return super.find(bean);
    }

    public boolean update(InvokerBean bean) throws SandeshaStorageException {
        return super.update(bean.getMessageContextRefKey(), bean);
    }

    public InvokerBean findUnique(InvokerBean bean) throws SandeshaException {
        return (InvokerBean)super.findUnique(bean);
    }
}

