/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.OperationContextFactory;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.WSRMMessageSender;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;

public class CloseSequenceProcessor
extends WSRMMessageSender
implements MsgProcessor {
    private static final Log log = LogFactory.getLog(CloseSequenceProcessor.class);

    public boolean processInMessage(RMMsgContext rmMsgCtx, Transaction transaction) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: CloseSequenceProcessor::processInMessage");
        }
        ConfigurationContext configCtx = rmMsgCtx.getMessageContext().getConfigurationContext();
        CloseSequence closeSequence = rmMsgCtx.getCloseSequence();
        MessageContext msgCtx = rmMsgCtx.getMessageContext();
        String sequenceId = closeSequence.getIdentifier().getIdentifier();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configCtx, configCtx.getAxisConfiguration());
        RMSequenceBean rmBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceId);
        if (rmBean == null) {
            rmBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sequenceId);
        }
        SandeshaUtil.assertProofOfPossession(rmBean, msgCtx, msgCtx.getEnvelope().getBody());
        if (FaultManager.checkForUnknownSequence(rmMsgCtx, sequenceId, storageManager, false)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: CloseSequenceProcessor::processInMessage, Unknown sequence " + sequenceId);
            }
            return false;
        }
        if (FaultManager.checkForSequenceTerminated(rmMsgCtx, sequenceId, rmBean, false)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: CloseSequenceProcessor::processInMessage, Sequence terminated");
            }
            return false;
        }
        rmBean.setClosed(true);
        Iterator sequenceAckIter = null;
        if (rmBean instanceof RMDBean) {
            storageManager.getRMDBeanMgr().update((RMDBean)rmBean);
            RMMsgContext ackRMMsgCtx = AcknowledgementManager.generateAckMessage(rmMsgCtx, (RMDBean)rmBean, sequenceId, storageManager, true);
            sequenceAckIter = ackRMMsgCtx.getSequenceAcknowledgements();
        } else {
            storageManager.getRMSBeanMgr().update((RMSBean)rmBean);
        }
        RMMsgContext closeSeqResponseRMMsg = RMMsgCreator.createCloseSeqResponseMsg(rmMsgCtx, rmBean);
        MessageContext closeSequenceResponseMsg = closeSeqResponseRMMsg.getMessageContext();
        while (sequenceAckIter != null && sequenceAckIter.hasNext()) {
            SequenceAcknowledgement sequenceAcknowledgement = (SequenceAcknowledgement)sequenceAckIter.next();
            closeSeqResponseRMMsg.addSequenceAcknowledgement(sequenceAcknowledgement);
        }
        closeSeqResponseRMMsg.setFlow(2);
        closeSeqResponseRMMsg.setProperty("Sandesha2AppProcessingDone", "true");
        closeSequenceResponseMsg.setResponseWritten(true);
        if (rmBean instanceof RMSBean && rmBean.getRMVersion().equals("Spec_2007_02")) {
            closeSequenceResponseMsg.setReplyTo(rmBean.getReplyToEndpointReference());
        }
        closeSeqResponseRMMsg.addSOAPEnvelope();
        if (transaction != null && transaction.isActive()) {
            transaction.commit();
            transaction = null;
        }
        try {
            AxisEngine.send(closeSequenceResponseMsg);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("couldNotSendCloseResponse", sequenceId, e.toString());
            throw new SandeshaException(message, e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: CloseSequenceProcessor::processInMessage " + Boolean.FALSE);
        }
        return false;
    }

    public boolean processOutMessage(RMMsgContext rmMsgCtx, Transaction transaction) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: CloseSequenceProcessor::processOutMessage");
        }
        this.setupOutMessage(rmMsgCtx);
        this.getRMSBean().setSequenceClosedClient(true);
        this.getStorageManager().getRMSBeanMgr().update(this.getRMSBean());
        AxisOperation closeOperation = SpecSpecificConstants.getWSRMOperation(5, rmMsgCtx.getRMSpecVersion(), rmMsgCtx.getMessageContext().getAxisService());
        this.getMsgContext().setAxisOperation(closeOperation);
        OperationContext opcontext = OperationContextFactory.createOperationContext(closeOperation.getAxisSpecificMEPConstant(), closeOperation, this.getMsgContext().getServiceContext());
        opcontext.setParent(this.getMsgContext().getServiceContext());
        this.getConfigurationContext().registerOperationContext(rmMsgCtx.getMessageId(), opcontext);
        this.getMsgContext().setOperationContext(opcontext);
        CloseSequence closeSequencePart = rmMsgCtx.getCloseSequence();
        Identifier identifier = closeSequencePart.getIdentifier();
        if (identifier == null) {
            identifier = new Identifier(closeSequencePart.getNamespaceValue());
            closeSequencePart.setIdentifier(identifier);
        }
        rmMsgCtx.setWSAAction(SpecSpecificConstants.getCloseSequenceAction(this.getRMVersion()));
        rmMsgCtx.setSOAPAction(SpecSpecificConstants.getCloseSequenceAction(this.getRMVersion()));
        this.sendOutgoingMessage(rmMsgCtx, 5, 0L, transaction);
        rmMsgCtx.pause();
        if (log.isDebugEnabled()) {
            log.debug("Exit: CloseSeqMsgProcessor::processOutMessage " + Boolean.TRUE);
        }
        return true;
    }
}

