/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.handlers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;

public class SequenceIDDispatcher
extends AbstractDispatcher {
    private static final String NAME = "SequenceIDDIspatcher";
    private static final Log log = LogFactory.getLog(SequenceIDDispatcher.class);

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AxisService findService(MessageContext msgContext) throws AxisFault {
        AxisService service;
        block11: {
            Parameter unreliableParam;
            if (log.isDebugEnabled()) {
                log.debug("Enter: SequenceIDDispatcher::findService, " + msgContext.getEnvelope().getHeader());
            }
            if (msgContext.getAxisService() != null && null != (unreliableParam = msgContext.getAxisService().getParameter("Sandesha2UnreliableMessage")) && "true".equals(unreliableParam.getValue())) {
                if (log.isDebugEnabled()) {
                    log.debug("Exit: SequenceIDDispatcher::findService, Service has disabled RM ");
                }
                return null;
            }
            ConfigurationContext configurationContext = msgContext.getConfigurationContext();
            RMMsgContext rmmsgContext = MsgInitializer.initializeMessage(msgContext);
            StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
            Transaction transaction = storageManager.getTransaction();
            service = null;
            try {
                String sequenceID = (String)rmmsgContext.getProperty("WSRMSequenceId");
                service = null;
                if (sequenceID != null) {
                    RMSBean rmsBean;
                    RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceID);
                    String serviceName = null;
                    if (rmdBean != null) {
                        serviceName = rmdBean.getServiceName();
                    }
                    if (serviceName != null) {
                        service = configurationContext.getAxisConfiguration().getService(serviceName);
                    }
                    if (service == null && rmdBean == null && (serviceName = (rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sequenceID)).getServiceName()) != null) {
                        service = configurationContext.getAxisConfiguration().getService(serviceName);
                    }
                }
                Object var12_11 = null;
                if (transaction == null || !transaction.isActive()) break block11;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                throw throwable;
            }
            transaction.commit();
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SequenceIDDispatcher::findService, " + service);
        }
        return service;
    }
}

