/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.PrivilegedAction;
import org.apache.axis2.java.security.AccessController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Loader {
    private static final Log log = LogFactory.getLog(Loader.class);

    public static URL getResource(String resource) {
        ClassLoader classLoader = null;
        URL url = null;
        try {
            classLoader = Loader.getTCL();
            if (classLoader != null) {
                log.debug("Trying to find [" + resource + "] using " + classLoader + " class loader.");
                url = classLoader.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
        }
        catch (Throwable t) {
            log.warn("Caught Exception while in Loader.getResource. This may be innocuous.", t);
        }
        log.debug("Trying to find [" + resource + "] using ClassLoader.getSystemResource().");
        return ClassLoader.getSystemResource(resource);
    }

    public static URL getResource(ClassLoader loader, String resource) throws ClassNotFoundException {
        URL url = null;
        try {
            if (loader != null) {
                log.debug("Trying to find [" + resource + "] using " + loader + " class loader.");
                url = loader.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
        }
        catch (Throwable t) {
            log.warn("Caught Exception while in Loader.getResource. This may be innocuous.", t);
        }
        return Loader.getResource(resource);
    }

    public static InputStream getResourceAsStream(String resource) {
        InputStream is;
        ClassLoader classLoader = null;
        try {
            classLoader = Loader.getTCL();
            if (classLoader != null) {
                log.debug("Trying to find [" + resource + "] using " + classLoader + " class loader.");
                is = classLoader.getResourceAsStream(resource);
                if (is != null) {
                    return is;
                }
            }
        }
        catch (Throwable t) {
            log.warn("Caught Exception while in Loader.getResourceAsStream. This may be innocuous.", t);
        }
        try {
            classLoader = Loader.class.getClassLoader();
            if (classLoader != null) {
                log.debug("Trying to find [" + resource + "] using " + classLoader + " class loader.");
                is = classLoader.getResourceAsStream(resource);
                if (is != null) {
                    return is;
                }
            }
        }
        catch (Throwable t) {
            log.warn("Caught Exception while in Loader.getResourceAsStream. This may be innocuous.", t);
        }
        log.debug("Trying to find [" + resource + "] using ClassLoader.getSystemResourceAsStream().");
        return ClassLoader.getSystemResourceAsStream(resource);
    }

    public static InputStream getResourceAsStream(ClassLoader loader, String resource) throws ClassNotFoundException {
        try {
            if (loader != null) {
                log.debug("Trying to find [" + resource + "] using " + loader + " class loader.");
                InputStream is = loader.getResourceAsStream(resource);
                if (is != null) {
                    return is;
                }
            }
        }
        catch (Throwable t) {
            log.warn("Caught Exception while in Loader.getResource. This may be innocuous.", t);
        }
        return Loader.getResourceAsStream(resource);
    }

    private static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static Class loadClass(ClassLoader loader, String clazz) throws ClassNotFoundException {
        try {
            Class<?> c;
            if (loader != null && (c = loader.loadClass(clazz)) != null) {
                return c;
            }
        }
        catch (UnsupportedClassVersionError e) {
            log.debug(e);
            throw e;
        }
        catch (Throwable e) {
            log.debug(e);
        }
        return Loader.loadClass(clazz);
    }

    public static Class loadClass(String clazz) throws ClassNotFoundException {
        try {
            Class<?> c;
            ClassLoader tcl = Loader.getTCL();
            if (tcl != null && (c = tcl.loadClass(clazz)) != null) {
                return c;
            }
        }
        catch (UnsupportedClassVersionError e) {
            log.debug(e);
            throw e;
        }
        catch (Throwable e) {
            log.debug(e);
        }
        return Class.forName(clazz);
    }
}

