/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.xmpp.util;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.concurrent.Executor;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.xmpp.util.XMPPConnectionFactory;
import org.apache.axis2.transport.xmpp.util.XMPPOutTransportInfo;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;

public class XMPPPacketListener
implements PacketListener {
    private static final Log log = LogFactory.getLog(XMPPPacketListener.class);
    private XMPPConnectionFactory xmppConnectionFactory = null;
    private ConfigurationContext configurationContext = null;
    private Executor workerPool = null;
    public static final String CONTENT_TYPE = "mail.contenttype";

    public XMPPPacketListener(XMPPConnectionFactory xmppConnectionFactory, ConfigurationContext configurationContext, Executor workerPool) {
        this.xmppConnectionFactory = xmppConnectionFactory;
        this.configurationContext = configurationContext;
        this.workerPool = workerPool;
    }

    public void processPacket(Packet packet) {
        log.info("Received : " + packet.toXML());
        if (packet instanceof Message) {
            this.workerPool.execute(new Worker(packet));
        }
    }

    private MessageContext createMessageContext(Packet packet) throws AxisFault {
        XMPPOutTransportInfo xmppOutTransportInfo;
        Message message = (Message)packet;
        Boolean isServerSide = (Boolean)message.getProperty("isServerSide");
        String serviceName = (String)message.getProperty("ServiceName");
        String action = (String)message.getProperty("Action");
        MessageContext msgContext = null;
        TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn("xmpp");
        TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut("xmpp");
        if (transportIn != null && transportOut != null) {
            String xmppMessageId;
            msgContext = this.configurationContext.createMessageContext();
            msgContext.setTransportIn(transportIn);
            msgContext.setTransportOut(transportOut);
            if (isServerSide != null) {
                msgContext.setServerSide(isServerSide);
            }
            msgContext.setProperty(CONTENT_TYPE, "text/xml");
            msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
            msgContext.setIncomingTransportName("xmpp");
            HashMap services = this.configurationContext.getAxisConfiguration().getServices();
            AxisService axisService = (AxisService)services.get(serviceName);
            msgContext.setAxisService(axisService);
            msgContext.setSoapAction(action);
            msgContext.setProperty("XMPPConfigurationFactory", this.xmppConnectionFactory);
            if (packet.getFrom() != null) {
                msgContext.setFrom(new EndpointReference(packet.getFrom()));
            }
            if (packet.getTo() != null) {
                msgContext.setTo(new EndpointReference(packet.getTo()));
            }
            xmppOutTransportInfo = new XMPPOutTransportInfo();
            xmppOutTransportInfo.setConnectionFactory(this.xmppConnectionFactory);
            String packetFrom = packet.getFrom();
            if (packetFrom != null) {
                EndpointReference fromEPR = new EndpointReference(packetFrom);
                xmppOutTransportInfo.setFrom(fromEPR);
                xmppOutTransportInfo.setDestinationAccount(packetFrom);
            }
            if ((xmppMessageId = packet.getPacketID()) != null) {
                xmppOutTransportInfo.setInReplyTo(xmppMessageId);
            }
        } else {
            throw new AxisFault("Either transport in or transport out is null");
        }
        msgContext.setProperty("OutTransportInfo", xmppOutTransportInfo);
        this.buildSOAPEnvelope(packet, msgContext);
        return msgContext;
    }

    private void buildSOAPEnvelope(Packet packet, MessageContext msgContext) throws AxisFault {
        Message message = (Message)packet;
        String xml = StringEscapeUtils.unescapeXml((String)message.getBody());
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        try {
            SOAPEnvelope envelope = TransportUtils.createSOAPMessage(msgContext, inputStream, "text/xml");
            if (msgContext.isServerSide()) {
                log.info("Received Envelope : " + xml);
            }
            msgContext.setEnvelope(envelope);
        }
        catch (OMException e) {
            log.error("Error occured while trying to create message content using XMPP message received :" + packet.toXML(), e);
            throw new AxisFault("Error occured while trying to create message content using XMPP message received :" + packet.toXML());
        }
        catch (XMLStreamException e) {
            log.error("Error occured while trying to create message content using XMPP message received :" + packet.toXML(), e);
            throw new AxisFault("Error occured while trying to create message content using XMPP message received :" + packet.toXML());
        }
        catch (FactoryConfigurationError e) {
            log.error("Error occured while trying to create message content using XMPP message received :" + packet.toXML(), e);
            throw new AxisFault("Error occured while trying to create message content using XMPP message received :" + packet.toXML());
        }
        catch (AxisFault e) {
            log.error("Error occured while trying to create message content using XMPP message received :" + packet.toXML(), e);
            throw new AxisFault("Error occured while trying to create message content using XMPP message received :" + packet.toXML());
        }
    }

    class Worker
    implements Runnable {
        private Packet packet = null;

        Worker(Packet packet) {
            this.packet = packet;
        }

        public void run() {
            block6: {
                MessageContext msgCtx = null;
                try {
                    msgCtx = XMPPPacketListener.this.createMessageContext(this.packet);
                    if (msgCtx.isProcessingFault() && msgCtx.isServerSide()) {
                        AxisEngine.sendFault(msgCtx);
                    } else {
                        AxisEngine.receive(msgCtx);
                    }
                }
                catch (AxisFault e) {
                    log.error("Error occurred while sending message" + e);
                    if (msgCtx == null || !msgCtx.isServerSide()) break block6;
                    try {
                        MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgCtx, e);
                        AxisEngine.sendFault(faultContext);
                    }
                    catch (AxisFault e1) {
                        log.error("Error occurred while creating SOAPFault message" + e1);
                    }
                }
            }
        }
    }
}

