/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.xmpp.util;

import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.xmpp.util.XMPPPacketListener;
import org.apache.axis2.transport.xmpp.util.XMPPServerCredentials;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;

public class XMPPConnectionFactory {
    private static Log log = LogFactory.getLog(XMPPConnectionFactory.class);
    private XMPPConnection xmppConnection = null;
    private PacketFilter packetFilter = null;
    private HashMap xmppConnections = new HashMap();

    public void connect(final XMPPServerCredentials serverCredentials) throws AxisFault {
        if ("transport.xmpp.ServerType.Jabber".equals(serverCredentials.getServerType())) {
            ConnectionListener connectionListener = null;
            try {
                this.xmppConnection = new XMPPConnection(serverCredentials.getServerUrl());
                this.xmppConnection.connect();
                connectionListener = new ConnectionListener(){

                    public void connectionClosed() {
                        log.debug("Connection closed normally");
                    }

                    public void connectionClosedOnError(Exception e1) {
                        log.debug("Connection to " + serverCredentials.getServerUrl() + " closed with error.", e1);
                        log.debug("Retrying to connect in 2 secs");
                        try {
                            Thread.sleep(2000L);
                            XMPPConnectionFactory.this.xmppConnection = new XMPPConnection(serverCredentials.getServerUrl());
                            log.debug("connected to " + serverCredentials.getServerUrl());
                        }
                        catch (InterruptedException e2) {
                            log.debug("Sleep interrupted.", e2);
                        }
                    }

                    public void reconnectingIn(int seconds) {
                    }

                    public void reconnectionFailed(Exception e) {
                    }

                    public void reconnectionSuccessful() {
                    }
                };
                this.xmppConnection.addConnectionListener(connectionListener);
            }
            catch (XMPPException e) {
                log.error("Failed to connect to server :" + serverCredentials.getServerUrl(), e);
                throw new AxisFault("Failed to connect to server :" + serverCredentials.getServerUrl());
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e5) {
                log.debug("Sleep interrupted ", e5);
            }
            if (this.xmppConnection.isConnected() && !this.xmppConnection.isAuthenticated()) {
                try {
                    this.xmppConnection.login(serverCredentials.getAccountName() + "@" + serverCredentials.getServerUrl(), serverCredentials.getPassword(), serverCredentials.getResource(), true);
                }
                catch (XMPPException e) {
                    try {
                        log.error("Login failed for " + serverCredentials.getAccountName() + "@" + serverCredentials.getServerUrl() + ".Retrying in 2 secs", e);
                        Thread.sleep(2000L);
                        this.xmppConnection.login(serverCredentials.getAccountName() + "@" + serverCredentials.getServerUrl(), serverCredentials.getPassword(), serverCredentials.getResource(), true);
                    }
                    catch (InterruptedException e1) {
                        log.error("Sleep interrupted.", e1);
                    }
                    catch (XMPPException e2) {
                        log.error("Login failed for : " + serverCredentials.getAccountName() + "@" + serverCredentials.getServerUrl(), e2);
                        throw new AxisFault("Login failed for : " + serverCredentials.getAccountName() + "@" + serverCredentials.getServerUrl());
                    }
                }
                this.packetFilter = new FromContainsFilter(serverCredentials.getServerUrl());
            }
        } else if ("transport.xmpp.ServerType.GoogleTalk".equals(serverCredentials.getServerType())) {
            try {
                ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration("talk.google.com", 5222, "gmail.com");
                this.xmppConnection = new XMPPConnection(connectionConfiguration);
                this.xmppConnection.connect();
                this.xmppConnection.login(serverCredentials.getAccountName(), serverCredentials.getPassword(), serverCredentials.getResource(), true);
                this.packetFilter = new ToContainsFilter("@gmail.com");
            }
            catch (XMPPException e1) {
                log.error("Error occured while connecting to Googletalk server.", e1);
                throw new AxisFault("Error occured while connecting to Googletalk server.");
            }
        }
    }

    public XMPPConnection getConnection(String connectionIdentifier) {
        return (XMPPConnection)this.xmppConnections.get(connectionIdentifier);
    }

    public XMPPConnection getXmppConnection() {
        return this.xmppConnection;
    }

    public void setXmppConnection(XMPPConnection xmppConnection) {
        this.xmppConnection = xmppConnection;
    }

    public void listen(XMPPPacketListener packetListener) {
        this.xmppConnection.addPacketListener((PacketListener)packetListener, this.packetFilter);
    }

    public void stop() {
    }
}

