/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.receivers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.classloader.MultiParentClassLoader;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.Replicator;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMessageReceiver
implements MessageReceiver {
    protected static final Log log = LogFactory.getLog(AbstractMessageReceiver.class);
    public static final String SCOPE = "scope";
    protected String serviceTCCL = null;
    public static final String SAVED_TCCL = "_SAVED_TCCL_";
    public static final String SAVED_MC = "_SAVED_MC_";
    public static final String DO_ASYNC = "messageReceiver.invokeOnSeparateThread";

    protected void replicateState(MessageContext messageContext) throws ClusteringFault {
        Replicator.replicate(messageContext);
    }

    protected abstract void invokeBusinessLogic(MessageContext var1) throws AxisFault;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(MessageContext messageCtx) throws AxisFault {
        if (messageCtx.isPropertyTrue(DO_ASYNC) || JavaUtils.isTrue(messageCtx.getParameter(DO_ASYNC))) {
            String mep = messageCtx.getAxisOperation().getMessageExchangePattern();
            EndpointReference replyTo = messageCtx.getReplyTo();
            if (!WSDLUtil.isOutputPresentForMEP(mep) || replyTo != null && !replyTo.hasAnonymousAddress()) {
                AsyncMessageReceiverWorker worker = new AsyncMessageReceiverWorker(messageCtx);
                messageCtx.getEnvelope().build();
                messageCtx.getConfigurationContext().getThreadPool().execute(worker);
                return;
            }
        }
        ThreadContextDescriptor tc = this.setThreadContext(messageCtx);
        try {
            try {
                this.invokeBusinessLogic(messageCtx);
            }
            catch (AxisFault fault) {
                if (!(messageCtx.getAxisOperation() instanceof InOnlyAxisOperation) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(messageCtx.getAxisOperation().getMessageExchangePattern())) {
                    fault.setFaultType(1);
                    throw fault;
                }
                log.error(fault);
                Object var6_7 = null;
                this.restoreThreadContext(tc);
            }
            Object var6_6 = null;
            this.restoreThreadContext(tc);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.restoreThreadContext(tc);
            throw throwable;
        }
    }

    protected ThreadContextDescriptor setThreadContext(final MessageContext msgContext) {
        ClassLoader contextClassLoader;
        ThreadContextDescriptor tc = new ThreadContextDescriptor();
        tc.oldMessageContext = (MessageContext)MessageContext.currentMessageContext.get();
        tc.oldClassLoader = contextClassLoader = this.getContextClassLoader_doPriv();
        AxisService service = msgContext.getAxisService();
        String serviceTCCL = (String)service.getParameterValue("ServiceTCCL");
        if (serviceTCCL != null) {
            if ((serviceTCCL = serviceTCCL.trim().toLowerCase()).equals("composite")) {
                final ClassLoader loader = (ClassLoader)java.security.AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new MultiParentClassLoader(new URL[0], new ClassLoader[]{msgContext.getAxisService().getClassLoader(), contextClassLoader});
                    }
                });
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(loader);
                        return null;
                    }
                });
            } else if (serviceTCCL.equals("service")) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(msgContext.getAxisService().getClassLoader());
                        return null;
                    }
                });
            }
        }
        MessageContext.setCurrentMessageContext(msgContext);
        return tc;
    }

    private ClassLoader getContextClassLoader_doPriv() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    protected void restoreThreadContext(final ThreadContextDescriptor tc) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(tc.oldClassLoader);
                return null;
            }
        });
        MessageContext.currentMessageContext.set(tc.oldMessageContext);
    }

    protected Object makeNewServiceObject(MessageContext msgContext) throws AxisFault {
        try {
            Parameter serviceObjectParam;
            Class serviceObjectMaker;
            Method method;
            final AxisService service = msgContext.getAxisService();
            ClassLoader classLoader = service.getClassLoader();
            if (service.getParameter("ServiceObjectSupplier") != null && (method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(serviceObjectMaker = Loader.loadClass(classLoader, ((String)(serviceObjectParam = service.getParameter("ServiceObjectSupplier")).getValue()).trim())){
                final /* synthetic */ Class val$serviceObjectMaker;
                {
                    this.val$serviceObjectMaker = clazz;
                }

                public Object run() throws NoSuchMethodException {
                    return this.val$serviceObjectMaker.getMethod("getServiceObject", AxisService.class);
                }
            })) != null) {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws InvocationTargetException, IllegalAccessException, InstantiationException {
                        return method.invoke(serviceObjectMaker.newInstance(), service);
                    }
                });
            }
            Parameter implInfoParam = service.getParameter("ServiceClass");
            if (implInfoParam != null) {
                final Class implClass = Loader.loadClass(classLoader, ((String)implInfoParam.getValue()).trim());
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws InstantiationException, IllegalAccessException {
                        return implClass.newInstance();
                    }
                });
            }
            throw new AxisFault(Messages.getMessage("paramIsNotSpecified", "SERVICE_OBJECT_SUPPLIER"));
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    public SOAPFactory getSOAPFactory(MessageContext msgContext) throws AxisFault {
        String nsURI = msgContext.getEnvelope().getNamespace().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage("invalidSOAPversion"));
    }

    protected Object getTheImplementationObject(MessageContext msgContext) throws AxisFault {
        ServiceContext serviceContext = msgContext.getServiceContext();
        Object serviceimpl = serviceContext.getProperty("serviceObject");
        if (serviceimpl != null) {
            return serviceimpl;
        }
        serviceimpl = this.makeNewServiceObject(msgContext);
        DependencyManager.initServiceObject(serviceimpl, msgContext.getServiceContext());
        serviceContext.setProperty("serviceObject", serviceimpl);
        return serviceimpl;
    }

    public class AsyncMessageReceiverWorker
    implements Runnable {
        private MessageContext messageCtx;

        public AsyncMessageReceiverWorker(MessageContext messageCtx) {
            this.messageCtx = messageCtx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ThreadContextDescriptor tc = AbstractMessageReceiver.this.setThreadContext(this.messageCtx);
                try {
                    AbstractMessageReceiver.this.invokeBusinessLogic(this.messageCtx);
                    Object var3_3 = null;
                    AbstractMessageReceiver.this.restoreThreadContext(tc);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    AbstractMessageReceiver.this.restoreThreadContext(tc);
                    throw throwable;
                }
            }
            catch (AxisFault e) {
                if (this.messageCtx.getAxisOperation() instanceof InOnlyAxisOperation) {
                    log.debug(e.getMessage(), e);
                }
                try {
                    MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(this.messageCtx, e);
                    AxisEngine.sendFault(faultContext);
                }
                catch (AxisFault axisFault) {
                    log.error(e.getMessage(), e);
                }
                log.error(e.getMessage(), e);
            }
        }
    }

    public static class ThreadContextDescriptor {
        public ClassLoader oldClassLoader;
        public MessageContext oldMessageContext;
    }
}

