/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.utility;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaUtils
extends org.apache.axis2.util.JavaUtils {
    private static Log log = LogFactory.getLog(JavaUtils.class);

    private JavaUtils() {
    }

    public static String getPackageFromNamespace(String namespace) {
        String word;
        int i;
        String last;
        String lastWord;
        int index;
        String[] words;
        if (log.isDebugEnabled()) {
            log.debug("namespace (" + namespace + ")");
        }
        String hostname = null;
        String path = null;
        try {
            URL url = new URL(namespace);
            hostname = url.getHost();
            path = url.getPath();
        }
        catch (MalformedURLException e) {
            hostname = namespace.indexOf(":") > -1 ? namespace.substring(namespace.indexOf(":") + 1) : namespace;
        }
        if (log.isDebugEnabled()) {
            log.debug("hostname (" + hostname + ")");
            log.debug("path (" + path + ")");
        }
        StringTokenizer st = new StringTokenizer(hostname, ":/");
        ArrayList<String> wordList = new ArrayList<String>();
        for (int i2 = 0; st != null && i2 < st.countTokens(); ++i2) {
            wordList.add(st.nextToken());
        }
        if (path != null) {
            StringTokenizer pathst = new StringTokenizer(path, "/");
            while (pathst != null && pathst.hasMoreTokens()) {
                wordList.add(pathst.nextToken());
            }
        }
        if ((words = wordList.toArray(new String[0])) != null && words.length > 1 && (index = (lastWord = words[words.length - 1]).lastIndexOf(46)) > 0) {
            words[words.length - 1] = lastWord.substring(0, index);
        }
        if (namespace.startsWith("urn:")) {
            words[0] = JavaUtils.replace(words[0], "-", ".");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (words.length > 0) {
            StringTokenizer st2 = new StringTokenizer(words[0], ".");
            while (st2.hasMoreTokens()) {
                list.add(0, st2.nextToken());
            }
        }
        if (list.size() > 0 && (last = (String)list.get(list.size() - 1)).equals("www")) {
            list.remove(list.size() - 1);
        }
        for (i = 1; i < words.length; ++i) {
            list.add(words[i]);
        }
        for (i = 0; i < list.size(); ++i) {
            word = (String)list.remove(i);
            word = word.toLowerCase();
            list.add(i, word);
        }
        for (i = 0; i < list.size(); ++i) {
            word = (String)list.get(i);
            if (JavaUtils.isJavaKeyword(word = JavaUtils.replace(word, "-", "_"))) {
                word = word + "_";
            }
            if (!Character.isJavaIdentifierStart(word.charAt(0))) {
                word = "_" + word;
            }
            list.set(i, word);
        }
        String name = "";
        for (int i3 = 0; i3 < list.size(); ++i3) {
            name = i3 == 0 ? (String)list.get(0) : name + "." + (String)list.get(i3);
        }
        if (log.isDebugEnabled()) {
            log.debug("package name (" + name + ")");
        }
        return name;
    }

    public static String stackToString() {
        return JavaUtils.stackToString(new RuntimeException());
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        text = text.substring(text.indexOf("at"));
        text = JavaUtils.replace(text, "at ", "DEBUG_FRAME = ");
        return text;
    }

    public static Class getCheckedException(Throwable throwable, Method method) {
        if (method == null) {
            return null;
        }
        Class<?>[] exceptions = method.getExceptionTypes();
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                if (!exceptions[i].isAssignableFrom(throwable.getClass())) continue;
                return exceptions[i];
            }
        }
        return null;
    }
}

