/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedAction;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.util.CatalogWSDLLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.xml.resolver.Catalog;
import org.xml.sax.InputSource;

public class CatalogURIResolver
implements URIResolver {
    private static Log log = LogFactory.getLog(CatalogWSDLLocator.class);
    private Catalog catalogResolver;

    public CatalogURIResolver(JAXWSCatalogManager catalogManager) {
        this.catalogResolver = catalogManager.getCatalog();
    }

    public String getRedirectedURI(String importURI, String parent) {
        String resolvedImportLocation = null;
        try {
            resolvedImportLocation = this.catalogResolver.resolveSystem(importURI);
            if (resolvedImportLocation == null) {
                resolvedImportLocation = this.catalogResolver.resolveURI(importURI);
            }
            if (resolvedImportLocation == null) {
                resolvedImportLocation = this.catalogResolver.resolvePublic(importURI, parent);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Catalog resolution failed", e);
        }
        return resolvedImportLocation;
    }

    public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
        if (baseUri != null) {
            String redirectedURI = this.getRedirectedURI(namespace, baseUri);
            if (redirectedURI != null) {
                schemaLocation = redirectedURI;
            }
            try {
                File baseFile = new File(baseUri);
                if (this.fileExists(baseFile).booleanValue()) {
                    baseUri = baseFile.toURI().toString();
                }
                String ref = new URI(baseUri).resolve(new URI(schemaLocation)).toString();
                return new InputSource(ref);
            }
            catch (URISyntaxException e1) {
                throw new RuntimeException(e1);
            }
        }
        return new InputSource(schemaLocation);
    }

    protected boolean isAbsolute(String uri) {
        return uri.startsWith("http://");
    }

    protected URL getURL(URL contextURL, String spec) throws IOException {
        URL url;
        String path = spec.replace('\\', '/');
        try {
            url = new URL(contextURL, path);
            if (contextURL != null && url.getProtocol().equals("file") && contextURL.getProtocol().equals("file")) {
                url = this.getFileURL(contextURL, path);
            }
        }
        catch (MalformedURLException me) {
            url = this.getFileURL(contextURL, path);
        }
        return url;
    }

    protected URL getFileURL(URL contextURL, String path) throws IOException {
        if (contextURL != null) {
            String contextFileName = contextURL.getFile();
            URL parent = null;
            File contextFile = new File(contextFileName);
            File parentFile = contextFile.isDirectory() ? contextFile : contextFile.getParentFile();
            if (parentFile != null) {
                parent = parentFile.toURL();
            }
            if (parent != null) {
                return new URL(parent, path);
            }
        }
        return new URL("file", "", path);
    }

    private Boolean fileExists(final File file) {
        Boolean exists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
        return exists;
    }

    private Boolean fileIsDirectory(final File file) {
        Boolean isDir = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.isDirectory());
            }
        });
        return isDir;
    }
}

