/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.dispatcher;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.WebServiceExceptionLogger;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.server.EndpointCallback;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.InvocationHelper;
import org.apache.axis2.jaxws.server.InvocationListener;
import org.apache.axis2.jaxws.server.InvocationListenerBean;
import org.apache.axis2.jaxws.server.dispatcher.EndpointDispatcher;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JavaDispatcher
implements EndpointDispatcher {
    private static final Log log = LogFactory.getLog(JavaDispatcher.class);
    protected Class serviceImplClass;
    protected Object serviceInstance;

    protected JavaDispatcher(Class impl, Object serviceInstance) {
        this.serviceImplClass = impl;
        this.serviceInstance = serviceInstance;
    }

    public abstract MessageContext invoke(MessageContext var1) throws Exception;

    public abstract void invokeOneWay(MessageContext var1);

    public abstract void invokeAsync(MessageContext var1, EndpointCallback var2);

    protected abstract MessageContext createResponse(MessageContext var1, Object[] var2, Object var3);

    protected abstract MessageContext createFaultResponse(MessageContext var1, Throwable var2);

    public Class getServiceImplementationClass() {
        return this.serviceImplClass;
    }

    protected Object invokeTargetOperation(Method method, Object[] args) throws Throwable {
        Object output = null;
        try {
            output = method.invoke(this.serviceInstance, args);
        }
        catch (Throwable t) {
            WebServiceExceptionLogger.log(method, t, false, this.serviceImplClass, this.serviceInstance, args);
            throw t;
        }
        return output;
    }

    protected void responseReady(EndpointInvocationContext eic) {
        List<InvocationListener> listenerList = eic.getInvocationListeners();
        if (listenerList != null) {
            InvocationListenerBean bean = new InvocationListenerBean(eic, InvocationListenerBean.State.RESPONSE);
            for (InvocationListener listener : listenerList) {
                try {
                    listener.notify(bean);
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
            }
        }
    }

    protected static void setFaultResponseAction(Throwable exception, MessageContext request, MessageContext response) {
        String action;
        AxisOperation operation = request.getOperationDescription().getAxisOperation();
        if (operation != null && (action = operation.getFaultAction((exception = ClassUtils.getRootCause(exception)).getClass().getName())) != null) {
            response.getAxisMessageContext().setWSAAction(action);
        }
    }

    protected static void setCheckedExceptionProperty(MessageContext response, Method m, Throwable t) {
        Class checkedException;
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        if ((checkedException = JavaUtils.getCheckedException(t, m)) != null) {
            response.setProperty("org.apache.axis2.jaxws.checkedException", checkedException.getCanonicalName());
        }
    }

    protected class AsyncInvocationWorker
    implements Callable {
        private Method method;
        private Object[] params;
        private ClassLoader classLoader;
        private EndpointInvocationContext eic;

        public AsyncInvocationWorker(Method m, Object[] p, ClassLoader cl, EndpointInvocationContext ctx) {
            this.method = m;
            this.params = p;
            this.classLoader = cl;
            this.eic = ctx;
        }

        public Object call() throws Exception {
            block18: {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Invoking target endpoint via the async worker.");
                    }
                    ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
                    if (this.classLoader != null && this.classLoader != currentLoader) {
                        Thread.currentThread().setContextClassLoader(this.classLoader);
                        if (log.isDebugEnabled()) {
                            log.debug("Context ClassLoader set to:" + this.classLoader);
                        }
                    }
                    Object output = null;
                    boolean faultThrown = false;
                    Throwable fault = null;
                    try {
                        output = JavaDispatcher.this.invokeTargetOperation(this.method, this.params);
                    }
                    catch (Exception e) {
                        fault = ClassUtils.getRootCause(e);
                        Throwable newFault = InvocationHelper.determineMappedException(fault, this.eic);
                        if (newFault != null) {
                            fault = newFault;
                        }
                        faultThrown = true;
                    }
                    if (this.eic.isOneWay()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Invocation pattern was one way, work complete.");
                        }
                        JavaDispatcher.this.responseReady(this.eic);
                        return null;
                    }
                    MessageContext request = this.eic.getRequestMessageContext();
                    MessageContext response = null;
                    if (faultThrown) {
                        response = JavaDispatcher.this.createFaultResponse(request, fault);
                        JavaDispatcher.setCheckedExceptionProperty(response, this.method, fault);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Async invocation of the endpoint was successful.  Creating response message.");
                        }
                        response = JavaDispatcher.this.createResponse(request, this.params, output);
                    }
                    EndpointInvocationContext eic = null;
                    if (request.getInvocationContext() != null) {
                        eic = (EndpointInvocationContext)request.getInvocationContext();
                        eic.setResponseMessageContext(response);
                    }
                    EndpointCallback callback = eic.getCallback();
                    boolean handleFault = response.getMessage().isFault();
                    if (!handleFault) {
                        if (log.isDebugEnabled()) {
                            log.debug("No fault detected in response message, sending back application response.");
                        }
                        callback.handleResponse(eic);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("A fault was detected.  Sending back a fault response.");
                        }
                        callback.handleFaultResponse(eic);
                    }
                    Thread.currentThread().setContextClassLoader(currentLoader);
                    TransportUtils.deleteAttachments(eic.getRequestMessageContext().getAxisMessageContext());
                    TransportUtils.deleteAttachments(eic.getResponseMessageContext().getAxisMessageContext());
                }
                catch (Throwable e) {
                    if (!log.isDebugEnabled()) break block18;
                    log.debug("AN UNEXPECTED ERROR OCCURRED IN THE ASYNC WORKER THREAD");
                    log.debug("Exception is:" + e, e);
                }
            }
            return null;
        }
    }
}

