/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.validator;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointDescriptionWSDL;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.validator.EndpointInterfaceDescriptionValidator;
import org.apache.axis2.jaxws.description.validator.Validator;
import org.apache.axis2.jaxws.i18n.Messages;

public class EndpointDescriptionValidator
extends Validator {
    EndpointDescription endpointDesc;
    EndpointDescriptionJava endpointDescJava;
    EndpointDescriptionWSDL endpointDescWSDL;

    public EndpointDescriptionValidator(EndpointDescription toValidate) {
        this.endpointDesc = toValidate;
        this.endpointDescJava = (EndpointDescriptionJava)((Object)this.endpointDesc);
        this.endpointDescWSDL = (EndpointDescriptionWSDL)((Object)this.endpointDesc);
    }

    public boolean validate() {
        if (this.getValidationLevel() == Validator.ValidationLevel.OFF) {
            return true;
        }
        if (this.endpointDesc.getServiceDescription().isServerSide()) {
            if (!this.validateWSDLPort()) {
                return false;
            }
            if (!this.validateWSDLBindingType()) {
                return false;
            }
            if (!this.validateRespectBinding()) {
                return false;
            }
        }
        return this.validateEndpointInterface();
    }

    private boolean validateWSDLBindingType() {
        boolean isBindingValid = false;
        String bindingType = this.endpointDesc.getBindingType();
        String wsdlBindingType = this.endpointDescWSDL.getWSDLBindingType();
        if (bindingType == null) {
            this.addValidationFailure(this, "Annotation binding type is null and did not have a default");
            isBindingValid = false;
        } else if (!("http://schemas.xmlsoap.org/wsdl/soap/http".equals(bindingType) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(bindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(bindingType) || "http://www.example.org/2006/06/soap/bindings/JMS/".equals(bindingType) || "http://http://www.example.org/2006/06/soap/bindings/JMS/?mtom=true".equals(bindingType) || "http://www.example.org/2006/06/soap/bindings/JMS/".equals(bindingType) || "http://http://www.example.org/2006/06/soap/bindings/JMS/?mtom=true".equals(bindingType) || "http://www.w3.org/2004/08/wsdl/http".equals(bindingType))) {
            this.addValidationFailure(this, "Invalid annotation binding value specified: " + bindingType);
            isBindingValid = false;
        } else if (wsdlBindingType == null) {
            isBindingValid = true;
        } else if (!("http://schemas.xmlsoap.org/wsdl/soap/http".equals(wsdlBindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(wsdlBindingType) || "http://www.w3.org/2004/08/wsdl/http".equals(wsdlBindingType))) {
            this.addValidationFailure(this, "Invalid wsdl binding value specified: " + DescriptionUtils.mapBindingTypeAnnotationToWsdl(wsdlBindingType));
            isBindingValid = false;
        } else if (wsdlBindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") && (bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true"))) {
            isBindingValid = true;
        } else if (wsdlBindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") && (bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true"))) {
            isBindingValid = true;
        } else if (wsdlBindingType.equals("http://www.w3.org/2004/08/wsdl/http") && bindingType.equals("http://www.w3.org/2004/08/wsdl/http")) {
            isBindingValid = true;
        } else if (wsdlBindingType.equals("http://www.w3.org/2004/08/wsdl/http") && this.endpointDesc.isEndpointBased()) {
            this.addValidationFailure(this, "An HTTPBinding was found on an @WebService SEI based endpoint. This is not supported.  An HTTPBinding must use an @WebServiceProvider endpoint.");
            isBindingValid = false;
        } else {
            String wsdlInsert = "[" + EndpointDescriptionValidator.bindingHumanReadableDescription(wsdlBindingType) + "]" + "namespace = {" + DescriptionUtils.mapBindingTypeAnnotationToWsdl(wsdlBindingType) + "}";
            String annotationInsert = "[" + EndpointDescriptionValidator.bindingHumanReadableDescription(bindingType) + "]" + "namespace = {" + bindingType + "}";
            String message = Messages.getMessage("endpointDescriptionValidation", wsdlInsert, annotationInsert);
            this.addValidationFailure(this, message);
            isBindingValid = false;
        }
        return isBindingValid;
    }

    private boolean validateWSDLPort() {
        Port wsdlPort;
        Service wsdlService = this.endpointDescWSDL.getWSDLService();
        if (wsdlService != null && (wsdlPort = this.endpointDescWSDL.getWSDLPort()) == null) {
            this.addValidationFailure(this, "Serivce exists in WSDL, but Port does not.  Not a valid Partial WSDL.  Service: " + this.endpointDesc.getServiceQName() + "; Port: " + this.endpointDesc.getPortQName());
            return false;
        }
        return true;
    }

    private boolean validateEndpointInterface() {
        EndpointInterfaceDescriptionValidator eidValidator;
        boolean isEndpointInterfaceValid;
        EndpointInterfaceDescription eid = this.endpointDesc.getEndpointInterfaceDescription();
        if (eid != null && !(isEndpointInterfaceValid = (eidValidator = new EndpointInterfaceDescriptionValidator(eid)).validate())) {
            this.addValidationFailure(eidValidator, "Invalid Endpoint Interface");
            return false;
        }
        return true;
    }

    private boolean validateRespectBinding() {
        if (this.endpointDesc.respectBinding()) {
            String wsdlLocation = null;
            wsdlLocation = !this.endpointDesc.isProviderBased() ? this.endpointDescJava.getAnnoWebServiceWSDLLocation() : this.endpointDescJava.getAnnoWebServiceProvider().wsdlLocation();
            if (wsdlLocation == null || wsdlLocation.length() == 0) {
                this.addValidationFailure(this, "Annotation @RespectBinding requires that a WSDL file be specified.");
                return false;
            }
            List required = this.endpointDesc.getRequiredBindings();
            if (required.size() > 0) {
                for (QName name : required) {
                    String featureName = EndpointDescriptionValidator.getFeatureForBinding(name);
                    if (featureName != null && featureName.length() > 0) {
                        EndpointDescriptionJava edj = (EndpointDescriptionJava)((Object)this.endpointDesc);
                        Annotation anno = edj.getAnnoFeature(featureName);
                        WebServiceFeatureAnnotation feature = this.getFeatureFromAnnotation(anno);
                        if (feature != null) continue;
                        this.addValidationFailure(this, "Annotation @RespectBinding was enabled, but the corresponding feature " + featureName + " was not enabled.");
                        return false;
                    }
                    this.addValidationFailure(this, "Annotation @RespectBinding was enabled, but extensibility element " + name + " was not recognized.");
                    return false;
                }
            }
        }
        return true;
    }

    private WebServiceFeatureAnnotation getFeatureFromAnnotation(Annotation a) {
        return a.annotationType().getAnnotation(WebServiceFeatureAnnotation.class);
    }

    private static String bindingHumanReadableDescription(String ns) {
        if ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(ns)) {
            return "SOAP 1.1 HTTP Binding";
        }
        if ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(ns)) {
            return "SOAP 1.1 MTOM HTTP Binding";
        }
        if ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(ns)) {
            return "SOAP 1.2 HTTP Binding";
        }
        if ("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(ns)) {
            return "SOAP 1.2 MTOM HTTP Binding";
        }
        if ("http://www.example.org/2006/06/soap/bindings/JMS/".equals(ns)) {
            return "SOAP 1.1 JMS Binding";
        }
        if ("http://http://www.example.org/2006/06/soap/bindings/JMS/?mtom=true".equals(ns)) {
            return "SOAP 1.1 MTOM JMS Binding";
        }
        if ("http://www.example.org/2006/06/soap/bindings/JMS/".equals(ns)) {
            return "SOAP 1.2 JMS Binding";
        }
        if ("http://http://www.example.org/2006/06/soap/bindings/JMS/?mtom=true".equals(ns)) {
            return "SOAP 1.2 MTOM JMS Binding";
        }
        if ("http://www.w3.org/2004/08/wsdl/http".equals(ns)) {
            return "XML HTTP Binding";
        }
        return "Unknown Binding";
    }

    private static String getFeatureForBinding(QName name) {
        if (name.equals(new QName("http://www.w3.org/2006/05/addressing/wsdl", "UsingAddressing"))) {
            return "http://www.w3.org/2005/08/addressing/module";
        }
        return null;
    }
}

