/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.context.utils;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.jaxws.addressing.util.ReferenceParameterList;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextUtils {
    private static final Log log = LogFactory.getLog(ContextUtils.class);
    private static final String WEBSERVICE_MESSAGE_CONTEXT = "javax.xml.ws.WebServiceContext";

    public static void addProperties(SOAPMessageContext soapMessageContext, org.apache.axis2.jaxws.core.MessageContext jaxwsMessageContext) {
        HttpServletResponse res;
        ServletContext servletContext;
        ServiceDescription sd;
        soapMessageContext.putAll(jaxwsMessageContext.getProperties());
        EndpointDescription description = jaxwsMessageContext.getEndpointDescription();
        if (description != null && (sd = description.getServiceDescription()) != null) {
            String wsdlLocation = ((ServiceDescriptionWSDL)((Object)sd)).getWSDLLocation();
            if (wsdlLocation != null && !"".equals(wsdlLocation)) {
                URI wsdlLocationURI = null;
                try {
                    wsdlLocationURI = new URI(wsdlLocation);
                }
                catch (URISyntaxException ex) {
                    log.warn(Messages.getMessage("addPropertiesErr", wsdlLocation.toString(), description.getServiceQName().toString()), ex);
                }
                soapMessageContext.put((Object)"javax.xml.ws.wsdl.description", (Object)wsdlLocationURI);
                soapMessageContext.setScope("javax.xml.ws.wsdl.description", MessageContext.Scope.APPLICATION);
            }
            soapMessageContext.put((Object)"javax.xml.ws.wsdl.service", (Object)description.getServiceQName());
            soapMessageContext.setScope("javax.xml.ws.wsdl.service", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug("WSDL_SERVICE :" + description.getServiceQName());
            }
        }
        MessageContext msgContext = jaxwsMessageContext.getAxisMessageContext();
        SOAPHeader header = null;
        if (msgContext != null && msgContext.getEnvelope() != null) {
            header = msgContext.getEnvelope().getHeader();
        }
        ReferenceParameterList list = new ReferenceParameterList(header);
        soapMessageContext.put((Object)"javax.xml.ws.reference.parameters", (Object)list);
        soapMessageContext.setScope("javax.xml.ws.reference.parameters", MessageContext.Scope.APPLICATION);
        if (log.isDebugEnabled()) {
            log.debug("Added reference parameter list.");
        }
        if ((servletContext = (ServletContext)jaxwsMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT)) != null) {
            log.debug("Servlet Context Set");
            soapMessageContext.put((Object)"javax.xml.ws.servlet.context", (Object)servletContext);
            soapMessageContext.setScope("javax.xml.ws.servlet.context", MessageContext.Scope.APPLICATION);
        } else {
            log.debug("Servlet Context not found");
        }
        HttpServletRequest req = (HttpServletRequest)jaxwsMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (req == null && log.isDebugEnabled()) {
            log.debug("HTTPServletRequest not found");
        }
        if (req != null) {
            soapMessageContext.put((Object)"javax.xml.ws.servlet.request", (Object)req);
            soapMessageContext.setScope("javax.xml.ws.servlet.request", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug("SERVLET_REQUEST Set");
            }
            String pathInfo = null;
            try {
                pathInfo = req.getPathInfo();
            }
            catch (Throwable t) {
                log.debug("exception in getPathInfo", t);
            }
            soapMessageContext.put((Object)"javax.xml.ws.http.request.pathinfo", (Object)pathInfo);
            soapMessageContext.setScope("javax.xml.ws.http.request.pathinfo", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                if (pathInfo != null) {
                    log.debug("HTTP_REQUEST_PATHINFO Set");
                } else {
                    log.debug("HTTP_REQUEST_PATHINFO not found");
                }
            }
            String queryString = req.getQueryString();
            soapMessageContext.put((Object)"javax.xml.ws.http.request.querystring", (Object)queryString);
            soapMessageContext.setScope("javax.xml.ws.http.request.querystring", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                if (queryString != null) {
                    log.debug("HTTP_REQUEST_QUERYSTRING Set");
                } else {
                    log.debug("HTTP_REQUEST_QUERYSTRING not found");
                }
            }
            String method = req.getMethod();
            soapMessageContext.put((Object)"javax.xml.ws.http.request.method", (Object)method);
            soapMessageContext.setScope("javax.xml.ws.http.request.method", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                if (method != null) {
                    log.debug("HTTP_REQUEST_METHOD Set");
                } else {
                    log.debug("HTTP_REQUEST_METHOD not found");
                }
            }
        }
        if ((res = (HttpServletResponse)jaxwsMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE)) == null && log.isDebugEnabled()) {
            log.debug("Servlet Response not found");
        }
        if (res != null) {
            soapMessageContext.put((Object)"javax.xml.ws.servlet.response", (Object)res);
            soapMessageContext.setScope("javax.xml.ws.servlet.response", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug("SERVLET_RESPONSE Set");
            }
        }
    }

    public static void addWSDLProperties(org.apache.axis2.jaxws.core.MessageContext jaxwsMessageContext) {
        OperationDescription op;
        WebServiceContext wsc;
        MessageContext msgContext = jaxwsMessageContext.getAxisMessageContext();
        ServiceContext serviceContext = msgContext.getServiceContext();
        SOAPMessageContext soapMessageContext = null;
        if (serviceContext != null && (wsc = (WebServiceContext)serviceContext.getProperty(WEBSERVICE_MESSAGE_CONTEXT)) != null) {
            soapMessageContext = (SOAPMessageContext)wsc.getMessageContext();
        }
        if ((op = jaxwsMessageContext.getOperationDescription()) != null && soapMessageContext != null) {
            EndpointInterfaceDescription eid;
            soapMessageContext.put((Object)"javax.xml.ws.wsdl.operation", (Object)op.getName());
            soapMessageContext.setScope("javax.xml.ws.wsdl.operation", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug("WSDL_OPERATION :" + op.getName());
            }
            if ((eid = op.getEndpointInterfaceDescription()) != null) {
                EndpointDescription ed = eid.getEndpointDescription();
                QName portType = eid.getPortType();
                if ((portType == null || portType.getLocalPart() == "") && log.isDebugEnabled()) {
                    log.debug("Did not get port type from EndpointInterfaceDescription, attempting to get PortType from EndpointDescription");
                }
                if (ed != null) {
                    soapMessageContext.put((Object)"javax.xml.ws.wsdl.port", (Object)ed.getPortQName());
                    soapMessageContext.setScope("javax.xml.ws.wsdl.port", MessageContext.Scope.APPLICATION);
                    if (log.isDebugEnabled()) {
                        log.debug("WSDL_PORT :" + ed.getPortQName());
                    }
                }
                soapMessageContext.put((Object)"javax.xml.ws.wsdl.interface", (Object)portType);
                soapMessageContext.setScope("javax.xml.ws.wsdl.interface", MessageContext.Scope.APPLICATION);
                if (log.isDebugEnabled()) {
                    log.debug("WSDL_INTERFACE :" + portType);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Unable to read WSDL operation, port and interface properties");
        }
    }

    public static void addWSDLProperties_provider(org.apache.axis2.jaxws.core.MessageContext jaxwsMessageContext) {
        QName op;
        WebServiceContext wsc;
        MessageContext msgContext = jaxwsMessageContext.getAxisMessageContext();
        ServiceContext serviceContext = msgContext.getServiceContext();
        SOAPMessageContext soapMessageContext = null;
        if (serviceContext != null && (wsc = (WebServiceContext)serviceContext.getProperty(WEBSERVICE_MESSAGE_CONTEXT)) != null) {
            soapMessageContext = (SOAPMessageContext)wsc.getMessageContext();
        }
        if ((op = jaxwsMessageContext.getOperationName()) != null && soapMessageContext != null) {
            EndpointDescription ed;
            soapMessageContext.put((Object)"javax.xml.ws.wsdl.operation", (Object)op);
            soapMessageContext.setScope("javax.xml.ws.wsdl.operation", MessageContext.Scope.APPLICATION);
            if (log.isDebugEnabled()) {
                log.debug("WSDL_OPERATION :" + op);
            }
            if ((ed = jaxwsMessageContext.getEndpointDescription()) != null) {
                soapMessageContext.put((Object)"javax.xml.ws.wsdl.port", (Object)ed.getPortQName());
                soapMessageContext.setScope("javax.xml.ws.wsdl.port", MessageContext.Scope.APPLICATION);
                if (log.isDebugEnabled()) {
                    log.debug("WSDL_PORT :" + ed.getPortQName());
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Unable to read WSDL operation, port and interface properties");
        }
    }
}

