/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.feature.ClientConfigurator;
import org.apache.axis2.jaxws.feature.ClientFramework;
import org.apache.axis2.jaxws.handler.HandlerResolverImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.registry.ClientConfiguratorRegistry;
import org.apache.axis2.jaxws.spi.Binding;
import org.apache.axis2.jaxws.spi.BindingProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingImpl
implements Binding {
    private List<Handler> handlers;
    private EndpointDescription endpointDesc;
    private ClientFramework framework = new ClientFramework();
    protected String bindingId;
    protected Set<String> roles;
    protected static final String SOAP11_ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    protected static final String SOAP12_ENV_NS = "http://www.w3.org/2003/05/soap-envelope";

    public BindingImpl(EndpointDescription endpointDesc) {
        this.endpointDesc = endpointDesc;
        this.bindingId = endpointDesc.getClientBindingID();
        if (this.bindingId == null) {
            this.bindingId = endpointDesc.getBindingType();
        }
        Set<String> ids = ClientConfiguratorRegistry.getIds();
        for (String id : ids) {
            ClientConfigurator configurator = ClientConfiguratorRegistry.getConfigurator(id);
            if (!configurator.supports(this)) continue;
            this.framework.addConfigurator(id, configurator);
        }
    }

    public List<Handler> getHandlerChain() {
        if (this.handlers == null) {
            this.handlers = new HandlerResolverImpl(this.endpointDesc.getServiceDescription()).getHandlerChain(this.endpointDesc.getPortInfo());
        }
        return this.handlers;
    }

    public void setHandlerChain(List<Handler> list) {
        this.handlers = list == null ? new ArrayList<Handler>() : list;
    }

    public String getBindingID() {
        return this.bindingId;
    }

    @Override
    public void configure(MessageContext messageContext, BindingProvider provider) {
        this.framework.configure(messageContext, provider);
    }

    @Override
    public WebServiceFeature getFeature(String id) {
        return this.framework.getFeature(id);
    }

    @Override
    public void setFeatures(WebServiceFeature ... features) {
        if (features != null) {
            for (WebServiceFeature feature : features) {
                this.framework.addFeature(feature);
            }
        }
    }

    @Override
    public void setAddressingNamespace(String addressingNamespace) {
        if (addressingNamespace != null) {
            throw new UnsupportedOperationException(Messages.getMessage("bindingMethodNotSupported", "setAddressingNamespace", this.bindingId));
        }
    }

    @Override
    public void setAxis2EndpointReference(EndpointReference epr) {
        if (epr != null) {
            throw new UnsupportedOperationException(Messages.getMessage("bindingMethodNotSupported", "setAxis2EndpointReference", this.bindingId));
        }
    }

    @Override
    public String getAddressingNamespace() {
        throw new UnsupportedOperationException(Messages.getMessage("bindingMethodNotSupported", "getAddressingNamespace", this.bindingId));
    }

    @Override
    public EndpointReference getAxis2EndpointReference() {
        throw new UnsupportedOperationException(Messages.getMessage("bindingMethodNotSupported", "getAxis2EndpointReference", this.bindingId));
    }
}

