/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingValidationHandler
extends AbstractHandler
implements AddressingConstants {
    private static final Log log = LogFactory.getLog(AddressingValidationHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        Object flag = msgContext.getLocalProperty("IsAddressingProcessed");
        if (log.isTraceEnabled()) {
            log.trace("invoke: IS_ADDR_INFO_ALREADY_PROCESSED=" + flag);
        }
        if (JavaUtils.isTrueExplicitly(flag)) {
            this.checkMessageIDHeader(msgContext);
        } else {
            this.checkUsingAddressing(msgContext);
        }
        if (JavaUtils.isTrue(msgContext.getProperty("addressing.validateInvocationPattern"), true)) {
            this.checkWSAMInvocationPattern(msgContext);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void checkUsingAddressing(MessageContext msgContext) throws AxisFault {
        AxisDescription ad = msgContext.getAxisService();
        if (ad == null) {
            if (log.isTraceEnabled()) {
                log.trace("checkUsingAddressing: axisService null, cannot check UsingAddressing");
            }
            return;
        }
        if (msgContext.getAxisOperation() != null) {
            ad = msgContext.getAxisOperation();
        }
        String addressingFlag = AddressingHelper.getAddressingRequirementParemeterValue(ad);
        if (log.isTraceEnabled()) {
            log.trace("checkUsingAddressing: WSAddressingFlag=" + addressingFlag);
        }
        if ("required".equals(addressingFlag)) {
            AddressingFaultsHelper.triggerMessageAddressingRequiredFault(msgContext, "Action");
        }
    }

    private void checkWSAMInvocationPattern(MessageContext msgContext) throws AxisFault {
        String value = AddressingHelper.getInvocationPatternParameterValue(msgContext.getAxisOperation());
        if (log.isTraceEnabled()) {
            log.trace("checkWSAMInvocationPattern: value=" + value);
        }
        if (!"both".equals(value)) {
            if ("synchronous".equals(value)) {
                EndpointReference anonEPR;
                if (!AddressingHelper.isSyncReplyAllowed(msgContext)) {
                    anonEPR = new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous");
                    msgContext.setReplyTo(anonEPR);
                    msgContext.setFaultTo(anonEPR);
                    AddressingFaultsHelper.triggerOnlyAnonymousAddressSupportedFault(msgContext, "ReplyTo");
                }
                if (!AddressingHelper.isSyncFaultAllowed(msgContext)) {
                    anonEPR = new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous");
                    msgContext.setReplyTo(anonEPR);
                    msgContext.setFaultTo(anonEPR);
                    AddressingFaultsHelper.triggerOnlyAnonymousAddressSupportedFault(msgContext, "FaultTo");
                }
            } else if ("asynchronous".equals(value)) {
                if (!AddressingHelper.isReplyRedirected(msgContext)) {
                    AddressingFaultsHelper.triggerOnlyNonAnonymousAddressSupportedFault(msgContext, "ReplyTo");
                }
                if (!AddressingHelper.isFaultRedirected(msgContext)) {
                    AddressingFaultsHelper.triggerOnlyNonAnonymousAddressSupportedFault(msgContext, "FaultTo");
                }
            }
        }
    }

    private void checkMessageIDHeader(MessageContext msgContext) throws AxisFault {
        String messageId;
        String mep;
        int mepConstant;
        String namespace = (String)msgContext.getLocalProperty("WSAddressingVersion");
        if (!"http://www.w3.org/2005/08/addressing".equals(namespace)) {
            return;
        }
        AxisOperation axisOperation = msgContext.getAxisOperation();
        if (!(axisOperation == null || (mepConstant = Utils.getAxisSpecifMEPConstant(mep = axisOperation.getMessageExchangePattern())) != 12 && mepConstant != 13 && mepConstant != 11 || (messageId = msgContext.getOptions().getMessageId()) != null && !"".equals(messageId))) {
            AddressingFaultsHelper.triggerMessageAddressingRequiredFault(msgContext, "MessageID");
        }
    }
}

