/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingPreSecurityHandler
extends AbstractHandler
implements AddressingConstants {
    private static final Log log = LogFactory.getLog(AddressingPreSecurityHandler.class);
    public static final String UNVERIFIED_OPERATION_CONTEXT = "unverifiedOperationContext";
    public static final String UNVERIFIED_AXIS_SERVICE = "unverifiedService";
    public static final String UNVERIFIED_AXIS_OPERATION = "unverifiedOperation";

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        SOAPHeader header;
        SOAPEnvelope envelope;
        if (log.isTraceEnabled()) {
            log.trace("invoke :: Entry");
        }
        if ((envelope = msgContext.getEnvelope()) != null && (header = envelope.getHeader()) != null) {
            if (log.isTraceEnabled()) {
                log.trace("invoke - Found SOAPHeader");
            }
            OMElement relatesTo = null;
            Iterator iter = header.getChildElements();
            while (iter.hasNext() && relatesTo == null) {
                String namespace;
                OMElement next = (OMElement)iter.next();
                if (!"RelatesTo".equals(next.getLocalName()) || !"http://www.w3.org/2005/08/addressing".equals(namespace = next.getNamespace().getNamespaceURI()) && !"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace)) continue;
                relatesTo = next;
            }
            if (relatesTo != null) {
                OperationContext operationContext;
                if (log.isTraceEnabled()) {
                    log.trace("invoke - Found RelatesTo: " + relatesTo);
                }
                String relatesToString = relatesTo.getText();
                ConfigurationContext configurationContext = msgContext.getConfigurationContext();
                if (relatesToString != null && configurationContext != null && (operationContext = configurationContext.getOperationContext(relatesToString)) != null) {
                    if (log.isTraceEnabled()) {
                        log.trace("invoke - Found OperationContext: " + operationContext);
                    }
                    if ((msgContext.getAxisService() != null || msgContext.getAxisOperation() != null || msgContext.getOperationContext() != null) && log.isTraceEnabled()) {
                        log.trace("Unexpected partial dispatch detected before AddressingPreSecurityHandler.");
                    }
                    msgContext.setProperty("WSAddressingVersion", relatesTo.getNamespace().getNamespaceURI());
                    AxisOperation axisOperation = operationContext.getAxisOperation();
                    ServiceContext sc = operationContext.getServiceContext();
                    AxisService axisService = sc.getAxisService();
                    msgContext.setProperty(UNVERIFIED_OPERATION_CONTEXT, operationContext);
                    msgContext.setProperty(UNVERIFIED_AXIS_SERVICE, axisService);
                    msgContext.setProperty(UNVERIFIED_AXIS_OPERATION, axisOperation);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("invoke :: Exit");
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

