/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.externalize.SafeObjectInputStream;
import org.apache.axis2.context.externalize.SafeObjectOutputStream;
import org.apache.axis2.context.externalize.SafeSerializable;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParameterIncludeImpl
implements ParameterInclude,
Externalizable,
SafeSerializable {
    private static final Log log = LogFactory.getLog(ParameterIncludeImpl.class);
    private static boolean DEBUG_ENABLED = log.isDebugEnabled();
    private static boolean DEBUG_PROPERTY_SET = log.isDebugEnabled();
    private static final String myClassName = "ParameterIncludeImpl";
    private static final long serialVersionUID = 8153736719090126891L;
    private static final int REVISION_2 = 2;
    private static final int revisionID = 2;
    protected final HashMap parameters = new HashMap();

    public void addParameter(Parameter param) {
        if (param != null) {
            this.parameters.put(param.getName(), param);
            if (DEBUG_ENABLED) {
                this.debugParameterAdd(param);
            }
        }
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.parameters.remove(param.getName());
    }

    public void deserializeParameters(OMElement parameters) throws AxisFault {
        Iterator iterator = parameters.getChildrenWithName(new QName("parameter"));
        while (iterator.hasNext()) {
            OMElement parameterElement = (OMElement)iterator.next();
            Parameter parameter = new Parameter();
            parameter.setParameterElement(parameterElement);
            OMAttribute paraName = parameterElement.getAttribute(new QName("name"));
            parameter.setName(paraName.getAttributeValue());
            OMElement paraValue = parameterElement.getFirstElement();
            if (paraValue != null) {
                parameter.setValue(parameterElement);
                parameter.setParameterType(2);
            } else {
                String paratextValue = parameterElement.getText();
                parameter.setValue(paratextValue);
                parameter.setParameterType(1);
            }
            OMAttribute paraLocked = parameterElement.getAttribute(new QName("locked"));
            if (paraLocked != null) {
                String lockedValue = paraLocked.getAttributeValue();
                if ("true".equals(lockedValue)) {
                    parameter.setLocked(true);
                } else {
                    parameter.setLocked(false);
                }
            }
            this.addParameter(parameter);
        }
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.parameters.get(name);
    }

    public ArrayList getParameters() {
        Collection col = this.parameters.values();
        ArrayList<Parameter> para_list = new ArrayList<Parameter>();
        for (Parameter parameter : col) {
            para_list.add(parameter);
        }
        return para_list;
    }

    public boolean isParameterLocked(String parameterName) {
        return false;
    }

    public void writeExternal(ObjectOutput o) throws IOException {
        SafeObjectOutputStream out = SafeObjectOutputStream.install(o);
        out.writeLong(8153736719090126891L);
        out.writeInt(2);
        out.writeMap(this.parameters);
    }

    public void readExternal(ObjectInput inObject) throws IOException, ClassNotFoundException {
        SafeObjectInputStream in = SafeObjectInputStream.install(inObject);
        if (log.isTraceEnabled()) {
            log.trace("ParameterIncludeImpl:readExternal():  BEGIN  bytes available in stream [" + in.available() + "]  ");
        }
        long suid = in.readLong();
        int revID = in.readInt();
        if (suid != 8153736719090126891L) {
            throw new ClassNotFoundException("Serialization version ID is not supported.");
        }
        if (revID != 2) {
            throw new ClassNotFoundException("Revision ID is not supported.");
        }
        in.readMap(this.parameters);
    }

    private void debugParameterAdd(Parameter parameter) {
        if (DEBUG_PROPERTY_SET) {
            ClassLoader cl;
            String key = parameter.getName();
            Object value = parameter.getValue();
            String className = value == null ? "null" : value.getClass().getName();
            String classloader = "null";
            if (value != null && (cl = Utils.getObjectClassLoader(value)) != null) {
                classloader = cl.toString();
            }
            String valueText = value instanceof String ? value.toString() : null;
            String identity = this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this));
            log.debug("==================");
            log.debug(" Parameter add on object " + identity);
            log.debug("  Key =" + key);
            if (valueText != null) {
                log.debug("  Value =" + valueText);
            }
            log.debug("  Value Class = " + className);
            log.debug("  Value Classloader = " + classloader);
            log.debug("Call Stack = " + JavaUtils.callStackToString());
            log.debug("==================");
        }
    }
}

