/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.axis2.clustering.LoadBalanceEventHandler;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.control.wka.MemberJoinedCommand;
import org.apache.axis2.clustering.control.wka.MemberListCommand;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.Response;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.group.interceptors.StaticMembershipInterceptor;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MembershipManager {
    private static final Log log = LogFactory.getLog(MembershipManager.class);
    private RpcChannel rpcMembershipChannel;
    private StaticMembershipInterceptor staticMembershipInterceptor;
    private byte[] domain;
    private LoadBalanceEventHandler loadBalanceEventHandler;
    private ConfigurationContext configContext;
    private final List<org.apache.catalina.tribes.Member> members = new ArrayList<org.apache.catalina.tribes.Member>();
    private List<org.apache.catalina.tribes.Member> wkaMembers = new ArrayList<org.apache.catalina.tribes.Member>();
    private org.apache.catalina.tribes.Member localMember;

    public MembershipManager(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    public MembershipManager() {
    }

    public void setRpcMembershipChannel(RpcChannel rpcMembershipChannel) {
        this.rpcMembershipChannel = rpcMembershipChannel;
    }

    public RpcChannel getRpcMembershipChannel() {
        return this.rpcMembershipChannel;
    }

    public void setStaticMembershipInterceptor(StaticMembershipInterceptor staticMembershipInterceptor) {
        this.staticMembershipInterceptor = staticMembershipInterceptor;
    }

    public void setLoadBalanceEventHandler(LoadBalanceEventHandler loadBalanceEventHandler) {
        this.loadBalanceEventHandler = loadBalanceEventHandler;
    }

    public void setDomain(byte[] domain) {
        this.domain = domain;
    }

    public byte[] getDomain() {
        return this.domain;
    }

    public org.apache.catalina.tribes.Member getLocalMember() {
        return this.localMember;
    }

    public void setLocalMember(org.apache.catalina.tribes.Member localMember) {
        this.localMember = localMember;
    }

    public void addWellKnownMember(org.apache.catalina.tribes.Member wkaMember) {
        this.wkaMembers.add(wkaMember);
    }

    public void removeWellKnownMember(org.apache.catalina.tribes.Member wkaMember) {
        this.wkaMembers.remove(wkaMember);
    }

    public synchronized boolean memberAdded(org.apache.catalina.tribes.Member member) {
        boolean shouldAddMember;
        if (this.members.contains(member) || !TribesUtil.isInDomain(member, this.domain)) {
            return false;
        }
        if (this.staticMembershipInterceptor != null) {
            this.staticMembershipInterceptor.addStaticMember(member);
            if (log.isDebugEnabled()) {
                log.debug("Added static member " + TribesUtil.getName(member));
            }
        }
        boolean bl = shouldAddMember = this.localMember == null || TribesUtil.areInSameDomain(this.localMember, member);
        if (this.loadBalanceEventHandler != null) {
            log.info("Application member " + TribesUtil.getName(member) + " joined group " + new String(member.getDomain()));
            this.loadBalanceEventHandler.applicationMemberAdded(this.toAxis2Member(member));
        }
        if (shouldAddMember) {
            if (this.rpcMembershipChannel != null && this.isLocalMemberInitialized() && this.wkaMembers.contains(member)) {
                log.info("A WKA member " + TribesUtil.getName(member) + " just joined the group. Sending MEMBER_LIST message.");
                try {
                    org.apache.catalina.tribes.Member source;
                    MemberListCommand memListCmd = new MemberListCommand();
                    ArrayList<org.apache.catalina.tribes.Member> members = new ArrayList<org.apache.catalina.tribes.Member>(this.members);
                    members.add(this.localMember);
                    memListCmd.setMembers(members.toArray(new org.apache.catalina.tribes.Member[members.size()]));
                    Response[] responses = this.rpcMembershipChannel.send(new org.apache.catalina.tribes.Member[]{member}, (Serializable)memListCmd, 3, 1032, 10000L);
                    if (responses != null && responses.length > 0 && responses[0] != null && !TribesUtil.areInSameDomain(source = responses[0].getSource(), member)) {
                        if (log.isDebugEnabled()) {
                            log.debug("WKA Member " + TribesUtil.getName(source) + " does not belong to local domain " + new String(this.domain) + ". Hence removing it from the list.");
                        }
                        members.remove(member);
                        return false;
                    }
                }
                catch (Exception e) {
                    String errMsg = "Could not send MEMBER_LIST to well-known member " + TribesUtil.getName(member);
                    log.error(errMsg, e);
                    throw new RemoteProcessException(errMsg, (Throwable)e);
                }
            }
            this.members.add(member);
            if (log.isDebugEnabled()) {
                log.debug("Added group member " + TribesUtil.getName(member) + " to domain " + new String(member.getDomain()));
            }
            return true;
        }
        return false;
    }

    public void sendMemberList(org.apache.catalina.tribes.Member member) {
        try {
            MemberListCommand memListCmd = new MemberListCommand();
            ArrayList<org.apache.catalina.tribes.Member> members = new ArrayList<org.apache.catalina.tribes.Member>(this.members);
            memListCmd.setMembers(members.toArray(new org.apache.catalina.tribes.Member[members.size()]));
            this.rpcMembershipChannel.send(new org.apache.catalina.tribes.Member[]{member}, (Serializable)memListCmd, 3, 1032, 10000L);
            if (log.isDebugEnabled()) {
                log.debug("Sent MEMBER_LIST to " + TribesUtil.getName(member));
            }
        }
        catch (Exception e) {
            String errMsg = "Could not send MEMBER_LIST to member " + TribesUtil.getName(member);
            log.error(errMsg, e);
            throw new RemoteProcessException(errMsg, (Throwable)e);
        }
    }

    public void sendMemberJoinedToAll(org.apache.catalina.tribes.Member member) {
        try {
            MemberJoinedCommand cmd = new MemberJoinedCommand();
            cmd.setMember(member);
            ArrayList membersToSend = (ArrayList)((ArrayList)this.members).clone();
            membersToSend.remove(member);
            if (membersToSend.size() > 0) {
                this.rpcMembershipChannel.send(membersToSend.toArray(new org.apache.catalina.tribes.Member[membersToSend.size()]), (Serializable)cmd, 3, 1032, 10000L);
                if (log.isDebugEnabled()) {
                    log.debug("Sent MEMBER_JOINED[" + TribesUtil.getName(member) + "] to all members in domain " + new String(this.domain));
                }
            }
        }
        catch (Exception e) {
            String errMsg = "Could not send MEMBER_JOINED[" + TribesUtil.getName(member) + "] to all members ";
            log.error(errMsg, e);
            throw new RemoteProcessException(errMsg, (Throwable)e);
        }
    }

    private Member toAxis2Member(org.apache.catalina.tribes.Member member) {
        String https;
        Member axis2Member = new Member(TribesUtil.getHost(member), member.getPort());
        Properties props = this.getProperties(member.getPayload());
        String http = props.getProperty("HTTP");
        if (http != null && http.trim().length() != 0) {
            axis2Member.setHttpPort(Integer.parseInt(http));
        }
        if ((https = props.getProperty("HTTPS")) != null && https.trim().length() != 0) {
            axis2Member.setHttpsPort(Integer.parseInt(https));
        }
        return axis2Member;
    }

    private Properties getProperties(byte[] payload) {
        Properties props = null;
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(payload);
            props = new Properties();
            props.load(bin);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    private boolean isLocalMemberInitialized() {
        if (this.configContext == null) {
            return false;
        }
        Object clusterInitialized = this.configContext.getPropertyNonReplicable("local_cluster.initialized");
        return clusterInitialized != null && clusterInitialized.equals("true");
    }

    public synchronized void memberDisappeared(org.apache.catalina.tribes.Member member) {
        this.members.remove(member);
        if (this.loadBalanceEventHandler != null) {
            this.loadBalanceEventHandler.applicationMemberRemoved(this.toAxis2Member(member));
        }
    }

    public synchronized org.apache.catalina.tribes.Member[] getMembers() {
        return this.members.toArray(new org.apache.catalina.tribes.Member[this.members.size()]);
    }

    public synchronized org.apache.catalina.tribes.Member getLongestLivingMember() {
        org.apache.catalina.tribes.Member longestLivingMember = null;
        if (this.members.size() > 0) {
            org.apache.catalina.tribes.Member member0 = this.members.get(0);
            long longestAliveTime = member0.getMemberAliveTime();
            longestLivingMember = member0;
            for (org.apache.catalina.tribes.Member member : this.members) {
                if (longestAliveTime >= member.getMemberAliveTime()) continue;
                longestAliveTime = member.getMemberAliveTime();
                longestLivingMember = member;
            }
        }
        return longestLivingMember;
    }

    public synchronized org.apache.catalina.tribes.Member getRandomMember() {
        if (this.members.size() == 0) {
            return null;
        }
        int memberIndex = new Random().nextInt(this.members.size());
        return this.members.get(memberIndex);
    }

    public boolean hasMembers() {
        return this.members.size() > 0;
    }

    public org.apache.catalina.tribes.Member getMember(org.apache.catalina.tribes.Member member) {
        if (this.hasMembers()) {
            MemberImpl result = null;
            for (int i = 0; i < this.members.size() && result == null; ++i) {
                if (!this.members.get(i).equals(member)) continue;
                result = (MemberImpl)this.members.get(i);
            }
            return result;
        }
        return null;
    }
}

