/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.configuration.ConfigurationClusteringCommand;
import org.apache.axis2.clustering.configuration.DefaultConfigurationManager;
import org.apache.axis2.clustering.context.ContextClusteringCommand;
import org.apache.axis2.clustering.context.DefaultContextManager;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.catalina.tribes.ByteMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.RpcMessage;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelListener
implements org.apache.catalina.tribes.ChannelListener {
    private static final Log log = LogFactory.getLog(ChannelListener.class);
    private DefaultContextManager contextManager;
    private DefaultConfigurationManager configurationManager;
    private ConfigurationContext configurationContext;

    public ChannelListener(ConfigurationContext configurationContext, DefaultConfigurationManager configurationManager, DefaultContextManager contextManager) {
        this.configurationManager = configurationManager;
        this.contextManager = contextManager;
        this.configurationContext = configurationContext;
    }

    public void setContextManager(DefaultContextManager contextManager) {
        this.contextManager = contextManager;
    }

    public void setConfigurationManager(DefaultConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public boolean accept(Serializable msg, Member sender) {
        return !(msg instanceof RpcMessage);
    }

    public void messageReceived(Serializable msg, Member sender) {
        try {
            AxisConfiguration configuration = this.configurationContext.getAxisConfiguration();
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
            classLoaders.add(configuration.getSystemClassLoader());
            classLoaders.add(this.getClass().getClassLoader());
            Iterator iter = configuration.getServiceGroups();
            while (iter.hasNext()) {
                AxisServiceGroup group = (AxisServiceGroup)iter.next();
                classLoaders.add(group.getServiceGroupClassLoader());
            }
            for (Object obj : configuration.getModules().values()) {
                AxisModule module = (AxisModule)obj;
                classLoaders.add(module.getModuleClassLoader());
            }
            byte[] message = ((ByteMessage)msg).getMessage();
            msg = XByteBuffer.deserialize((byte[])message, (int)0, (int)message.length, (ClassLoader[])classLoaders.toArray(new ClassLoader[classLoaders.size()]));
        }
        catch (Exception e) {
            String errMsg = "Cannot deserialize received message";
            log.error(errMsg, e);
            throw new RemoteProcessException(errMsg, (Throwable)e);
        }
        if (this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") == null) {
            log.warn("Received message " + msg + " before cluster initialization has been completed from " + TribesUtil.getName(sender));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Received message " + msg + " from " + TribesUtil.getName(sender));
        }
        try {
            this.processMessage(msg);
        }
        catch (Exception e) {
            String errMsg = "Cannot process received message";
            log.error(errMsg, e);
            throw new RemoteProcessException(errMsg, (Throwable)e);
        }
    }

    private void processMessage(Serializable msg) throws ClusteringFault {
        if (msg instanceof ContextClusteringCommand && this.contextManager != null) {
            ContextClusteringCommand ctxCmd = (ContextClusteringCommand)msg;
            ctxCmd.execute(this.configurationContext);
        } else if (msg instanceof ConfigurationClusteringCommand && this.configurationManager != null) {
            this.configurationManager.process((ConfigurationClusteringCommand)msg);
        }
    }
}

