/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.ContextClusteringCommand;
import org.apache.axis2.clustering.context.commands.ContextClusteringCommandCollection;
import org.apache.axis2.clustering.context.commands.DeleteServiceGroupContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateConfigurationContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateServiceContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateServiceGroupContextCommand;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.PropertyDifference;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ContextClusteringCommandFactory {
    private static final Log log = LogFactory.getLog(ContextClusteringCommandFactory.class);

    public static ContextClusteringCommandCollection getCommandCollection(AbstractContext[] contexts, Map excludedReplicationPatterns) {
        ArrayList<ContextClusteringCommand> commands = new ArrayList<ContextClusteringCommand>(contexts.length);
        ContextClusteringCommandCollection collection = new ContextClusteringCommandCollection(commands);
        for (int i = 0; i < contexts.length; ++i) {
            ContextClusteringCommand cmd = ContextClusteringCommandFactory.getUpdateCommand(contexts[i], excludedReplicationPatterns, false);
            if (cmd == null) continue;
            commands.add(cmd);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContextClusteringCommand getUpdateCommand(AbstractContext context, Map excludedPropertyPatterns, boolean includeAllProperties) {
        UpdateContextCommand cmd = ContextClusteringCommandFactory.toUpdateContextCommand(context);
        if (cmd != null) {
            ContextClusteringCommandFactory.fillProperties(cmd, context, excludedPropertyPatterns, includeAllProperties);
            if (cmd.isPropertiesEmpty()) {
                cmd = null;
            }
        }
        AbstractContext abstractContext = context;
        synchronized (abstractContext) {
            context.clearPropertyDifferences();
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContextClusteringCommand getUpdateCommand(AbstractContext context, String[] propertyNames) throws ClusteringFault {
        UpdateContextCommand cmd = ContextClusteringCommandFactory.toUpdateContextCommand(context);
        if (cmd != null) {
            ContextClusteringCommandFactory.fillProperties(cmd, context, propertyNames);
            if (cmd.isPropertiesEmpty()) {
                cmd = null;
            }
        }
        AbstractContext abstractContext = context;
        synchronized (abstractContext) {
            context.clearPropertyDifferences();
        }
        return cmd;
    }

    private static UpdateContextCommand toUpdateContextCommand(AbstractContext context) {
        UpdateContextCommand cmd = null;
        if (context instanceof ConfigurationContext) {
            cmd = new UpdateConfigurationContextCommand();
        } else if (context instanceof ServiceGroupContext) {
            ServiceGroupContext sgCtx = (ServiceGroupContext)context;
            cmd = new UpdateServiceGroupContextCommand();
            UpdateServiceGroupContextCommand updateSgCmd = (UpdateServiceGroupContextCommand)cmd;
            updateSgCmd.setServiceGroupName(sgCtx.getDescription().getServiceGroupName());
            updateSgCmd.setServiceGroupContextId(sgCtx.getId());
        } else if (context instanceof ServiceContext) {
            ServiceContext serviceCtx = (ServiceContext)context;
            cmd = new UpdateServiceContextCommand();
            UpdateServiceContextCommand updateServiceCmd = (UpdateServiceContextCommand)cmd;
            String sgName = serviceCtx.getServiceGroupContext().getDescription().getServiceGroupName();
            updateServiceCmd.setServiceGroupName(sgName);
            updateServiceCmd.setServiceGroupContextId(serviceCtx.getServiceGroupContext().getId());
            updateServiceCmd.setServiceName(serviceCtx.getAxisService().getName());
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillProperties(UpdateContextCommand updateCmd, AbstractContext context, Map excludedPropertyPatterns, boolean includeAllProperties) {
        if (!includeAllProperties) {
            AbstractContext abstractContext = context;
            synchronized (abstractContext) {
                Map diffs = context.getPropertyDifferences();
                for (String key : diffs.keySet()) {
                    PropertyDifference diff = (PropertyDifference)diffs.get(key);
                    Object value = diff.getValue();
                    if (!(value instanceof Serializable) || ContextClusteringCommandFactory.isExcluded(key, context.getClass().getName(), excludedPropertyPatterns)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("sending property =" + key + "-" + value);
                    }
                    updateCmd.addProperty(diff);
                }
            }
        }
        AbstractContext abstractContext = context;
        synchronized (abstractContext) {
            Iterator iter = context.getPropertyNames();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = context.getPropertyNonReplicable(key);
                if (!(value instanceof Serializable) || ContextClusteringCommandFactory.isExcluded(key, context.getClass().getName(), excludedPropertyPatterns)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("sending property =" + key + "-" + value);
                }
                PropertyDifference diff = new PropertyDifference(key, value, false);
                updateCmd.addProperty(diff);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillProperties(UpdateContextCommand updateCmd, AbstractContext context, String[] propertyNames) throws ClusteringFault {
        AbstractContext abstractContext = context;
        synchronized (abstractContext) {
            Map diffs = context.getPropertyDifferences();
            for (int i = 0; i < propertyNames.length; ++i) {
                String key = propertyNames[i];
                Object prop = context.getPropertyNonReplicable(key);
                if (prop instanceof Serializable) {
                    if (log.isDebugEnabled()) {
                        log.debug("sending property =" + key + "-" + prop);
                    }
                } else {
                    String msg = "Trying to replicate non-serializable property " + key + " in context " + context;
                    throw new ClusteringFault(msg);
                }
                PropertyDifference diff = (PropertyDifference)diffs.get(key);
                diff.setValue(prop);
                updateCmd.addProperty(diff);
            }
        }
    }

    private static boolean isExcluded(String propertyName, String ctxClassName, Map excludedPropertyPatterns) {
        List defaultExcludes;
        List specificExcludes = (List)excludedPropertyPatterns.get(ctxClassName);
        boolean isExcluded = false;
        if (specificExcludes != null) {
            isExcluded = ContextClusteringCommandFactory.isExcluded(specificExcludes, propertyName);
        }
        if (!isExcluded && (defaultExcludes = (List)excludedPropertyPatterns.get("defaults")) != null) {
            isExcluded = ContextClusteringCommandFactory.isExcluded(defaultExcludes, propertyName);
        }
        return isExcluded;
    }

    private static boolean isExcluded(List list, String propertyName) {
        for (String pattern : list) {
            if (!(pattern.startsWith("*") ? propertyName.endsWith(pattern = pattern.replaceAll("\\*", "")) : (pattern.endsWith("*") ? propertyName.startsWith(pattern = pattern.replaceAll("\\*", "")) : pattern.equals(propertyName)))) continue;
            return true;
        }
        return false;
    }

    public static ContextClusteringCommand getRemoveCommand(AbstractContext abstractContext) {
        if (abstractContext instanceof ServiceGroupContext) {
            ServiceGroupContext sgCtx = (ServiceGroupContext)abstractContext;
            DeleteServiceGroupContextCommand cmd = new DeleteServiceGroupContextCommand();
            cmd.setServiceGroupContextId(sgCtx.getId());
            return cmd;
        }
        return null;
    }
}

