/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.attachments.ConfigurableDataHandler;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MIMEOutputUtils {
    private static Log log = LogFactory.getLog(class$org$apache$axiom$om$impl$MIMEOutputUtils == null ? (class$org$apache$axiom$om$impl$MIMEOutputUtils = MIMEOutputUtils.class$("org.apache.axiom.om.impl.MIMEOutputUtils")) : class$org$apache$axiom$om$impl$MIMEOutputUtils);
    private static boolean isDebugEnabled = log.isDebugEnabled();
    private static byte[] CRLF = new byte[]{13, 10};
    static /* synthetic */ Class class$org$apache$axiom$om$impl$MIMEOutputUtils;

    public static void complete(OutputStream outStream, String bufferedXML, LinkedList binaryNodeList, String boundary, String contentId, String charSetEncoding, String SOAPContentType) {
        try {
            MIMEOutputUtils.startWritingMime(outStream, boundary);
            DataHandler dh = new DataHandler(bufferedXML, "text/xml; charset=" + charSetEncoding);
            MimeBodyPart rootMimeBodyPart = new MimeBodyPart();
            rootMimeBodyPart.setDataHandler(dh);
            rootMimeBodyPart.addHeader("Content-Type", "application/xop+xml; charset=" + charSetEncoding + "; type=\"" + SOAPContentType + "\"");
            rootMimeBodyPart.addHeader("Content-Transfer-Encoding", "binary");
            rootMimeBodyPart.addHeader("Content-ID", "<" + contentId + ">");
            MIMEOutputUtils.writeBodyPart(outStream, rootMimeBodyPart, boundary);
            Iterator binaryNodeIterator = binaryNodeList.iterator();
            while (binaryNodeIterator.hasNext()) {
                OMText binaryNode = (OMText)binaryNodeIterator.next();
                MIMEOutputUtils.writeBodyPart(outStream, MIMEOutputUtils.createMimeBodyPart(binaryNode.getContentID(), (DataHandler)binaryNode.getDataHandler()), boundary);
            }
            MIMEOutputUtils.finishWritingMime(outStream);
            outStream.flush();
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", e);
        }
        catch (MessagingException e) {
            throw new OMException("Problem writing Mime Parts.", e);
        }
    }

    public static void complete(OutputStream outStream, byte[] xmlData, LinkedList binaryNodeList, String boundary, String contentId, String charSetEncoding, String SOAPContentType) {
        try {
            if (isDebugEnabled) {
                log.debug("Start: write the SOAPPart and the attachments");
            }
            MIMEOutputUtils.startWritingMime(outStream, boundary);
            DataHandler dh = new DataHandler(new ByteArrayDataSource(xmlData, "text/xml; charset=" + charSetEncoding));
            MimeBodyPart rootMimeBodyPart = new MimeBodyPart();
            rootMimeBodyPart.setDataHandler(dh);
            rootMimeBodyPart.addHeader("Content-Type", "application/xop+xml; charset=" + charSetEncoding + "; type=\"" + SOAPContentType + "\"");
            rootMimeBodyPart.addHeader("Content-Transfer-Encoding", "binary");
            rootMimeBodyPart.addHeader("Content-ID", "<" + contentId + ">");
            MIMEOutputUtils.writeBodyPart(outStream, rootMimeBodyPart, boundary);
            Iterator binaryNodeIterator = binaryNodeList.iterator();
            while (binaryNodeIterator.hasNext()) {
                OMText binaryNode = (OMText)binaryNodeIterator.next();
                MIMEOutputUtils.writeBodyPart(outStream, MIMEOutputUtils.createMimeBodyPart(binaryNode.getContentID(), (DataHandler)binaryNode.getDataHandler()), boundary);
            }
            MIMEOutputUtils.finishWritingMime(outStream);
            outStream.flush();
            if (isDebugEnabled) {
                log.debug("End: write the SOAPPart and the attachments");
            }
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", e);
        }
        catch (MessagingException e) {
            throw new OMException("Problem writing Mime Parts.", e);
        }
    }

    public static void complete(OutputStream outStream, StringWriter writer, LinkedList binaryNodeList, String boundary, String contentId, String charSetEncoding, String SOAPContentType) {
        MIMEOutputUtils.complete(outStream, writer.toString(), binaryNodeList, boundary, contentId, charSetEncoding, SOAPContentType);
    }

    public static MimeBodyPart createMimeBodyPart(String contentID, DataHandler dataHandler) throws MessagingException {
        if (isDebugEnabled) {
            log.debug("Create MimeBodyPart for " + contentID);
        }
        String encoding = null;
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(dataHandler);
        mimeBodyPart.addHeader("Content-ID", "<" + contentID + ">");
        mimeBodyPart.addHeader("Content-Type", dataHandler.getContentType());
        if (dataHandler instanceof ConfigurableDataHandler) {
            ConfigurableDataHandler configurableDataHandler = (ConfigurableDataHandler)dataHandler;
            encoding = configurableDataHandler.getTransferEncoding();
        }
        if (encoding == null) {
            encoding = "binary";
        }
        mimeBodyPart.addHeader("Content-Transfer-Encoding", encoding);
        return mimeBodyPart;
    }

    public static void writeMimeBoundary(OutputStream outStream, String boundary) throws IOException {
        outStream.write(new byte[]{45, 45});
        outStream.write(boundary.getBytes("UTF-8"));
    }

    public static void startWritingMime(OutputStream outStream, String boundary) throws IOException {
        MIMEOutputUtils.writeMimeBoundary(outStream, boundary);
    }

    public static void writeBodyPart(OutputStream outStream, MimeBodyPart part, String boundary) throws IOException, MessagingException {
        if (isDebugEnabled) {
            log.debug("Start writeMimeBodyPart for " + part.getContentID());
        }
        outStream.write(CRLF);
        part.writeTo(outStream);
        outStream.write(CRLF);
        MIMEOutputUtils.writeMimeBoundary(outStream, boundary);
        outStream.flush();
        if (isDebugEnabled) {
            log.debug("End writeMimeBodyPart");
        }
    }

    public static void finishWritingMime(OutputStream outStream) throws IOException {
        if (isDebugEnabled) {
            log.debug("Write --, which indicates the end of the last boundary");
        }
        outStream.write(new byte[]{45, 45});
    }

    public static void writeSOAPWithAttachmentsMessage(StringWriter writer, OutputStream outputStream, Attachments attachments, OMOutputFormat format) {
        String SOAPContentType = format.isSOAP11() ? "text/xml" : "application/soap+xml";
        String contentType = SOAPContentType + "; charset=" + format.getCharSetEncoding();
        DataHandler dh = new DataHandler(writer.toString(), "text/xml; charset=" + format.getCharSetEncoding());
        MIMEOutputUtils.writeDataHandlerWithAttachmentsMessage(dh, contentType, outputStream, attachments.getMap(), format);
    }

    public static void writeDataHandlerWithAttachmentsMessage(DataHandler rootDataHandler, String contentType, OutputStream outputStream, Map attachments, OMOutputFormat format) {
        try {
            MIMEOutputUtils.startWritingMime(outputStream, format.getMimeBoundary());
            MimeBodyPart rootMimeBodyPart = new MimeBodyPart();
            rootMimeBodyPart.setDataHandler(rootDataHandler);
            rootMimeBodyPart.addHeader("Content-Type", contentType);
            rootMimeBodyPart.addHeader("Content-Transfer-Encoding", "8bit");
            rootMimeBodyPart.addHeader("Content-ID", "<" + format.getRootContentId() + ">");
            MIMEOutputUtils.writeBodyPart(outputStream, rootMimeBodyPart, format.getMimeBoundary());
            Iterator iterator = attachments.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                MimeBodyPart part = MIMEOutputUtils.createMimeBodyPart(key, (DataHandler)attachments.get(key));
                MIMEOutputUtils.writeBodyPart(outputStream, part, format.getMimeBoundary());
            }
            MIMEOutputUtils.finishWritingMime(outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", e);
        }
        catch (MessagingException e) {
            throw new OMException("Problem writing Mime Parts.", e);
        }
    }

    public static void writeMM7Message(StringWriter writer, OutputStream outputStream, Attachments attachments, OMOutputFormat format, String innerPartCID, String innerBoundary) {
        try {
            String SOAPContentType = format.isSOAP11() ? "text/xml" : "application/soap+xml";
            MIMEOutputUtils.startWritingMime(outputStream, format.getMimeBoundary());
            DataHandler dh = new DataHandler(writer.toString(), "text/xml; charset=" + format.getCharSetEncoding());
            MimeBodyPart rootMimeBodyPart = new MimeBodyPart();
            rootMimeBodyPart.setDataHandler(dh);
            rootMimeBodyPart.addHeader("Content-Type", SOAPContentType + "; charset=" + format.getCharSetEncoding());
            rootMimeBodyPart.addHeader("Content-ID", "<" + format.getRootContentId() + ">");
            MIMEOutputUtils.writeBodyPart(outputStream, rootMimeBodyPart, format.getMimeBoundary());
            if (attachments.getContentIDSet().size() != 0) {
                outputStream.write(CRLF);
                StringBuffer sb = new StringBuffer();
                sb.append("Content-Type: multipart/related");
                sb.append("; ");
                sb.append("boundary=");
                sb.append("\"" + innerBoundary + "\"");
                outputStream.write(sb.toString().getBytes());
                outputStream.write(CRLF);
                StringBuffer sb1 = new StringBuffer();
                sb1.append("Content-ID: ");
                sb1.append("<");
                sb1.append(innerPartCID);
                sb1.append(">");
                outputStream.write(sb1.toString().getBytes());
                outputStream.write(CRLF);
                outputStream.write(CRLF);
                MIMEOutputUtils.startWritingMime(outputStream, innerBoundary);
                Iterator attachmentIDIterator = attachments.getContentIDSet().iterator();
                while (attachmentIDIterator.hasNext()) {
                    String contentID = (String)attachmentIDIterator.next();
                    DataHandler dataHandler = attachments.getDataHandler(contentID);
                    MIMEOutputUtils.writeBodyPart(outputStream, MIMEOutputUtils.createMimeBodyPart(contentID, dataHandler), innerBoundary);
                }
                MIMEOutputUtils.finishWritingMime(outputStream);
                outputStream.write(CRLF);
                MIMEOutputUtils.writeMimeBoundary(outputStream, format.getMimeBoundary());
            }
            MIMEOutputUtils.finishWritingMime(outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new OMException("Error while writing to the OutputStream.", e);
        }
        catch (MessagingException e) {
            throw new OMException("Problem writing Mime Parts.", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

