/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import javax.faces.component.MethodBindingAdapterBase;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;

class MethodBindingValueChangeListener
extends MethodBindingAdapterBase
implements ValueChangeListener,
StateHolder {
    private MethodBinding methodBinding = null;
    private static boolean securityManager = System.getSecurityManager() != null;
    private boolean tranzient = false;

    public MethodBindingValueChangeListener() {
    }

    public MethodBindingValueChangeListener(MethodBinding methodBinding) {
        this.methodBinding = methodBinding;
    }

    public MethodBinding getWrapped() {
        return this.methodBinding;
    }

    @Override
    public void processValueChange(ValueChangeEvent actionEvent) throws AbortProcessingException {
        if (actionEvent == null) {
            throw new NullPointerException();
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            this.methodBinding.invoke(context, new Object[]{actionEvent});
        }
        catch (EvaluationException ee) {
            Throwable cause = this.getExpectedCause(AbortProcessingException.class, ee);
            if (cause instanceof AbortProcessingException) {
                throw (AbortProcessingException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException(ee.getMessage());
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] result = null;
        if (!this.tranzient) {
            if (this.methodBinding instanceof StateHolder) {
                Object[] stateStruct = new Object[]{((StateHolder)((Object)this.methodBinding)).saveState(context), this.methodBinding.getClass().getName()};
                result = stateStruct;
            } else {
                result = this.methodBinding;
            }
        }
        return result;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (null == state) {
            return;
        }
        if (!(state instanceof MethodBinding)) {
            Object[] stateStruct = (Object[])state;
            Object savedState = stateStruct[0];
            String className = stateStruct[1].toString();
            MethodBinding result = null;
            if (null != className) {
                Class toRestoreClass;
                try {
                    toRestoreClass = MethodBindingValueChangeListener.loadClass(className, this);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                if (null != toRestoreClass) {
                    try {
                        result = (MethodBinding)toRestoreClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    catch (IllegalAccessException a) {
                        throw new IllegalStateException(a.getMessage());
                    }
                }
                if (null != result && null != savedState) {
                    ((StateHolder)((Object)result)).restoreState(context, savedState);
                }
                this.methodBinding = result;
            }
        } else {
            this.methodBinding = (MethodBinding)state;
        }
    }

    @Override
    public boolean isTransient() {
        return this.tranzient;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this.tranzient = newTransientValue;
    }

    private static Class loadClass(String name, final Object fallbackClass) throws ClassNotFoundException {
        if (securityManager) {
            Object cl = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            if (cl == null) {
                cl = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return fallbackClass.getClass().getClassLoader();
                    }
                });
            }
            return Class.forName(name, false, (ClassLoader)cl);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return Class.forName(name, false, loader);
    }
}

