/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ConditionObjectWrapper;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -6992448646407690164L;
    final ReadLock readerLock;
    final WriteLock writerLock;
    final Sync sync = new NonfairSync();

    public ReentrantReadWriteLock() {
        this.readerLock = new ReadLock(this);
        this.writerLock = new WriteLock(this);
    }

    public Lock writeLock() {
        return this.writerLock;
    }

    public Lock readLock() {
        return this.readerLock;
    }

    public final boolean isFair() {
        return this.sync instanceof FairSync;
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public int getReadLockCount() {
        return this.sync.getReadLockCount();
    }

    public boolean isWriteLocked() {
        return this.sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.sync.isHeldExclusively();
    }

    public int getWriteHoldCount() {
        return this.sync.getWriteHoldCount();
    }

    public int getReadHoldCount() {
        return this.sync.getReadHoldCount();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    public String toString() {
        return super.toString() + "[Write locks = " + this.getWriteHoldCount() + ", Read locks = " + this.getReadLockCount() + "]";
    }

    public static class WriteLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -4992448646407690164L;
        private final Sync sync;

        protected WriteLock(ReentrantReadWriteLock lock) {
            this.sync = lock.sync;
        }

        public void lock() {
            this.sync.acquire(1);
        }

        public void lockInterruptibly() throws InterruptedException {
            this.sync.acquireInterruptibly(1);
        }

        public boolean tryLock() {
            return this.sync.tryWriteLock();
        }

        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.sync.tryAcquireNanos(1, unit.toNanos(timeout));
        }

        public void unlock() {
            this.sync.release(1);
        }

        public Condition newCondition() {
            return new ConditionObjectWrapper(this.sync.newCondition());
        }

        public String toString() {
            Thread o = this.sync.getOwner();
            return super.toString() + (o == null ? "[Unlocked]" : "[Locked by thread " + o.getName() + "]");
        }

        public boolean isHeldByCurrentThread() {
            return this.sync.isHeldExclusively();
        }

        public int getHoldCount() {
            return this.sync.getWriteHoldCount();
        }
    }

    public static class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -5992448646407690164L;
        private final Sync sync;

        protected ReadLock(ReentrantReadWriteLock lock) {
            this.sync = lock.sync;
        }

        public void lock() {
            this.sync.acquireShared(1);
        }

        public void lockInterruptibly() throws InterruptedException {
            this.sync.acquireSharedInterruptibly(1);
        }

        public boolean tryLock() {
            return this.sync.tryReadLock();
        }

        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
        }

        public void unlock() {
            this.sync.releaseShared(1);
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            int r = this.sync.getReadLockCount();
            return super.toString() + "[Read locks = " + r + "]";
        }
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = -2274990926593161451L;

        FairSync() {
        }

        final boolean writerShouldBlock(Thread current) {
            Thread first = this.getFirstQueuedThread();
            return first != null && first != current;
        }

        final boolean readerShouldBlock(Thread current) {
            Thread first = this.getFirstQueuedThread();
            return first != null && first != current;
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -8159625535654395037L;

        NonfairSync() {
        }

        final boolean writerShouldBlock(Thread current) {
            return false;
        }

        final boolean readerShouldBlock(Thread current) {
            return false;
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 6317671515068378041L;
        static final int SHARED_SHIFT = 16;
        static final int SHARED_UNIT = 65536;
        static final int MAX_COUNT = 65535;
        static final int EXCLUSIVE_MASK = 65535;
        transient ThreadLocalHoldCounter readHolds = new ThreadLocalHoldCounter();
        transient HoldCounter cachedHoldCounter;

        static int sharedCount(int c) {
            return c >>> 16;
        }

        static int exclusiveCount(int c) {
            return c & 0xFFFF;
        }

        Sync() {
            this.setState(this.getState());
        }

        abstract boolean readerShouldBlock(Thread var1);

        abstract boolean writerShouldBlock(Thread var1);

        protected final boolean tryRelease(int releases) {
            int nextc = this.getState() - releases;
            if (Thread.currentThread() != this.getExclusiveOwnerThread()) {
                throw new IllegalMonitorStateException();
            }
            if (Sync.exclusiveCount(nextc) == 0) {
                this.setExclusiveOwnerThread(null);
                this.setState(nextc);
                return true;
            }
            this.setState(nextc);
            return false;
        }

        protected final boolean tryAcquire(int acquires) {
            Thread current = Thread.currentThread();
            int c = this.getState();
            int w = Sync.exclusiveCount(c);
            if (c != 0) {
                if (w == 0 || current != this.getExclusiveOwnerThread()) {
                    return false;
                }
                if (w + Sync.exclusiveCount(acquires) > 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
            }
            if (w == 0 && this.writerShouldBlock(current) || !this.compareAndSetState(c, c + acquires)) {
                return false;
            }
            this.setExclusiveOwnerThread(current);
            return true;
        }

        protected final boolean tryReleaseShared(int unused) {
            int nextc;
            int c;
            HoldCounter rh = this.cachedHoldCounter;
            Thread current = Thread.currentThread();
            if (rh == null || rh.tid != current.getId()) {
                rh = (HoldCounter)this.readHolds.get();
            }
            if (rh.tryDecrement() <= 0) {
                throw new IllegalMonitorStateException();
            }
            while (!this.compareAndSetState(c = this.getState(), nextc = c - 65536)) {
            }
            return nextc == 0;
        }

        protected final int tryAcquireShared(int unused) {
            Thread current = Thread.currentThread();
            int c = this.getState();
            if (Sync.exclusiveCount(c) != 0 && this.getExclusiveOwnerThread() != current) {
                return -1;
            }
            if (Sync.sharedCount(c) == 65535) {
                throw new Error("Maximum lock count exceeded");
            }
            if (!this.readerShouldBlock(current) && this.compareAndSetState(c, c + 65536)) {
                HoldCounter rh = this.cachedHoldCounter;
                if (rh == null || rh.tid != current.getId()) {
                    this.cachedHoldCounter = rh = (HoldCounter)this.readHolds.get();
                }
                ++rh.count;
                return 1;
            }
            return this.fullTryAcquireShared(current);
        }

        final int fullTryAcquireShared(Thread current) {
            int c;
            HoldCounter rh = this.cachedHoldCounter;
            if (rh == null || rh.tid != current.getId()) {
                rh = (HoldCounter)this.readHolds.get();
            }
            do {
                int w;
                if ((w = Sync.exclusiveCount(c = this.getState())) != 0 && this.getExclusiveOwnerThread() != current || (rh.count | w) == 0 && this.readerShouldBlock(current)) {
                    return -1;
                }
                if (Sync.sharedCount(c) != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(c, c + 65536));
            this.cachedHoldCounter = rh;
            ++rh.count;
            return 1;
        }

        final boolean tryWriteLock() {
            Thread current = Thread.currentThread();
            int c = this.getState();
            if (c != 0) {
                int w = Sync.exclusiveCount(c);
                if (w == 0 || current != this.getExclusiveOwnerThread()) {
                    return false;
                }
                if (w == 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
            }
            if (!this.compareAndSetState(c, c + 1)) {
                return false;
            }
            this.setExclusiveOwnerThread(current);
            return true;
        }

        final boolean tryReadLock() {
            int c;
            Thread current = Thread.currentThread();
            do {
                if (Sync.exclusiveCount(c = this.getState()) != 0 && this.getExclusiveOwnerThread() != current) {
                    return false;
                }
                if (Sync.sharedCount(c) != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(c, c + 65536));
            HoldCounter rh = this.cachedHoldCounter;
            if (rh == null || rh.tid != current.getId()) {
                this.cachedHoldCounter = rh = (HoldCounter)this.readHolds.get();
            }
            ++rh.count;
            return true;
        }

        protected final boolean isHeldExclusively() {
            return this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        final Thread getOwner() {
            return Sync.exclusiveCount(this.getState()) == 0 ? null : this.getExclusiveOwnerThread();
        }

        final int getReadLockCount() {
            return Sync.sharedCount(this.getState());
        }

        final boolean isWriteLocked() {
            return Sync.exclusiveCount(this.getState()) != 0;
        }

        final int getWriteHoldCount() {
            return this.isHeldExclusively() ? Sync.exclusiveCount(this.getState()) : 0;
        }

        final int getReadHoldCount() {
            return this.getReadLockCount() == 0 ? 0 : ((HoldCounter)this.readHolds.get()).count;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.readHolds = new ThreadLocalHoldCounter();
            this.setState(0);
        }

        final int getCount() {
            return this.getState();
        }

        static final class ThreadLocalHoldCounter
        extends ThreadLocal {
            ThreadLocalHoldCounter() {
            }

            public Object initialValue() {
                return new HoldCounter();
            }
        }

        static final class HoldCounter {
            int count;
            final long tid = Thread.currentThread().getId();

            HoldCounter() {
            }

            int tryDecrement() {
                int c = this.count;
                if (c > 0) {
                    this.count = c - 1;
                }
                return c;
            }
        }
    }
}

