/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util;

import edu.emory.mathcs.backport.java.util.Deque;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList
extends AbstractSequentialList
implements List,
Deque,
Cloneable,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    private transient int size = 0;
    private transient int modCount;
    private transient Entry head;

    public LinkedList() {
        Entry sentinel;
        sentinel.next = sentinel.prev = (sentinel = new Entry(null));
        this.head = sentinel;
    }

    public LinkedList(Collection c) {
        this();
        this.addAll(c);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        return this.findFirst(o) != null;
    }

    private Entry getAt(int idx) {
        int size = this.size;
        if (idx < 0 || idx >= size) {
            throw new ArrayIndexOutOfBoundsException("Index: " + idx + "; Size: " + size);
        }
        if (idx < size >> 1) {
            Entry e = this.head.next;
            while (idx > 0) {
                e = e.next;
                --idx;
            }
            return e;
        }
        Entry e = this.head.prev;
        for (idx = size - idx - 1; idx > 0; --idx) {
            e = e.prev;
        }
        return e;
    }

    private Entry findFirst(Object o) {
        if (o == null) {
            Entry e = this.head.next;
            while (e != this.head) {
                if (e.val == null) {
                    return e;
                }
                e = e.next;
            }
        } else {
            Entry e = this.head.next;
            while (e != this.head) {
                if (o.equals(e.val)) {
                    return e;
                }
                e = e.next;
            }
        }
        return null;
    }

    private Entry findLast(Object o) {
        if (o == null) {
            Entry e = this.head.prev;
            while (e != this.head) {
                if (e.val == null) {
                    return e;
                }
                e = e.prev;
            }
        } else {
            Entry e = this.head.prev;
            while (e != this.head) {
                if (o.equals(e.val)) {
                    return e;
                }
                e = e.prev;
            }
        }
        return null;
    }

    public int indexOf(Object o) {
        int idx = 0;
        if (o == null) {
            Entry e = this.head.next;
            while (e != this.head) {
                if (e.val == null) {
                    return idx;
                }
                e = e.next;
                ++idx;
            }
        } else {
            Entry e = this.head.next;
            while (e != this.head) {
                if (o.equals(e.val)) {
                    return idx;
                }
                e = e.next;
                ++idx;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int idx = this.size - 1;
        if (o == null) {
            Entry e = this.head.prev;
            while (e != this.head) {
                if (e.val == null) {
                    return idx;
                }
                e = e.prev;
                --idx;
            }
        } else {
            Entry e = this.head.prev;
            while (e != this.head) {
                if (o.equals(e.val)) {
                    return idx;
                }
                e = e.prev;
                --idx;
            }
        }
        return -1;
    }

    public Object[] toArray() {
        Object[] a = new Object[this.size];
        int i = 0;
        Entry e = this.head.next;
        while (e != this.head) {
            a[i++] = e.val;
            e = e.next;
        }
        return a;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size;
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        Entry e = this.head.next;
        while (e != this.head) {
            a[i++] = e.val;
            e = e.next;
        }
        if (i < a.length) {
            a[i++] = null;
        }
        return a;
    }

    public boolean add(Object o) {
        this.insertBefore(this.head, o);
        return true;
    }

    private void insertAfter(Entry e, Object val) {
        ++this.modCount;
        Entry succ = e.next;
        Entry newe = new Entry(val);
        newe.prev = e;
        newe.next = succ;
        e.next = newe;
        succ.prev = newe;
        ++this.size;
    }

    private void insertBefore(Entry e, Object val) {
        ++this.modCount;
        Entry pred = e.prev;
        Entry newe = new Entry(val);
        newe.prev = pred;
        newe.next = e;
        pred.next = newe;
        e.prev = newe;
        ++this.size;
    }

    private Object remove(Entry e) {
        if (e == this.head) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        Entry succ = e.next;
        Entry pred = e.prev;
        pred.next = succ;
        succ.prev = pred;
        --this.size;
        return e.val;
    }

    public boolean remove(Object o) {
        Entry e = this.findFirst(o);
        if (e == null) {
            return false;
        }
        this.remove(e);
        return true;
    }

    public boolean addAll(Collection c) {
        return this.insertAllBefore(this.head, c);
    }

    public boolean addAll(int index, Collection c) {
        return this.insertAllBefore(index == this.size ? this.head : this.getAt(index), c);
    }

    private boolean insertAllBefore(Entry succ, Collection c) {
        Entry pred;
        Entry first;
        Iterator itr = c.iterator();
        if (!itr.hasNext()) {
            return false;
        }
        ++this.modCount;
        Entry prev = first = new Entry(itr.next());
        Entry curr = first;
        int added = 1;
        while (itr.hasNext()) {
            prev.next = curr = new Entry(itr.next());
            curr.prev = prev;
            prev = curr;
            ++added;
        }
        first.prev = pred = succ.prev;
        curr.next = succ;
        pred.next = first;
        succ.prev = curr;
        this.size += added;
        return true;
    }

    public void clear() {
        ++this.modCount;
        this.head.next = this.head.prev = this.head;
        this.size = 0;
    }

    public Object get(int index) {
        return this.getAt((int)index).val;
    }

    public Object set(int index, Object element) {
        Entry e = this.getAt(index);
        Object old = e.val;
        e.val = element;
        return old;
    }

    public void add(int index, Object element) {
        if (index == this.size) {
            this.insertBefore(this.head, element);
        } else {
            this.insertBefore(index == this.size ? this.head : this.getAt(index), element);
        }
    }

    public Object remove(int index) {
        return this.remove(this.getAt(index));
    }

    public ListIterator listIterator() {
        return new Itr();
    }

    public ListIterator listIterator(int index) {
        return new Itr(index == this.size ? this.head : this.getAt(index), index);
    }

    public void addFirst(Object e) {
        this.insertAfter(this.head, e);
    }

    public void addLast(Object e) {
        this.insertBefore(this.head, e);
    }

    public boolean offerFirst(Object e) {
        this.insertAfter(this.head, e);
        return true;
    }

    public boolean offerLast(Object e) {
        this.insertBefore(this.head, e);
        return true;
    }

    public Object removeFirst() {
        return this.remove(this.head.next);
    }

    public Object removeLast() {
        return this.remove(this.head.prev);
    }

    public Object pollFirst() {
        return this.size == 0 ? null : this.remove(this.head.next);
    }

    public Object pollLast() {
        return this.size == 0 ? null : this.remove(this.head.prev);
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.head.next.val;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.head.prev.val;
    }

    public Object peekFirst() {
        return this.size == 0 ? null : this.head.next.val;
    }

    public Object peekLast() {
        return this.size == 0 ? null : this.head.prev.val;
    }

    public boolean removeFirstOccurrence(Object o) {
        Entry e = this.findFirst(o);
        if (e == null) {
            return false;
        }
        this.remove(e);
        return true;
    }

    public boolean removeLastOccurrence(Object o) {
        Entry e = this.findLast(o);
        if (e == null) {
            return false;
        }
        this.remove(e);
        return true;
    }

    public boolean offer(Object e) {
        return this.add(e);
    }

    public Object remove() {
        return this.removeFirst();
    }

    public Object poll() {
        return this.pollFirst();
    }

    public Object element() {
        return this.getFirst();
    }

    public Object peek() {
        return this.peekFirst();
    }

    public void push(Object e) {
        this.addFirst(e);
    }

    public Object pop() {
        return this.removeFirst();
    }

    public Iterator descendingIterator() {
        return new DescItr();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size);
        Entry e = this.head.next;
        while (e != this.head) {
            out.writeObject(e.val);
            e = e.next;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Entry head;
        in.defaultReadObject();
        int size = in.readInt();
        head.next = head.prev = (head = new Entry(null));
        for (int i = 0; i < size; ++i) {
            this.insertBefore(head, in.readObject());
        }
        this.size = size;
        this.head = head;
    }

    public Object clone() {
        Entry head;
        LinkedList clone = null;
        try {
            clone = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        head.next = head.prev = (head = new Entry(null));
        clone.head = head;
        clone.addAll((Collection)this);
        return clone;
    }

    private class DescItr
    implements ListIterator {
        int expectedModCount;
        int idx;
        Entry cursor;
        Entry lastRet;

        DescItr(Entry cursor, int idx) {
            this.cursor = cursor;
            this.idx = idx;
            this.expectedModCount = LinkedList.this.modCount;
        }

        DescItr() {
            this(((LinkedList)linkedList).head.prev, 0);
        }

        public boolean hasNext() {
            return this.cursor != LinkedList.this.head;
        }

        public int nextIndex() {
            return this.idx;
        }

        public boolean hasPrevious() {
            return this.cursor.next != LinkedList.this.head;
        }

        public int previousIndex() {
            return this.idx - 1;
        }

        public Object next() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor == LinkedList.this.head) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor.prev;
            ++this.idx;
            return this.lastRet.val;
        }

        public Object previous() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor.next == LinkedList.this.head) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor = this.cursor.next;
            --this.idx;
            return this.lastRet;
        }

        public void add(Object val) {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            LinkedList.this.insertAfter(this.cursor, val);
            this.lastRet = null;
            ++this.idx;
            ++this.expectedModCount;
        }

        public void set(Object newVal) {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.lastRet.val = newVal;
        }

        public void remove() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet.next == this.cursor) {
                --this.idx;
            } else {
                this.cursor = this.lastRet.next;
            }
            LinkedList.this.remove(this.lastRet);
            this.lastRet = null;
            ++this.expectedModCount;
        }
    }

    private class Itr
    implements ListIterator {
        int expectedModCount;
        int idx;
        Entry cursor;
        Entry lastRet;

        Itr(Entry cursor, int idx) {
            this.cursor = cursor;
            this.idx = idx;
            this.expectedModCount = LinkedList.this.modCount;
        }

        Itr() {
            this(((LinkedList)linkedList).head.next, 0);
        }

        public boolean hasNext() {
            return this.cursor != LinkedList.this.head;
        }

        public int nextIndex() {
            return this.idx;
        }

        public boolean hasPrevious() {
            return this.cursor.prev != LinkedList.this.head;
        }

        public int previousIndex() {
            return this.idx - 1;
        }

        public Object next() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor == LinkedList.this.head) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor.next;
            ++this.idx;
            return this.lastRet.val;
        }

        public Object previous() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor.prev == LinkedList.this.head) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor = this.cursor.prev;
            --this.idx;
            return this.lastRet.val;
        }

        public void add(Object val) {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            LinkedList.this.insertBefore(this.cursor, val);
            this.lastRet = null;
            ++this.idx;
            ++this.expectedModCount;
        }

        public void set(Object newVal) {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.lastRet.val = newVal;
        }

        public void remove() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet.next == this.cursor) {
                --this.idx;
            } else {
                this.cursor = this.lastRet.next;
            }
            LinkedList.this.remove(this.lastRet);
            this.lastRet = null;
            ++this.expectedModCount;
        }
    }

    private static class Entry {
        Entry prev;
        Entry next;
        Object val;

        Entry(Object val) {
            this.val = val;
        }
    }
}

