/*
 * Decompiled with CFR 0.152.
 */
package delete;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.utils.om.OMUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.util.PolicyComparator;
import org.w3c.dom.Element;

public class PolicyConverter {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyConverter.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");

    public static Policy getPolicy(Element element, QName qname) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPolicy", new Object[]{element, qname});
        }
        String namespacePrefix = null;
        if (qname != null) {
            namespacePrefix = qname.getPrefix();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicy");
        }
        return PolicyConverter.deriveNeethiPolicy(element, qname, namespacePrefix);
    }

    public static Policy getPolicy(com.ibm.ws.wspolicy.Policy policy) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPolicy", policy);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicy");
        }
        return PolicyConverter.deriveNeethiPolicy(policy);
    }

    public static Policy getPolicy(InputStream is) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPolicy", is);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicy");
        }
        return PolicyConverter.deriveNeethiPolicy(is);
    }

    private static Policy deriveNeethiPolicy(Element element, QName qname, String namespace) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deriveNeethiPolicy", new Object[]{element, qname, namespace});
        }
        if (element != null && qname != null && namespace != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "deriveNeethiPolicy");
            }
            return PolicyEngine.getPolicy(OMUtils.toOM(element, qname, namespace));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deriveNeethiPolicy", null);
        }
        return null;
    }

    private static Policy deriveNeethiPolicy(com.ibm.ws.wspolicy.Policy policy) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deriveNeethiPolicy", new Object[]{policy});
        }
        if (policy != null) {
            String policyStr = policy.toString();
            ByteArrayInputStream bstream = new ByteArrayInputStream(policyStr.getBytes());
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "deriveNeethiPolicy");
            }
            return PolicyEngine.getPolicy(bstream);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deriveNeethiPolicy", null);
        }
        return null;
    }

    private static Policy deriveNeethiPolicy(InputStream is) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "deriveNeethiPolicy", new Object[]{is});
        }
        if (is != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "deriveNeethiPolicy");
            }
            return PolicyEngine.getPolicy(is);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "deriveNeethiPolicy", null);
        }
        return null;
    }

    public static boolean compare(Policy policy1, Policy policy2) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "compare", new Object[]{policy1, policy2});
        }
        if (policy1 != null && policy2 != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "compare");
            }
            return PolicyComparator.compare(policy1, policy2);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "compare", Boolean.FALSE);
        }
        return false;
    }
}

