/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.SymbolMap;
import java.io.UnsupportedEncodingException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class Symbol {
    public final String str;
    private final SymbolMap map;
    public final int nameStart;
    public final int nameEnd;
    private String prefix;
    private String localName;
    public int hitCount;

    public Symbol(String string, SymbolMap symbolMap, int n, int n2) {
        this.str = string;
        this.map = symbolMap;
        this.nameStart = n;
        this.nameEnd = n2;
        this.prefix = null;
        this.localName = this.str;
    }

    public Symbol(Symbol symbol, SymbolMap symbolMap, int n, int n2) {
        this.str = symbol.str;
        this.map = symbolMap;
        this.nameStart = n;
        this.nameEnd = n2;
        this.prefix = symbol.prefix;
        this.localName = symbol.localName;
    }

    public String toString() {
        try {
            return new String(this.map.fSymbolBytes, this.nameStart, this.nameEnd - this.nameStart, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public boolean equalsString(String string) {
        return this.str.equals(string);
    }

    public void setQNameValues(QName qName) {
        qName.rawName = this.str;
        qName.nsURI = "";
        qName.localName = this.localName;
        qName.prefix = this.prefix;
    }

    boolean setValuesIfKnownQName(QName qName) {
        if (this.prefix != null) {
            qName.rawName = this.str;
            qName.nsURI = "";
            qName.localName = this.localName;
            qName.prefix = this.prefix;
            return true;
        }
        return false;
    }

    void setQNameValues(QName qName, int n) {
        if (n == 0) {
            this.prefix = "";
        } else if (this.prefix == null) {
            this.prefix = this.map.addSymbolSubstring((int)this.nameStart, (int)(this.nameStart + n)).str;
            this.localName = this.map.addSymbolSubstring((int)(this.nameStart + n + 1), (int)this.nameEnd).str;
        }
        qName.rawName = this.str;
        qName.nsURI = "";
        qName.localName = this.localName;
        qName.prefix = this.prefix;
    }

    public boolean skippedMatchingQName(ParsedEntity parsedEntity, QName qName) {
        return parsedEntity.skippedBytesInRangeForXMLString(this.map.fSymbolBytes, this.nameStart, this.nameEnd, qName);
    }
}

