/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.scan.util;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.DocumentScanner;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp2.scan.util.DataSource;
import com.ibm.xml.xlxp2.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp2.scan.util.UTF8Support;
import com.ibm.xml.xlxp2.scan.util.UntestedCode;
import com.ibm.xml.xlxp2.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp2.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ParsedEntity {
    public String baseURI;
    public DataBuffer buffer;
    public byte[] bytes;
    public int offset;
    public int endOffset;
    public int startOffset;
    public int id;
    public boolean lineBreaksNormalized;
    public CharConversionError error;
    public boolean isXML10 = true;
    public boolean isInternal;
    public boolean isCoordinatesAware;
    public boolean loadCalled;
    public ParsedEntity parent;
    private final ParsedEntityFactory fEntityFactory;
    private final DataBufferReferrer fBufferReferrer;
    private final int[] fIntPointer;
    private DataSource fSource;
    protected DataBuffer fContentLastBuffer;
    private int fContentEndOffset;
    private boolean fEndOfEntity;
    protected Mark fMarks;
    private Mark fFreeMarks;
    private DataBufferFactory fBufferFactory;
    private static final byte[] contentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] normalizedContentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    protected static final byte[] attValueMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};

    public ParsedEntity(ParsedEntityFactory parsedEntityFactory) {
        this.fEntityFactory = parsedEntityFactory;
        this.fIntPointer = ArrayAllocator.newIntArray(2);
        this.fBufferReferrer = new DataBufferReferrer(){

            public boolean hasReferenceTo(DataBuffer dataBuffer) {
                Object object;
                if (ParsedEntity.this.buffer == dataBuffer) {
                    return true;
                }
                if (ParsedEntity.this.buffer.next != null) {
                    object = ParsedEntity.this.buffer.next;
                    while (object != null) {
                        if (object == dataBuffer) {
                            return true;
                        }
                        object = ((DataBuffer)object).next;
                    }
                }
                if (ParsedEntity.this.fContentLastBuffer == dataBuffer) {
                    return true;
                }
                if (ParsedEntity.this.fMarks != null) {
                    object = ParsedEntity.this.fMarks;
                    while (object != null) {
                        if (((Mark)object).markBuffer == dataBuffer) {
                            return true;
                        }
                        object = ((Mark)object).markNext;
                    }
                    return false;
                }
                return false;
            }

            public void removeReferencesAndUnregister() {
                ParsedEntity.this.clear();
            }
        };
    }

    public ParsedEntity(ParsedEntity parsedEntity) {
        this(parsedEntity.fEntityFactory);
        this.initializeFrom(parsedEntity);
    }

    public void initializeFrom(ParsedEntity parsedEntity) {
        this.baseURI = parsedEntity.baseURI;
        this.buffer = parsedEntity.buffer;
        this.bytes = parsedEntity.bytes;
        this.offset = parsedEntity.offset;
        this.endOffset = parsedEntity.endOffset;
        this.startOffset = parsedEntity.startOffset;
        this.id = parsedEntity.id;
        this.lineBreaksNormalized = parsedEntity.lineBreaksNormalized;
        this.error = null;
        this.isXML10 = parsedEntity.isXML10;
        this.isInternal = parsedEntity.isInternal;
        this.isCoordinatesAware = parsedEntity.isCoordinatesAware;
        this.loadCalled = parsedEntity.loadCalled;
        this.parent = parsedEntity.parent;
        this.fIntPointer[0] = parsedEntity.fIntPointer[0];
        this.fIntPointer[1] = parsedEntity.fIntPointer[1];
        this.fSource = parsedEntity.fSource;
        this.fContentLastBuffer = parsedEntity.fContentLastBuffer;
        this.fContentEndOffset = parsedEntity.fContentEndOffset;
        this.fEndOfEntity = parsedEntity.fEndOfEntity;
        this.setBufferFactory(parsedEntity.fBufferFactory);
    }

    public void setBufferFactory(DataBufferFactory dataBufferFactory) {
        if (dataBufferFactory != this.fBufferFactory) {
            if (this.fBufferFactory != null) {
                this.fBufferFactory.removeReferrer(this.fBufferReferrer);
            }
            dataBufferFactory.addReferrer(this.fBufferReferrer);
            this.fBufferFactory = dataBufferFactory;
        }
    }

    public String toString() {
        XMLString xMLString = new XMLString();
        xMLString.setValues(this.buffer, this.startOffset, this.offset);
        String string = xMLString.toString();
        xMLString.setValues(this.buffer, this.offset, this.endOffset);
        string = string + "<&&&>" + xMLString.toString();
        xMLString.unregister();
        return string;
    }

    public void clear() {
        this.baseURI = null;
        this.bytes = null;
        this.startOffset = 0;
        this.lineBreaksNormalized = false;
        this.error = null;
        this.isXML10 = true;
        this.isInternal = false;
        this.loadCalled = false;
        this.parent = null;
        if (this.fSource != null) {
            this.fSource.release();
            this.fSource = null;
        }
        this.buffer = null;
        if (this.fMarks != null) {
            if (this.fFreeMarks != null) {
                Mark mark = this.fMarks;
                while (mark.markNext != null) {
                    mark = mark.markNext;
                }
                mark.markNext = this.fFreeMarks;
            }
            this.fFreeMarks = this.fMarks;
            this.fMarks = null;
        }
        this.fContentLastBuffer = null;
        this.fEndOfEntity = false;
        this.fBufferReferrer.active = false;
        if (this.fBufferFactory != null) {
            this.fBufferFactory.removeReferrer(this.fBufferReferrer);
            this.fBufferFactory = null;
        }
    }

    public int loadMore() {
        this.loadCalled = true;
        do {
            if (this.buffer.next == null) {
                if (this.fSource != null) {
                    this.error = this.fSource.load(this);
                    if (this.error != null) {
                        return 0;
                    }
                    this.fEndOfEntity = false;
                    continue;
                }
                this.fEndOfEntity = true;
                continue;
            }
            if (this.buffer != this.fContentLastBuffer) {
                this.advanceBuffer();
                this.offset = this.startOffset;
                this.fEndOfEntity = false;
                continue;
            }
            this.fEndOfEntity = true;
        } while (this.bytes[this.offset] == 0 && !this.fEndOfEntity);
        return this.bytes[this.offset];
    }

    public void setValues(DataBuffer dataBuffer, int n, int n2, DataSource dataSource) {
        if (this.buffer != null) {
            this.buffer.next = dataBuffer;
        }
        this.buffer = dataBuffer;
        this.bytes = dataBuffer.bytes;
        this.offset = n;
        this.endOffset = n2;
        this.startOffset = n;
        this.fSource = dataSource;
        this.fEndOfEntity = false;
        this.fBufferReferrer.active = true;
    }

    public void setContent(XMLString xMLString) {
        this.buffer = xMLString.firstBuffer;
        this.bytes = this.buffer.bytes;
        this.startOffset = this.offset = xMLString.startOffset;
        if (xMLString.bytes != null) {
            this.endOffset = xMLString.endOffset;
            this.fContentLastBuffer = this.buffer;
            this.fContentEndOffset = this.endOffset;
        } else {
            this.fContentLastBuffer = xMLString.lastBuffer;
            this.fContentEndOffset = xMLString.endOffset;
            this.endOffset = this.buffer.endOffset;
        }
        this.fSource = null;
        this.fBufferReferrer.active = true;
    }

    public void release() {
        this.clear();
        this.fEntityFactory.releaseParsedEntity(this);
    }

    private void pushMark(Mark mark) {
        mark.markNext = this.fMarks;
        this.fMarks = mark;
    }

    private Mark popMark() {
        Mark mark = this.fMarks;
        this.fMarks = mark.markNext;
        return mark;
    }

    public void setMark() {
        Mark mark = this.fFreeMarks;
        if (mark != null) {
            this.fFreeMarks = mark.markNext;
            mark.markNext = null;
        } else {
            mark = new Mark();
        }
        mark.markBuffer = this.buffer;
        mark.markOffset = this.offset;
        mark.markStartOffset = this.startOffset;
        mark.markEndOffset = this.endOffset;
        this.pushMark(mark);
    }

    public void clearMark() {
        Mark mark = this.popMark();
        mark.markBuffer = null;
        mark.markNext = this.fFreeMarks;
        this.fFreeMarks = mark;
    }

    public void resetToMark() {
        Mark mark = this.popMark();
        if (this.buffer != mark.markBuffer) {
            this.buffer = mark.markBuffer;
            this.bytes = this.buffer.bytes;
        }
        mark.markBuffer = null;
        this.offset = mark.markOffset;
        this.startOffset = mark.markStartOffset;
        this.endOffset = mark.markEndOffset;
        mark.markNext = this.fFreeMarks;
        this.fFreeMarks = mark;
    }

    public DataBuffer previousBuffer(DataBuffer dataBuffer) {
        Mark mark = this.fMarks;
        while (mark != null) {
            DataBuffer dataBuffer2 = mark.markBuffer;
            if (dataBuffer2 != dataBuffer) {
                while (dataBuffer2.next != null) {
                    if (dataBuffer2.next == dataBuffer) {
                        return dataBuffer2;
                    }
                    dataBuffer2 = dataBuffer2.next;
                }
            }
            mark = mark.markNext;
        }
        return null;
    }

    private void advanceBuffer() {
        this.buffer = this.buffer.next;
        this.bytes = this.buffer.bytes;
        this.startOffset = this.buffer.startOffset;
        this.endOffset = this.buffer == this.fContentLastBuffer ? this.fContentEndOffset : this.buffer.endOffset;
    }

    public int advanceOffset(int n) {
        this.offset += n;
        if (this.offset > this.endOffset) {
            n = this.offset - this.endOffset;
            this.advanceBuffer();
            this.offset = this.startOffset + n;
        }
        return this.offset;
    }

    public boolean skippedValidCharacter() {
        if (this.offset < this.endOffset || this.fSource != null) {
            if (UTF8Support.decodeCharacter(this, this.fIntPointer)) {
                boolean bl;
                boolean bl2 = bl = this.isXML10 ? XMLCharacterProperties.validChar10(this.fIntPointer[0]) : XMLCharacterProperties.validChar11(this.fIntPointer[0], this.isInternal);
                if (bl) {
                    this.offset += this.fIntPointer[1];
                    if (this.offset > this.endOffset) {
                        int n = this.offset - this.endOffset;
                        this.advanceBuffer();
                        this.offset = this.startOffset + n;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean skippedNameStartCharacter() {
        if (UTF8Support.decodeCharacter(this, this.fIntPointer)) {
            boolean bl;
            boolean bl2 = bl = this.isXML10 ? XMLCharacterProperties.nameStartChar10(this.fIntPointer[0]) : XMLCharacterProperties.nameStartChar11(this.fIntPointer[0]);
            if (bl) {
                this.offset += this.fIntPointer[1];
                if (this.offset > this.endOffset) {
                    int n = this.offset - this.endOffset;
                    this.advanceBuffer();
                    this.offset = this.startOffset + n;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean skippedNameCharacter() {
        if (UTF8Support.decodeCharacter(this, this.fIntPointer)) {
            boolean bl;
            boolean bl2 = bl = this.isXML10 ? XMLCharacterProperties.nameChar10(this.fIntPointer[0]) : XMLCharacterProperties.nameChar11(this.fIntPointer[0]);
            if (bl) {
                this.offset += this.fIntPointer[1];
                if (this.offset > this.endOffset) {
                    int n = this.offset - this.endOffset;
                    this.advanceBuffer();
                    this.offset = this.startOffset + n;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean skippedXML11EOLCharacter() {
        if ((this.bytes[this.offset] & 0xDF) == 194) {
            return this.skippedXML11EOLCharacterInternal();
        }
        return false;
    }

    private boolean skippedXML11EOLCharacterInternal() {
        if (UTF8Support.decodeCharacter(this, this.fIntPointer)) {
            if (this.fIntPointer[0] == 133 || this.fIntPointer[0] == 8232) {
                this.offset += this.fIntPointer[1];
                if (this.offset > this.endOffset) {
                    int n = this.offset - this.endOffset;
                    this.advanceBuffer();
                    this.offset = this.startOffset + n;
                }
                return true;
            }
            return false;
        }
        UntestedCode.needTest("unknown(60)");
        return false;
    }

    public int decodeCharacter() {
        if (UTF8Support.decodeCharacter(this, this.fIntPointer)) {
            return this.fIntPointer[0];
        }
        return -1;
    }

    public boolean loadNextBuffer(int n) {
        this.offset = n;
        if (this.offset == this.endOffset) {
            this.loadMore();
        }
        return !this.fEndOfEntity && this.error == null;
    }

    public boolean atEndOfEntity() {
        return this.fEndOfEntity || this.offset == this.endOffset && (this.fEndOfEntity = this.loadMore() == 0);
    }

    public int checkForMarkup() {
        if (this.bytes[this.offset] != 60) {
            return 0;
        }
        return DocumentScanner.markupMap[this.bytes[this.offset + 1] & 0xFF];
    }

    public boolean lookingAt(int n) {
        return this.bytes[this.offset] == n;
    }

    public int currentByte() {
        return this.bytes[this.offset] & 0xFF;
    }

    public int peekByte() {
        int n = this.bytes[this.offset + 1];
        if (n != 0 || this.offset + 1 < this.endOffset) {
            return n & 0xFF;
        }
        this.setMark();
        n = this.bytes[++this.offset];
        if (n == 0 && this.offset == this.endOffset) {
            n = this.loadMore();
        }
        this.resetToMark();
        return n & 0xFF;
    }

    public void nextByte() {
        if (++this.offset == this.endOffset) {
            this.loadMore();
        }
    }

    public void skipTwoBytes() {
        this.offset += 2;
        if (this.offset >= this.endOffset) {
            int n = this.offset - this.endOffset;
            if (this.loadMore() != 0) {
                this.offset = this.startOffset + n;
            }
        }
    }

    public boolean skippedByte(int n) {
        if (this.bytes[this.offset] == n) {
            if (++this.offset == this.endOffset) {
                this.loadMore();
            }
            return true;
        }
        return false;
    }

    public int skippedQuote() {
        byte by = this.bytes[this.offset];
        if (by == 34 || by == 39) {
            if (++this.offset == this.endOffset) {
                this.loadMore();
            }
            return by;
        }
        return 0;
    }

    public boolean skippedBytes(byte[] byArray) {
        return this.skippedBytesInRange(byArray, 0, byArray.length);
    }

    public boolean skippedBytesMatchingXMLString(XMLString xMLString) {
        if (xMLString.bytes != null) {
            return this.skippedBytesInRange(xMLString.bytes, xMLString.startOffset, xMLString.endOffset);
        }
        return this.skippedBytes2(xMLString.firstBuffer, xMLString.lastBuffer, xMLString.startOffset, xMLString.endOffset);
    }

    public boolean skippedBytesInRangeForXMLString(byte[] byArray, int n, int n2, XMLString xMLString) {
        if (this.bytes[this.offset] == byArray[n]) {
            if (this.offset + (n2 - n) <= this.endOffset) {
                int n3 = this.offset;
                while (++n < n2 && this.bytes[++this.offset] == byArray[n] && ++n < n2 && this.bytes[++this.offset] == byArray[n] && ++n < n2 && this.bytes[++this.offset] == byArray[n]) {
                }
                if (n == n2) {
                    if (++this.offset < this.endOffset) {
                        xMLString.setValues(this.buffer, n3, this.offset);
                        return true;
                    }
                    xMLString.setValues(this.buffer, n3, this.offset);
                    this.loadMore();
                    return true;
                }
                this.offset = n3;
                return false;
            }
            xMLString.setStartPos(this.buffer, this.offset);
            if (!this.skippedBytesAcrossBuffers(byArray, n, n2)) {
                return false;
            }
            xMLString.setEndPos(this.buffer, this.offset);
            return true;
        }
        if (this.offset == this.endOffset && this.loadMore() != 0) {
            return this.skippedBytesInRangeForXMLString(byArray, n, n2, xMLString);
        }
        return false;
    }

    public boolean skippedBytesInRange(byte[] byArray, int n, int n2) {
        if (this.bytes[this.offset] == byArray[n]) {
            if (this.offset + (n2 - n) <= this.endOffset) {
                int n3 = this.offset;
                while (++n < n2 && this.bytes[++this.offset] == byArray[n] && ++n < n2 && this.bytes[++this.offset] == byArray[n] && ++n < n2 && this.bytes[++this.offset] == byArray[n]) {
                }
                if (n == n2) {
                    if (++this.offset < this.endOffset) {
                        return true;
                    }
                    this.loadMore();
                    return true;
                }
                this.offset = n3;
                return false;
            }
            return this.skippedBytesAcrossBuffers(byArray, n, n2);
        }
        if (this.offset == this.endOffset && this.loadMore() != 0) {
            return this.skippedBytesInRange(byArray, n, n2);
        }
        return false;
    }

    private boolean skippedBytesAcrossBuffers(byte[] byArray, int n, int n2) {
        boolean bl = false;
        int n3 = this.offset++;
        int n4 = this.bytes[this.offset];
        int n5 = n + 1;
        while (n5 < n2) {
            if (n4 == byArray[n5]) {
                ++n5;
                n4 = this.bytes[++this.offset];
                continue;
            }
            if (n4 != 0 || this.offset < this.endOffset) {
                if (bl) {
                    this.resetToMark();
                } else {
                    this.offset = n3;
                }
                return false;
            }
            if (!bl) {
                this.offset = n3;
                this.setMark();
                bl = true;
            }
            if ((n4 = this.loadMore()) != 0) continue;
            this.resetToMark();
            return false;
        }
        if (bl) {
            this.clearMark();
        }
        if (n4 == 0 && this.offset == this.endOffset) {
            this.loadMore();
        }
        return true;
    }

    private boolean skippedBytes2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2) {
        DataBuffer dataBuffer3 = dataBuffer;
        byte[] byArray = dataBuffer3.bytes;
        int n3 = dataBuffer3.endOffset;
        if (this.bytes[this.offset] == byArray[n]) {
            int n4;
            boolean bl;
            block11: {
                bl = false;
                int n5 = this.offset++;
                n4 = this.bytes[this.offset];
                ++n;
                while (true) {
                    if (n == n3) {
                        if (dataBuffer3 == dataBuffer2) break block11;
                        dataBuffer3 = dataBuffer3.next;
                        byArray = dataBuffer3.bytes;
                        n = dataBuffer3.startOffset;
                        int n6 = n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                    }
                    if (n4 == byArray[n]) {
                        ++n;
                        n4 = this.bytes[++this.offset];
                        continue;
                    }
                    if (n4 != 0 || this.offset < this.endOffset) {
                        if (bl) {
                            this.resetToMark();
                        } else {
                            this.offset = n5;
                        }
                        return false;
                    }
                    if (!bl) {
                        this.offset = n5;
                        this.setMark();
                        bl = true;
                    }
                    if ((n4 = this.loadMore()) == 0) break;
                }
                this.resetToMark();
                return false;
            }
            if (bl) {
                this.clearMark();
            }
            if (n4 == 0 && this.offset == this.endOffset) {
                this.loadMore();
            }
            return true;
        }
        if (this.offset == this.endOffset && this.loadMore() != 0) {
            return this.skippedBytes2(dataBuffer, dataBuffer2, n, n2);
        }
        return false;
    }

    public boolean skippedSpace() {
        byte by = this.bytes[this.offset];
        if (by == 32 || by == 10 || by == 9 || by == 13) {
            if (++this.offset == this.endOffset) {
                this.loadMore();
            }
            return true;
        }
        return !this.isXML10 && (by & 0xDF) == 194 && this.skippedXML11EOLCharacterInternal();
    }

    public int skipSpaces() {
        byte by;
        while (true) {
            if ((by = this.bytes[this.offset]) == 32 || by == 10 || by == 9 || by == 13) {
                if (++this.offset != this.endOffset) continue;
                this.loadMore();
                continue;
            }
            if (this.isXML10 || (by & 0xDF) != 194 || !this.skippedXML11EOLCharacterInternal()) break;
        }
        return by;
    }

    public void skipASCIISpaces() {
        byte by;
        while ((by = this.bytes[this.offset]) == 32 || by == 10 || by == 9 || by == 13) {
            if (++this.offset != this.endOffset) continue;
            this.loadMore();
        }
    }

    public boolean skippedSpaces() {
        int n = this.bytes[this.offset];
        if (n == 32 || n == 10 || n == 9 || n == 13) {
            do {
                if ((n = this.bytes[++this.offset]) != 0 || this.offset != this.endOffset) continue;
                n = this.loadMore();
            } while (n == 32 || n == 10 || n == 9 || n == 13);
            if (!this.isXML10 && (n & 0xDF) == 194 && this.skippedXML11EOLCharacterInternal()) {
                this.skipSpaces();
            }
            return true;
        }
        if (!this.isXML10 && (n & 0xDF) == 194 && this.skippedXML11EOLCharacterInternal()) {
            this.skipSpaces();
            return true;
        }
        return false;
    }

    public boolean skipToChar(int n) {
        int n2 = this.bytes[this.offset];
        while (n2 != n) {
            if ((n2 = this.bytes[++this.offset]) != 0 || this.offset >= this.endOffset && (n2 = this.loadMore()) != 0) continue;
            return false;
        }
        return true;
    }

    public int skipValidXMLBytesUsingMapForXMLString(byte[] byArray, int n, XMLString xMLString) {
        if (byArray[this.bytes[this.offset] & 0xFF] == n) {
            while (byArray[this.bytes[++this.offset] & 0xFF] == n) {
            }
        }
        if (this.bytes[this.offset] >= 32) {
            return byArray[this.bytes[this.offset]];
        }
        if (this.bytes[this.offset] == 0 && (this.offset < this.endOffset || this.loadMore() == 0)) {
            return byArray[0];
        }
        if (!this.lineBreaksNormalized) {
            return this.skipMoreValidXMLBytesUsingMapForXMLString(byArray, n, xMLString);
        }
        return this.skipMoreValidXMLBytesUsingMap(byArray, n);
    }

    private int skipMoreValidXMLBytesUsingMapForXMLString(byte[] byArray, int n, XMLString xMLString) {
        byte by = this.bytes[this.offset];
        if (byArray[by & 0xFF] == n) {
            ++this.offset;
        } else if (by == 13) {
            xMLString.flags |= 4;
            ++this.offset;
        } else {
            if (by > 0) {
                return byArray[by];
            }
            if (!this.isXML10 && (by & 0xDF) == 194 && this.skippedXML11EOLCharacterInternal()) {
                xMLString.flags |= 8;
            } else if (!this.skippedValidCharacter()) {
                return byArray[by & 0xFF];
            }
        }
        while (true) {
            if (byArray[this.bytes[this.offset] & 0xFF] == n) {
                ++this.offset;
                continue;
            }
            by = this.bytes[this.offset];
            if (by > 0) {
                if (by != 13) {
                    return byArray[by];
                }
                xMLString.flags |= 4;
                ++this.offset;
                continue;
            }
            if (by < 0) {
                if (!this.isXML10 && (by & 0xDF) == 194 && this.skippedXML11EOLCharacterInternal()) {
                    xMLString.flags |= 8;
                    continue;
                }
                if (this.skippedValidCharacter()) continue;
                return byArray[by & 0xFF];
            }
            if (this.offset < this.endOffset || this.loadMore() == 0) break;
        }
        return byArray[0];
    }

    private int skipMoreValidXMLBytesUsingMap(byte[] byArray, int n) {
        byte by = this.bytes[this.offset];
        if (byArray[by & 0xFF] == n) {
            ++this.offset;
        } else if (by == 13) {
            ++this.offset;
        } else {
            if (by > 0) {
                return byArray[by];
            }
            if (!this.skippedValidCharacter()) {
                return byArray[by & 0xFF];
            }
        }
        while (true) {
            if (byArray[this.bytes[this.offset] & 0xFF] == n) {
                ++this.offset;
                continue;
            }
            by = this.bytes[this.offset];
            if (by > 0) {
                if (by != 13) {
                    return byArray[by];
                }
                ++this.offset;
                continue;
            }
            if (by < 0) {
                if (this.skippedValidCharacter()) continue;
                return byArray[by & 0xFF];
            }
            if (this.offset < this.endOffset || this.loadMore() == 0) break;
        }
        return byArray[0];
    }

    public int skipBytesWithinBufferUsingMapForXMLString(byte[] byArray, int n, XMLString xMLString) {
        int n2 = 0;
        while (byArray[this.bytes[this.offset] & 0xFF] == n) {
            n2 = n2 * 31 + this.bytes[this.offset++];
        }
        xMLString.hashcode = n2;
        return byArray[this.bytes[this.offset] & 0xFF];
    }

    public int skipBytesWithinBufferUsingMap(byte[] byArray, int n) {
        while (byArray[this.bytes[this.offset] & 0xFF] == n) {
            ++this.offset;
        }
        return byArray[this.bytes[this.offset] & 0xFF];
    }

    public int skipBytesUsingMap(byte[] byArray, int n) {
        while (true) {
            if (byArray[this.bytes[this.offset] & 0xFF] == n) {
                ++this.offset;
                continue;
            }
            if (this.bytes[this.offset] != 0 || this.offset != this.endOffset || this.loadMore() == 0) break;
        }
        return byArray[this.bytes[this.offset] & 0xFF];
    }

    public void startString(XMLString xMLString) {
        xMLString.setStartPos(this.buffer, this.offset);
    }

    public void endString(XMLString xMLString) {
        xMLString.setEndPos(this.buffer, this.offset);
    }

    public void endStringAtMark(XMLString xMLString) {
        Mark mark = this.popMark();
        xMLString.setEndPos(mark.markBuffer, mark.markOffset);
        mark.markBuffer = null;
        mark.markNext = this.fFreeMarks;
        this.fFreeMarks = mark;
    }

    public int scanSimpleContent(XMLString xMLString) {
        byte by;
        int n;
        int n2;
        byte[] byArray;
        block27: {
            byArray = this.bytes;
            n2 = this.offset;
            n = 0;
            if (!this.lineBreaksNormalized) {
                while (true) {
                    if (contentMap[byArray[n2] & 0xFF] == 1) {
                        ++n2;
                        continue;
                    }
                    by = byArray[n2];
                    if (by == 60) {
                        if (n2 > this.offset) {
                            xMLString.setValues(this.buffer, this.offset, n2);
                            xMLString.flags = n;
                            this.offset = n2;
                            switch (DocumentScanner.markupMap[byArray[n2 + 1] & 0xFF]) {
                                case 1: {
                                    return 0;
                                }
                                case 2: {
                                    return 1;
                                }
                            }
                            return 2;
                        }
                        switch (DocumentScanner.markupMap[byArray[n2 + 1] & 0xFF]) {
                            case 1: {
                                return 3;
                            }
                            case 2: {
                                return 4;
                            }
                        }
                        return 5;
                    }
                    if (by != 13) break;
                    ++n2;
                    n |= 4;
                    if (!this.isXML10) {
                        if ((byArray[n2] & 0xFF) != 194 || (byArray[n2 + 1] & 0xFF) != 133) continue;
                        n |= 8;
                        n2 += 2;
                        continue;
                    }
                    break block27;
                    break;
                }
                if (byArray[n2] != 0 || n2 < this.endOffset) {
                    return -1;
                }
                return this.scanSimpleContentAcrossBuffers(xMLString, n, contentMap);
            }
        }
        while (normalizedContentMap[byArray[n2] & 0xFF] == 1) {
            ++n2;
        }
        by = byArray[n2];
        if (by == 60) {
            if (n2 > this.offset) {
                xMLString.setValues(this.buffer, this.offset, n2);
                xMLString.flags = n;
                this.offset = n2;
                switch (DocumentScanner.markupMap[byArray[n2 + 1] & 0xFF]) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                }
                return 2;
            }
            switch (DocumentScanner.markupMap[byArray[n2 + 1] & 0xFF]) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
            }
            return 5;
        }
        if (byArray[n2] != 0 || n2 < this.endOffset) {
            return -1;
        }
        return this.scanSimpleContentAcrossBuffers(xMLString, n, normalizedContentMap);
    }

    private int scanSimpleContentAcrossBuffers(XMLString xMLString, int n, byte[] byArray) {
        int n2;
        xMLString.setStartPos(this.buffer, this.offset);
        xMLString.flags = n;
        this.setMark();
        if (this.loadMore() != 0 && (n2 = !this.lineBreaksNormalized ? this.skipMoreValidXMLBytesUsingMapForXMLString(byArray, 1, xMLString) : this.skipMoreValidXMLBytesUsingMap(byArray, 1)) == 2) {
            xMLString.setEndPos(this.buffer, this.offset);
            if (xMLString.length > 0) {
                this.clearMark();
                switch (DocumentScanner.markupMap[this.bytes[this.offset + 1] & 0xFF]) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                }
                return 2;
            }
            xMLString.clear();
            this.resetToMark();
            switch (DocumentScanner.markupMap[this.bytes[this.offset + 1] & 0xFF]) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
            }
            return 5;
        }
        xMLString.clear();
        this.resetToMark();
        return -1;
    }

    public int scanSimpleAttValue(XMLString xMLString, int n, int n2) {
        int n3 = this.offset;
        int n4 = this.skipBytesWithinBufferUsingMap(attValueMap, 1);
        if (n4 == 2 && this.lookingAt(n)) {
            if (n3 < this.offset) {
                xMLString.setValues(this.buffer, n3, this.offset);
                return 0;
            }
            return 1;
        }
        this.startString(xMLString);
        xMLString.startOffset = n3;
        return -1;
    }

    public int scanSimpleNamespaceURI(XMLString xMLString, int n, int n2) {
        int n3 = this.offset;
        int n4 = this.skipBytesWithinBufferUsingMapForXMLString(attValueMap, 1, xMLString);
        if (n4 == 2 && this.lookingAt(n)) {
            if (n3 < this.offset) {
                int n5 = xMLString.hashcode;
                xMLString.setValues(this.buffer, n3, this.offset);
                xMLString.hashcode = n5;
                return 0;
            }
            return 1;
        }
        this.startString(xMLString);
        xMLString.startOffset = n3;
        return -1;
    }

    private class Mark {
        DataBuffer markBuffer;
        int markOffset;
        int markStartOffset;
        int markEndOffset;
        Mark markNext;

        private Mark() {
        }
    }
}

