/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.unmarshal.impl;

import com.ibm.xml.xlxp2.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp2.grammar.Grammar;
import com.ibm.xml.xlxp2.jaxb.msg.JAXBMessageProvider;
import com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationContext;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.msg.MessageProvider;
import com.ibm.xml.xlxp2.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.SimpleDataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.SymbolMapHolder;
import com.ibm.xml.xlxp2.scan.util.SymbolTable;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.InputStream;
import javax.xml.bind.UnmarshalException;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class JAXBDocumentScanner
extends VMContext {
    private final SAX2ParsedEntityFactory fEntityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory);
    private final DeserializationContext fDeserContext;
    private int fMatchingEndElementDepth = -1;
    private boolean fNeedReset;

    public JAXBDocumentScanner(DeserializationContext deserializationContext, Grammar grammar, SymbolMapHolder symbolMapHolder) {
        super(new SimpleDataBufferFactory(), new SymbolTable(symbolMapHolder), false, true, false, false, false);
        this.fDeserContext = deserializationContext;
        this.setIR(grammar);
        this.setValidationContext(deserializationContext);
    }

    public final void reset(boolean bl) {
        this.setValidationContext(this.fDeserContext);
        super.reset(bl);
        this.fMatchingEndElementDepth = -1;
        this.fEntityFactory.reset(bl);
        this.fSymbolTable.reset(bl);
        this.fBufferFactory.reset(bl);
    }

    public final void unmarshal(InputStream inputStream) throws UnmarshalException {
        if (this.fNeedReset) {
            this.reset(true);
        }
        this.fNeedReset = true;
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(inputStream, null);
        if (parsedEntity.error != null) {
            if (parsedEntity.error.exception != null) {
                JAXBMessageProvider.throwUnmarshalException(parsedEntity.error.exception);
            } else {
                JAXBMessageProvider.throwUnmarshalException(parsedEntity.error.formatErrorMessage());
            }
        }
        this.parseDocumentEntity(parsedEntity);
        this.fSymbolTable.updateSymbolMapHolder();
    }

    public final void unmarshal(InputSource inputSource) throws UnmarshalException {
        if (this.fNeedReset) {
            this.reset(true);
        }
        this.fNeedReset = true;
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(inputSource);
        if (parsedEntity.error != null) {
            if (parsedEntity.error.exception != null) {
                JAXBMessageProvider.throwUnmarshalException(parsedEntity.error.exception);
            } else {
                JAXBMessageProvider.throwUnmarshalException(parsedEntity.error.formatErrorMessage());
            }
        }
        this.parseDocumentEntity(parsedEntity);
        this.fSymbolTable.updateSymbolMapHolder();
    }

    public final boolean produceStartDocumentEvent() {
        super.produceStartDocumentEvent();
        this.fDeserContext.handleStartDocumentEvent();
        return true;
    }

    public final boolean produceEndDocumentEvent() {
        super.produceEndDocumentEvent();
        this.fDeserContext.handleEndDocumentEvent();
        return false;
    }

    public final boolean produceRootElementEvent(boolean bl) {
        if (bl) {
            super.produceLeafElementEvent();
            if (!this.skippingLeaf()) {
                this.fDeserContext.handleRootElementEvent(this.elementType, true);
            } else {
                this.fDeserContext.handleSkippedRootElementEvent(this.elementType, true);
            }
            return true;
        }
        super.produceStartElementEvent();
        if (!this.skipping()) {
            this.fDeserContext.handleRootElementEvent(this.elementType, false);
        } else {
            this.fDeserContext.handleSkippedRootElementEvent(this.elementType, false);
        }
        return true;
    }

    public final boolean produceLeafElementEvent() {
        if (this.currentElementHasMixedContent() && !this.skipping()) {
            this.fDeserContext.handleMixedContent();
        }
        super.produceLeafElementEvent();
        if (!this.skipping() && !this.skippingLeaf()) {
            this.fDeserContext.handleLeafElementEvent(this.elementType);
        } else {
            this.fDeserContext.handleSkippedLeafElementEvent(this.elementType);
        }
        return true;
    }

    public final boolean produceStartElementEvent() {
        if (this.currentElementHasMixedContent() && !this.skipping()) {
            this.fDeserContext.handleMixedContent();
        }
        super.produceStartElementEvent();
        if (!this.skipping()) {
            this.fDeserContext.handleStartElementEvent(this.elementType);
        } else {
            this.fDeserContext.handleSkippedStartElementEvent(this.elementType);
        }
        return true;
    }

    public final boolean produceEndElementEvent() {
        if (this.currentElementHasMixedContent() && !this.skipping()) {
            this.fDeserContext.handleMixedContent();
        }
        if (!this.skipping()) {
            this.fDeserContext.handleEndElementEvent(this.elementType);
        } else {
            this.fDeserContext.handleSkippedEndElementEvent(this.elementType);
        }
        super.produceEndElementEvent();
        return this.elementDepth > this.fMatchingEndElementDepth;
    }

    public final boolean produceCharactersEvent() {
        super.produceCharactersEvent();
        if (this.skipping()) {
            this.fDeserContext.handleSkippedCharacters(this.content);
        }
        return true;
    }

    public final boolean produceCDATASectionEvent() {
        super.produceCDATASectionEvent();
        if (this.skipping()) {
            this.fDeserContext.handleSkippedCharacters(this.content);
        }
        return true;
    }

    public final boolean produceWhitespaceEvent() {
        super.produceWhitespaceEvent();
        if (this.skipping()) {
            this.fDeserContext.handleSkippedCharacters(this.content);
        }
        return true;
    }

    public final boolean produceCharacterEvent() {
        super.produceCharacterEvent();
        if (this.skipping()) {
            this.fDeserContext.handleSkippedCharacter(this.singleCh);
        }
        return true;
    }

    public final boolean producePredefinedEntityEvent() {
        super.producePredefinedEntityEvent();
        if (this.skipping()) {
            this.fDeserContext.handleSkippedCharacter(this.singleCh);
        }
        return true;
    }

    public final boolean produceFatalErrorEvent() {
        JAXBMessageProvider.throwUnmarshalExceptionWrapper(this.getErrorMessage());
        return false;
    }

    private String getErrorMessage() {
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(this.errorURI);
        int n = this.errorParamsCount;
        Object[] objectArray = ArrayAllocator.newObjectArray(XMLString.class, n);
        while (n-- > 0) {
            objectArray[n] = this.errorParamStrings[n];
        }
        String string = messageProvider.createMessage(null, this.errorCode, objectArray);
        return string;
    }
}

