/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg;

import com.ibm.fcg.FcgBinOp;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgCodeGen;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgInterfaceType;
import com.ibm.fcg.FcgMethodGen;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.FcgVariable;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.model.MixedContentProperty;
import com.ibm.xml.xlxp2.jaxb.model.PropertyType;
import com.ibm.xml.xlxp2.jaxb.model.PropertyTypeInformation;
import com.ibm.xml.xlxp2.jaxb.model.ValueClass;
import com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg.FCGDeserializationStubGenerator;
import com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg.PropertyGenerator;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class MixedContentPropertyGenerator
extends PropertyGenerator {
    private final ValueClass valueClass;
    private final MixedContentProperty property;

    public MixedContentPropertyGenerator(ValueClass valueClass, MixedContentProperty mixedContentProperty) {
        this.valueClass = valueClass;
        this.property = mixedContentProperty;
    }

    public int getPropertyID() {
        return this.property.propertyId;
    }

    public void generate(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable) {
        PropertyTypeInformation propertyTypeInformation = this.property.propertyTypeInfo;
        if (propertyTypeInformation.propType == PropertyType.COLLECTION) {
            FcgInterfaceType fcgInterfaceType = fcgCodeGen.getInterfaceType("java.util.Collection");
            FcgClassReferenceType fcgClassReferenceType = (FcgClassReferenceType)FCGDeserializationStubGenerator.getFcgType(this.valueClass.javaType, fcgCodeGen);
            FcgClassReferenceType fcgClassReferenceType2 = null;
            if (this.property.propertyField != null) {
                boolean bl = this.property.propertyField.getDeclaringClass().getPackage() == this.valueClass.javaType.getPackage();
                int n = this.property.propertyField.getModifiers();
                if (!bl && !Modifier.isPublic(n) || Modifier.isPrivate(n)) {
                    fcgInstructionList.loadThis();
                    this.readPropertyCollectionField(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgClassReferenceType2, fcgInterfaceType);
                } else {
                    Class<?> clazz = this.property.propertyField.getType();
                    FcgType fcgType = FCGDeserializationStubGenerator.getFcgType(clazz, fcgCodeGen);
                    FcgType fcgType2 = FCGDeserializationStubGenerator.getFcgType(JAXBModel.getConcreteCollectionType(clazz), fcgCodeGen);
                    fcgClassReferenceType2 = fcgInstructionList.loadThis();
                    fcgInstructionList.loadInstanceField(fcgClassReferenceType2, "_o", fcgClassReferenceType);
                    fcgInstructionList.loadInstanceField(fcgClassReferenceType, this.property.propertyField.getName(), fcgType);
                    fcgInstructionList.loadNull();
                    fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                    fcgInstructionList.beginIf();
                    fcgInstructionList.loadThis();
                    fcgInstructionList.loadInstanceField(fcgClassReferenceType2, "_o", fcgClassReferenceType);
                    fcgInstructionList.createObjectExpr(fcgType2, 0);
                    fcgInstructionList.convertExpr(fcgType2, fcgType);
                    fcgInstructionList.storeInstanceFieldStmt(fcgClassReferenceType, this.property.propertyField.getName(), fcgType);
                    fcgInstructionList.endIf();
                    fcgInstructionList.loadThis();
                    fcgInstructionList.loadInstanceField(fcgClassReferenceType2, "_o", fcgClassReferenceType);
                    fcgInstructionList.loadInstanceField(fcgClassReferenceType, this.property.propertyField.getName(), fcgType);
                }
            } else {
                Method method = this.property.accessor.readMethod;
                Class<?> clazz = method.getReturnType();
                FcgType fcgType = FCGDeserializationStubGenerator.getFcgType(clazz, fcgCodeGen);
                fcgClassReferenceType2 = fcgInstructionList.loadThis();
                boolean bl = method.getDeclaringClass().getPackage() == this.valueClass.javaType.getPackage();
                int n = method.getModifiers();
                if (!bl && !Modifier.isPublic(n) || Modifier.isPrivate(n)) {
                    this.readPropertyCollectionMethod(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgClassReferenceType2, fcgInterfaceType);
                } else {
                    fcgInstructionList.loadInstanceField(fcgClassReferenceType2, "_o", fcgClassReferenceType);
                    fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, method.getName(), fcgType, 0);
                }
                FcgVariable fcgVariable2 = fcgInstructionList.defineVar(fcgType, "list" + this.property.propertyId, true);
                fcgInstructionList.loadVar(fcgVariable2);
            }
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.invokeInterfaceMethod(fcgInterfaceType, "add", (FcgType)FcgType.BOOLEAN, new FcgType[]{FcgType.OBJECT});
            fcgInstructionList.defineVar(FcgType.BOOLEAN, "addResult" + this.property.propertyId, true);
        }
    }

    protected void readPropertyCollectionField(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType, FcgType fcgType) {
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, "readMixedContentPropertyCollectionField", fcgType, 0);
    }

    protected void readPropertyCollectionMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType, FcgType fcgType) {
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, "readMixedContentPropertyCollectionMethod", fcgType, 0);
    }
}

