/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg;

import com.ibm.fcg.FcgAttrs;
import com.ibm.fcg.FcgBinOp;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgCodeGen;
import com.ibm.fcg.FcgFactory;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgMethodGen;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.FcgVariable;
import com.ibm.xml.xlxp2.jaxb.model.ElementDeclaration;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg.ElementDeclarationGenerator;
import com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg.FCGDeserializationStubGeneratorHelper;
import com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg.Generatable;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class FCGDeserializationRootStubGenerator
extends FCGDeserializationStubGeneratorHelper
implements Generatable {
    private final JAXBModel model;
    private final int elementDeclCount;
    private final List<ElementDeclarationGenerator> objectProperties = new ArrayList<ElementDeclarationGenerator>();
    private final List<ElementDeclarationGenerator> simpleElementProperties = new ArrayList<ElementDeclarationGenerator>();

    public static String getRootStubClassName(JAXBModel jAXBModel) {
        return "com.ibm.xml.xlxp2.jaxb.unmarshal.JAXB_Deserialization_Root_Stub";
    }

    public FCGDeserializationRootStubGenerator(JAXBModel jAXBModel, ClassLoader classLoader) {
        super(classLoader);
        this.model = jAXBModel;
        ElementDeclaration[] elementDeclarationArray = jAXBModel.elementDeclarations;
        this.elementDeclCount = elementDeclarationArray != null ? elementDeclarationArray.length : 0;
        for (int i = 0; i < this.elementDeclCount; ++i) {
            ElementDeclaration elementDeclaration = elementDeclarationArray[i];
            if (elementDeclaration.factoryMethod == null) continue;
            ElementDeclarationGenerator elementDeclarationGenerator = new ElementDeclarationGenerator(jAXBModel, elementDeclaration, i, this);
            this.objectProperties.add(elementDeclarationGenerator);
            if (elementDeclaration.typeInfo.valueType.valueClass != null) continue;
            this.simpleElementProperties.add(elementDeclarationGenerator);
        }
    }

    @Override
    public void generate(String string, OutputStream outputStream) throws IOException {
        FcgCodeGen fcgCodeGen = FcgFactory.createCodeGen(string);
        FcgClassGen fcgClassGen = this.generateClassDeclaration(fcgCodeGen);
        this.generateConstructor(fcgCodeGen, fcgClassGen);
        this.generateStartMethod(fcgCodeGen, fcgClassGen);
        this.generateClearMethod(fcgCodeGen, fcgClassGen);
        this.generateWriteMethods(fcgCodeGen, fcgClassGen);
        fcgClassGen.dump(outputStream);
    }

    private FcgClassGen generateClassDeclaration(FcgCodeGen fcgCodeGen) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType(FCGDeserializationRootStubGenerator.getRootStubClassName(this.model));
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType("com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationStub");
        FcgClassGen fcgClassGen = fcgCodeGen.newClassGen(fcgClassReferenceType, fcgClassReferenceType2, FcgAttrs.PUBLIC_FINAL);
        return fcgClassGen;
    }

    private void generateConstructor(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newConstructorGen(FcgAttrs.PUBLIC);
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType("com.ibm.xml.xlxp2.jaxb.model.ValueClass");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        fcgInstructionList.loadThis();
        fcgInstructionList.loadNull();
        fcgInstructionList.convertExpr(FcgType.OBJECT, fcgClassReferenceType);
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType("com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationStub");
        fcgInstructionList.invokeSuperConstructor(fcgClassReferenceType2, 1);
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateStartMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) throws IOException {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC, FcgType.VOID, "start");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateClearMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC, FcgType.VOID, "clear");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        FcgClassReferenceType fcgClassReferenceType = fcgInstructionList.loadThis();
        fcgInstructionList.loadNull();
        fcgInstructionList.storeInstanceFieldStmt(fcgClassReferenceType, "o", FcgType.OBJECT);
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
    }

    private void generateWriteMethods(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        this.generateWriteObjectMethod(fcgCodeGen, fcgClassGen);
        this.generateWriteXMLStringMethod(fcgCodeGen, fcgClassGen);
    }

    private void generateWriteObjectMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FCGDeserializationRootStubGenerator.generateWriteMethod(this.objectProperties, this.elementDeclCount, FcgType.OBJECT, fcgCodeGen, fcgClassGen, this.fMethodSplitThreshold);
    }

    private void generateWriteXMLStringMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen) {
        FCGDeserializationRootStubGenerator.generateWriteMethod(this.simpleElementProperties, this.elementDeclCount, fcgCodeGen.getClassReferenceType("com.ibm.xml.xlxp2.scan.util.XMLString"), fcgCodeGen, fcgClassGen, this.fMethodSplitThreshold);
    }

    private static void generateWriteMethod(List<ElementDeclarationGenerator> list, int n, FcgType fcgType, FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, int n2) {
        int n3 = list.size();
        if (n3 > 0) {
            FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PUBLIC, FcgType.VOID, "write");
            FcgVariable fcgVariable = fcgMethodGen.addParameter(FcgType.INT, "propertyId");
            FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgType, "value");
            FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
            fcgInstructionList.beginMethod();
            int n4 = n3 / 2;
            if (n3 > n2) {
                fcgInstructionList.loadVar(fcgVariable);
                fcgInstructionList.loadLiteral(n);
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_NE);
                fcgInstructionList.beginIf();
                fcgInstructionList.loadVar(fcgVariable);
                fcgInstructionList.loadLiteral(list.get(n4).getElementDeclarationIndex());
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_LT);
                fcgInstructionList.beginIf();
                FCGDeserializationRootStubGenerator.callInternalWriteMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 0);
                fcgInstructionList.beginElse();
                FCGDeserializationRootStubGenerator.callInternalWriteMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, 1);
                fcgInstructionList.endIf();
                fcgInstructionList.beginElse();
                if (fcgVariable2.getType() == FcgType.OBJECT) {
                    FCGDeserializationRootStubGenerator.callCreateJAXBElement(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable2);
                } else {
                    FCGDeserializationRootStubGenerator.callWriteSimpleContent(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable2, n);
                }
                fcgInstructionList.endIf();
            } else {
                FCGDeserializationRootStubGenerator.generateProperties(list, n, fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2);
            }
            fcgInstructionList.returnInstruction();
            fcgInstructionList.endMethod();
            if (n3 > n2) {
                int[] nArray = ArrayAllocator.newIntArray(1);
                nArray[0] = 2;
                FCGDeserializationRootStubGenerator.generateInternalWriteMethod(list.subList(0, n4), fcgType, fcgCodeGen, fcgClassGen, 0, nArray, n2);
                FCGDeserializationRootStubGenerator.generateInternalWriteMethod(list.subList(n4, n3), fcgType, fcgCodeGen, fcgClassGen, 1, nArray, n2);
            }
        }
    }

    private static void generateInternalWriteMethod(List<ElementDeclarationGenerator> list, FcgType fcgType, FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, int n, int[] nArray, int n2) {
        FcgMethodGen fcgMethodGen = fcgClassGen.newMethodGen(FcgAttrs.PRIVATE, FcgType.VOID, "write" + n);
        FcgVariable fcgVariable = fcgMethodGen.addParameter(FcgType.INT, "propertyId");
        FcgVariable fcgVariable2 = fcgMethodGen.addParameter(fcgType, "value");
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        fcgInstructionList.beginMethod();
        int n3 = list.size();
        int n4 = n3 / 2;
        int n5 = nArray[0];
        if (n3 > n2) {
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.loadLiteral(list.get(n4).getElementDeclarationIndex());
            fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_LT);
            fcgInstructionList.beginIf();
            FCGDeserializationRootStubGenerator.callInternalWriteMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n5);
            fcgInstructionList.beginElse();
            FCGDeserializationRootStubGenerator.callInternalWriteMethod(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, fcgVariable2, n5 + 1);
            fcgInstructionList.endIf();
        } else {
            FCGDeserializationRootStubGenerator.generateProperties(list, -1, fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgVariable2);
        }
        fcgInstructionList.returnInstruction();
        fcgInstructionList.endMethod();
        if (n3 > n2) {
            nArray[0] = nArray[0] + 2;
            FCGDeserializationRootStubGenerator.generateInternalWriteMethod(list.subList(0, n4), fcgType, fcgCodeGen, fcgClassGen, n5, nArray, n2);
            FCGDeserializationRootStubGenerator.generateInternalWriteMethod(list.subList(n4, n3), fcgType, fcgCodeGen, fcgClassGen, n5 + 1, nArray, n2);
        }
    }

    private static void callInternalWriteMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2, int n) {
        fcgInstructionList.loadThis();
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.loadVar(fcgVariable2);
        fcgInstructionList.invokeInstanceMethod(fcgClassGen.getClassType(), "write" + n, (FcgType)FcgType.VOID, new FcgType[]{fcgVariable.getType(), fcgVariable2.getType()});
    }

    private static void callCreateJAXBElement(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType("javax.xml.bind.JAXBElement");
        FcgClassReferenceType fcgClassReferenceType2 = fcgInstructionList.loadThis();
        fcgInstructionList.loadThis();
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "createJAXBElement", (FcgType)fcgClassReferenceType, new FcgType[]{FcgType.OBJECT});
        fcgInstructionList.storeInstanceFieldStmt(fcgClassReferenceType2, "o", FcgType.OBJECT);
    }

    private static void callWriteSimpleContent(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, int n) {
        FcgClassReferenceType fcgClassReferenceType = fcgInstructionList.loadThis();
        FcgClassReferenceType fcgClassReferenceType2 = fcgCodeGen.getClassReferenceType("com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationContext");
        fcgInstructionList.loadInstanceField(fcgClassReferenceType, "fContext", fcgClassReferenceType2);
        fcgInstructionList.loadLiteral(n);
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, "writeSimpleContent", (FcgType)FcgType.VOID, new FcgType[]{FcgType.INT, fcgVariable.getType()});
    }

    private static void generateProperties(List<ElementDeclarationGenerator> list, int n, FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgVariable fcgVariable2) {
        fcgInstructionList.loadVar(fcgVariable);
        fcgInstructionList.beginSwitch();
        for (ElementDeclarationGenerator elementDeclarationGenerator : list) {
            fcgInstructionList.beginSwitchCaseBlock(elementDeclarationGenerator.getElementDeclarationIndex());
            elementDeclarationGenerator.generate(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable2);
            fcgInstructionList.endSwitchCaseBlock();
        }
        if (fcgVariable2.getType() == FcgType.OBJECT) {
            if (n > 0) {
                fcgInstructionList.beginSwitchCaseBlock(n);
                FCGDeserializationRootStubGenerator.callCreateJAXBElement(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable2);
                fcgInstructionList.endSwitchCaseBlock();
            }
            fcgInstructionList.beginSwitchDefaultBlock();
            FcgClassReferenceType fcgClassReferenceType = fcgInstructionList.loadThis();
            fcgInstructionList.loadVar(fcgVariable2);
            fcgInstructionList.storeInstanceFieldStmt(fcgClassReferenceType, "o", FcgType.OBJECT);
            fcgInstructionList.endSwitchDefaultBlock();
        } else if (n > 0) {
            fcgInstructionList.beginSwitchCaseBlock(n);
            FCGDeserializationRootStubGenerator.callWriteSimpleContent(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable2, n);
            fcgInstructionList.endSwitchCaseBlock();
        }
        fcgInstructionList.endSwitch();
    }
}

