/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg;

import com.ibm.fcg.FcgBinOp;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgCodeGen;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgInterfaceType;
import com.ibm.fcg.FcgMethodGen;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.FcgVariable;
import com.ibm.xml.xlxp2.jaxb.model.ElementProperty;
import com.ibm.xml.xlxp2.jaxb.model.ElementWildcardProperty;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.model.PropertyType;
import com.ibm.xml.xlxp2.jaxb.model.PropertyTypeInformation;
import com.ibm.xml.xlxp2.jaxb.model.ValueClass;
import com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg.FCGDeserializationStubGenerator;
import com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg.FCGDeserializationStubGeneratorHelper;
import com.ibm.xml.xlxp2.jaxb.unmarshal.codegen.fcg.TypedPropertyGenerator;
import com.ibm.xml.xlxp2.scan.Copyright;
import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlElement;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ElementPropertyGenerator
extends TypedPropertyGenerator {
    private final ValueClass valueClass;
    private final ElementProperty property;
    private final ElementWildcardProperty wProperty;
    private final FCGDeserializationStubGeneratorHelper helper;

    public ElementPropertyGenerator(ValueClass valueClass, ElementProperty elementProperty, FCGDeserializationStubGeneratorHelper fCGDeserializationStubGeneratorHelper) {
        super(valueClass, elementProperty, fCGDeserializationStubGeneratorHelper);
        this.valueClass = valueClass;
        this.property = elementProperty;
        this.wProperty = null;
        this.helper = fCGDeserializationStubGeneratorHelper;
    }

    public ElementPropertyGenerator(ValueClass valueClass, ElementWildcardProperty elementWildcardProperty, FCGDeserializationStubGeneratorHelper fCGDeserializationStubGeneratorHelper) {
        super(valueClass, null, fCGDeserializationStubGeneratorHelper);
        this.valueClass = valueClass;
        this.wProperty = elementWildcardProperty;
        this.property = null;
        this.helper = fCGDeserializationStubGeneratorHelper;
    }

    public final int getPropertyID() {
        return this.property.propertyId;
    }

    public void generateWildCard(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable) {
        FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getClassReferenceType("org.w3c.dom.Element");
        FcgClassReferenceType fcgClassReferenceType2 = (FcgClassReferenceType)FCGDeserializationStubGenerator.getFcgType(this.valueClass.javaType, fcgCodeGen);
        PropertyTypeInformation propertyTypeInformation = this.wProperty.propertyTypeInfo;
        if (propertyTypeInformation.propType == PropertyType.SIMPLE || propertyTypeInformation.propType == PropertyType.ELEMENT) {
            FcgClassReferenceType fcgClassReferenceType3 = fcgInstructionList.loadThis();
            fcgInstructionList.loadInstanceField(fcgClassReferenceType3, "_o", fcgClassReferenceType2);
            boolean bl = false;
            fcgInstructionList.loadVar(fcgVariable);
            if (this.wProperty.propertyField != null) {
                fcgInstructionList.storeInstanceFieldStmt(fcgClassReferenceType2, this.wProperty.propertyField.getName(), FCGDeserializationStubGenerator.getFcgType(this.wProperty.propertyField.getType(), fcgCodeGen));
            } else {
                Method method;
                if (!bl) {
                    fcgInstructionList.convertExpr(fcgVariable.getType(), fcgClassReferenceType);
                    bl = true;
                }
                if ((method = this.wProperty.accessor.writeMethod) != null) {
                    FcgType fcgType = FCGDeserializationStubGenerator.getFcgType(method.getReturnType(), fcgCodeGen);
                    fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, method.getName(), fcgType, new FcgType[]{FCGDeserializationStubGenerator.getFcgType(method.getParameterTypes()[0], fcgCodeGen)});
                } else {
                    fcgInstructionList.defineVar(fcgClassReferenceType, "__val" + this.property.propertyId, true);
                    fcgInstructionList.defineVar(fcgClassReferenceType2, "__o" + this.property.propertyId, true);
                }
            }
        } else if (propertyTypeInformation.propType == PropertyType.COLLECTION) {
            FcgInterfaceType fcgInterfaceType = fcgCodeGen.getInterfaceType("java.util.Collection");
            if (this.wProperty.propertyField != null) {
                Class<?> clazz = this.wProperty.propertyField.getType();
                FcgType fcgType = FCGDeserializationStubGenerator.getFcgType(clazz, fcgCodeGen);
                FcgType fcgType2 = FCGDeserializationStubGenerator.getFcgType(JAXBModel.getConcreteCollectionType(clazz), fcgCodeGen);
                FcgClassReferenceType fcgClassReferenceType4 = fcgInstructionList.loadThis();
                fcgInstructionList.loadInstanceField(fcgClassReferenceType4, "_o", fcgClassReferenceType2);
                fcgInstructionList.loadInstanceField(fcgClassReferenceType2, this.wProperty.propertyField.getName(), fcgType);
                fcgInstructionList.loadNull();
                fcgInstructionList.binaryOperationExpr(FcgBinOp.COMPARE_EQ);
                fcgInstructionList.beginIf();
                fcgInstructionList.loadThis();
                fcgInstructionList.loadInstanceField(fcgClassReferenceType4, "_o", fcgClassReferenceType2);
                fcgInstructionList.createObjectExpr(fcgType2, 0);
                fcgInstructionList.convertExpr(fcgType2, fcgType);
                fcgInstructionList.storeInstanceFieldStmt(fcgClassReferenceType2, this.wProperty.propertyField.getName(), fcgType);
                fcgInstructionList.endIf();
                fcgInstructionList.loadThis();
                fcgInstructionList.loadInstanceField(fcgClassReferenceType4, "_o", fcgClassReferenceType2);
                fcgInstructionList.loadInstanceField(fcgClassReferenceType2, this.wProperty.propertyField.getName(), fcgType);
            } else {
                Method method = this.wProperty.accessor.readMethod;
                Class<?> clazz = method.getReturnType();
                FcgType fcgType = FCGDeserializationStubGenerator.getFcgType(clazz, fcgCodeGen);
                FcgClassReferenceType fcgClassReferenceType5 = fcgInstructionList.loadThis();
                fcgInstructionList.loadInstanceField(fcgClassReferenceType5, "_o", fcgClassReferenceType2);
                fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType2, method.getName(), fcgType, 0);
                FcgVariable fcgVariable2 = fcgInstructionList.defineVar(fcgType, "list" + this.wProperty.propertyId, true);
                fcgInstructionList.loadVar(fcgVariable2);
            }
            fcgInstructionList.loadVar(fcgVariable);
            fcgInstructionList.convertExpr(fcgClassReferenceType, FcgType.OBJECT);
            fcgInstructionList.invokeInterfaceMethod(fcgInterfaceType, "add", (FcgType)FcgType.BOOLEAN, new FcgType[]{FcgType.OBJECT});
            fcgInstructionList.defineVar(FcgType.BOOLEAN, "addResult" + this.wProperty.propertyId, true);
        }
    }

    protected FcgClassReferenceType callJAXBFactory(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, PropertyTypeInformation propertyTypeInformation, FcgType fcgType) {
        return this.helper.callJAXBFactory(fcgCodeGen, fcgClassGen, fcgInstructionList, fcgVariable, propertyTypeInformation, fcgType, this.property.elementDecl.factoryMethod);
    }

    protected boolean isXMLStringMethod(FcgCodeGen fcgCodeGen, FcgMethodGen fcgMethodGen) {
        return fcgMethodGen.getArgumentTypes()[1] == fcgCodeGen.getClassReferenceType("com.ibm.xml.xlxp2.scan.util.XMLString");
    }

    protected FcgVariable produceTypedValue(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable) {
        return FCGDeserializationStubGenerator.produceSimpleTypeValue(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, this.property);
    }

    protected FcgVariable produceTypedValue2(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable) {
        return fcgVariable;
    }

    protected boolean checkElementType() {
        return this.property.xmlElementType == null || this.property.xmlElementType == XmlElement.DEFAULT.class;
    }

    protected void readPropertyCollectionField(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType, FcgType fcgType) {
        fcgInstructionList.loadLiteral(this.getElementPropertyIndex());
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, "readElementPropertyCollectionField", fcgType, 1);
    }

    protected void readPropertyCollectionMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType, FcgType fcgType) {
        fcgInstructionList.loadLiteral(this.getElementPropertyIndex());
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, "readElementPropertyCollectionMethod", fcgType, 1);
    }

    protected void writePropertyField(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType, FcgType fcgType, FcgType fcgType2) {
        this.setupStackToCallReflectiveWriteMethod(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgType, fcgType2);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, "writeElementPropertyField", (FcgType)FcgType.VOID, new FcgType[]{FcgType.INT, FcgType.OBJECT});
    }

    protected void writePropertyMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgClassReferenceType fcgClassReferenceType, FcgType fcgType, FcgType fcgType2) {
        this.setupStackToCallReflectiveWriteMethod(fcgCodeGen, fcgClassGen, fcgMethodGen, fcgInstructionList, fcgVariable, fcgType, fcgType2);
        fcgInstructionList.invokeInstanceMethod(fcgClassReferenceType, "writeElementPropertyMethod", (FcgType)FcgType.VOID, new FcgType[]{FcgType.INT, FcgType.OBJECT});
    }

    private void setupStackToCallReflectiveWriteMethod(FcgCodeGen fcgCodeGen, FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen, FcgInstructionList fcgInstructionList, FcgVariable fcgVariable, FcgType fcgType, FcgType fcgType2) {
        FcgVariable fcgVariable2 = fcgInstructionList.defineVar(fcgType, "__val" + this.property.propertyId, true);
        FcgVariable fcgVariable3 = fcgInstructionList.defineVar(fcgType2, "__o" + this.property.propertyId, true);
        int n = this.getElementPropertyIndex();
        fcgInstructionList.loadThis();
        fcgInstructionList.loadLiteral(n);
        fcgInstructionList.loadVar(fcgVariable2);
        if (FCGDeserializationStubGenerator.isPrimitiveType(fcgVariable2.getType())) {
            FcgType fcgType3 = FCGDeserializationStubGenerator.getPrimitiveWrapperType(fcgCodeGen, fcgVariable2.getType());
            fcgInstructionList.invokeClassMethod((FcgClassReferenceType)fcgType3, "valueOf", fcgType3, 1);
        }
    }

    private int getElementPropertyIndex() {
        for (int i = 0; i < this.valueClass.elementProperties.length; ++i) {
            ElementProperty elementProperty = this.valueClass.elementProperties[i];
            if (elementProperty != this.property) continue;
            return i;
        }
        return -1;
    }
}

