/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.unmarshal;

import com.ibm.xml.xlxp2.api.jaxb.JAXBXMLStreamReader;
import com.ibm.xml.xlxp2.api.stax.XMLStreamReaderProxy;
import com.ibm.xml.xlxp2.grammar.Grammar;
import com.ibm.xml.xlxp2.jaxb.PropertyKeyAdapter;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.msg.JAXBMessageProvider;
import com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationContext;
import com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationStubFactory;
import com.ibm.xml.xlxp2.jaxb.unmarshal.impl.JAXBDocumentScanner;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.SymbolMapHolder;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UnmarshallerImpl
implements Unmarshaller {
    private static final int VALIDATING_SET = 1;
    private static final int SCHEMA_SET = 2;
    private static final int LISTENER_SET = 4;
    private static final int PROPERTIES_SET = 8;
    private static final int VALIDATION_EVENT_HANDLER_SET = 16;
    private static final int ADAPTER_INSTANCES_SET = 32;
    private final Grammar fGrammar;
    private final DeserializationContext fContext;
    private JAXBDocumentScanner fScanner;
    private final SymbolMapHolder fSymbolMapHolder;
    private boolean fValidating;
    private ValidationEventHandler fEventHandler;
    private Schema fSchema;
    private AttachmentUnmarshaller fAttachmentUnmarshaller;
    private Unmarshaller.Listener fListener;
    private HashMap<String, Object> fInitProperties;
    private final JAXBContext fFallbackContext;
    private final PropertyKeyAdapter fPropertyKeyAdapter;
    private Unmarshaller fFallbackUnmarshaller;
    private int flags;

    public UnmarshallerImpl(JAXBModel jAXBModel, Grammar grammar, JAXBContext jAXBContext, DeserializationStubFactory deserializationStubFactory, SymbolMapHolder symbolMapHolder, DatatypeFactory datatypeFactory, PropertyKeyAdapter propertyKeyAdapter) throws JAXBException {
        this.fGrammar = grammar;
        this.fSymbolMapHolder = symbolMapHolder;
        this.fFallbackContext = jAXBContext;
        this.fPropertyKeyAdapter = propertyKeyAdapter;
        this.fContext = new DeserializationContext(jAXBModel, deserializationStubFactory, datatypeFactory, this);
    }

    public Object unmarshal(File file) throws JAXBException {
        if (file == null) {
            UnmarshallerImpl.reportNullParameter(File.class);
        }
        return this.unmarshal(new InputSource(file.toURI().toString()));
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        if (inputStream == null) {
            UnmarshallerImpl.reportNullParameter(InputStream.class);
        }
        if (this.flags == 0) {
            try {
                if (this.fScanner == null) {
                    this.fScanner = new JAXBDocumentScanner(this.fContext, this.fGrammar, this.fSymbolMapHolder);
                }
                this.fScanner.unmarshal(inputStream);
                return this.fContext.rootStub.o;
            }
            catch (JAXBMessageProvider.UnmarshalExceptionWrapper unmarshalExceptionWrapper) {
                JAXBMessageProvider.throwUnmarshalException(unmarshalExceptionWrapper);
            }
        }
        this.initFallbackUnmarshaller();
        return this.fFallbackUnmarshaller.unmarshal(inputStream);
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        if (reader == null) {
            UnmarshallerImpl.reportNullParameter(Reader.class);
        }
        return this.unmarshal(new InputSource(reader));
    }

    public Object unmarshal(URL uRL) throws JAXBException {
        if (uRL == null) {
            UnmarshallerImpl.reportNullParameter(URL.class);
        }
        return this.unmarshal(new InputSource(uRL.toExternalForm()));
    }

    public Object unmarshal(InputSource inputSource) throws JAXBException {
        if (inputSource == null) {
            UnmarshallerImpl.reportNullParameter(InputSource.class);
        }
        if (this.flags == 0) {
            try {
                if (this.fScanner == null) {
                    this.fScanner = new JAXBDocumentScanner(this.fContext, this.fGrammar, this.fSymbolMapHolder);
                }
                this.fScanner.unmarshal(inputSource);
                return this.fContext.rootStub.o;
            }
            catch (JAXBMessageProvider.UnmarshalExceptionWrapper unmarshalExceptionWrapper) {
                JAXBMessageProvider.throwUnmarshalException(unmarshalExceptionWrapper);
            }
        }
        this.initFallbackUnmarshaller();
        return this.fFallbackUnmarshaller.unmarshal(inputSource);
    }

    public Object unmarshal(Node node) throws JAXBException {
        if (node == null) {
            UnmarshallerImpl.reportNullParameter(Node.class);
        }
        this.initFallbackUnmarshaller();
        return this.fFallbackUnmarshaller.unmarshal(node);
    }

    public <T> JAXBElement<T> unmarshal(Node node, Class<T> clazz) throws JAXBException {
        if (node == null) {
            UnmarshallerImpl.reportNullParameter(Node.class);
        }
        if (clazz == null) {
            UnmarshallerImpl.reportNullParameter(Class.class);
        }
        this.initFallbackUnmarshaller();
        return this.fFallbackUnmarshaller.unmarshal(node, clazz);
    }

    public Object unmarshal(Source source) throws JAXBException {
        if (source == null) {
            UnmarshallerImpl.reportNullParameter(Source.class);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(streamSource.getReader());
            inputSource.setByteStream(streamSource.getInputStream());
            inputSource.setSystemId(streamSource.getSystemId());
            inputSource.setPublicId(streamSource.getPublicId());
            return this.unmarshal(inputSource);
        }
        if (source instanceof StAXSource) {
            StAXSource stAXSource = (StAXSource)source;
            XMLStreamReader xMLStreamReader = stAXSource.getXMLStreamReader();
            if (xMLStreamReader != null) {
                return this.unmarshal(xMLStreamReader);
            }
            return this.unmarshal(stAXSource.getXMLEventReader());
        }
        this.initFallbackUnmarshaller();
        return this.fFallbackUnmarshaller.unmarshal(source);
    }

    public <T> JAXBElement<T> unmarshal(Source source, Class<T> clazz) throws JAXBException {
        if (source == null) {
            UnmarshallerImpl.reportNullParameter(Source.class);
        }
        if (clazz == null) {
            UnmarshallerImpl.reportNullParameter(Class.class);
        }
        if (source instanceof StAXSource) {
            StAXSource stAXSource = (StAXSource)source;
            XMLStreamReader xMLStreamReader = stAXSource.getXMLStreamReader();
            if (xMLStreamReader != null) {
                return this.unmarshal(xMLStreamReader, clazz);
            }
            return this.unmarshal(stAXSource.getXMLEventReader(), clazz);
        }
        this.initFallbackUnmarshaller();
        return this.fFallbackUnmarshaller.unmarshal(source, clazz);
    }

    public Object unmarshal(XMLStreamReader xMLStreamReader) throws JAXBException {
        JAXBXMLStreamReader jAXBXMLStreamReader;
        XMLStreamReaderProxy xMLStreamReaderProxy;
        XMLStreamReader xMLStreamReader2;
        if (xMLStreamReader == null) {
            UnmarshallerImpl.reportNullParameter(XMLStreamReader.class);
        }
        if (xMLStreamReader instanceof XMLStreamReaderProxy && (xMLStreamReader2 = (xMLStreamReaderProxy = (XMLStreamReaderProxy)xMLStreamReader).getReader()) instanceof JAXBXMLStreamReader && (jAXBXMLStreamReader = (JAXBXMLStreamReader)xMLStreamReader2).correctInitialJAXBState()) {
            try {
                boolean bl;
                boolean bl2;
                boolean bl3 = bl2 = jAXBXMLStreamReader.getEventType() == 7;
                if (bl2) {
                    do {
                        xMLStreamReader.next();
                    } while (!xMLStreamReader.isStartElement());
                }
                if (bl = jAXBXMLStreamReader.unmarshal(this.fContext, this.fGrammar)) {
                    xMLStreamReader.next();
                }
                if (bl2) {
                    while (xMLStreamReader.hasNext()) {
                        xMLStreamReader.next();
                    }
                } else {
                    xMLStreamReader.next();
                }
                return this.fContext.rootStub.o;
            }
            catch (XMLStreamException xMLStreamException) {
                JAXBMessageProvider.throwUnmarshalException(xMLStreamException);
            }
            catch (JAXBMessageProvider.UnmarshalExceptionWrapper unmarshalExceptionWrapper) {
                JAXBMessageProvider.throwUnmarshalException(unmarshalExceptionWrapper);
            }
        }
        this.initFallbackUnmarshaller();
        return this.fFallbackUnmarshaller.unmarshal(xMLStreamReader);
    }

    public <T> JAXBElement<T> unmarshal(XMLStreamReader xMLStreamReader, Class<T> clazz) throws JAXBException {
        if (xMLStreamReader == null) {
            UnmarshallerImpl.reportNullParameter(XMLStreamReader.class);
        }
        if (clazz == null) {
            UnmarshallerImpl.reportNullParameter(Class.class);
        }
        this.initFallbackUnmarshaller();
        return this.fFallbackUnmarshaller.unmarshal(xMLStreamReader, clazz);
    }

    public Object unmarshal(XMLEventReader xMLEventReader) throws JAXBException {
        if (xMLEventReader == null) {
            UnmarshallerImpl.reportNullParameter(XMLEventReader.class);
        }
        this.initFallbackUnmarshaller();
        return this.fFallbackUnmarshaller.unmarshal(xMLEventReader);
    }

    public <T> JAXBElement<T> unmarshal(XMLEventReader xMLEventReader, Class<T> clazz) throws JAXBException {
        if (xMLEventReader == null) {
            UnmarshallerImpl.reportNullParameter(XMLEventReader.class);
        }
        if (clazz == null) {
            UnmarshallerImpl.reportNullParameter(Class.class);
        }
        this.initFallbackUnmarshaller();
        return this.fFallbackUnmarshaller.unmarshal(xMLEventReader, clazz);
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        try {
            this.initFallbackUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException(jAXBException);
        }
        return this.fFallbackUnmarshaller.getUnmarshallerHandler();
    }

    public void setValidating(boolean bl) throws JAXBException {
        this.setFlag(1, bl);
        this.fValidating = bl;
        if (this.fFallbackUnmarshaller != null || bl) {
            this.initFallbackUnmarshaller();
            this.fFallbackUnmarshaller.setValidating(bl);
        }
    }

    public boolean isValidating() throws JAXBException {
        return this.fValidating;
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        this.setFlag(16, validationEventHandler != null);
        this.fEventHandler = validationEventHandler;
        if (this.fFallbackUnmarshaller != null) {
            this.fFallbackUnmarshaller.setEventHandler(validationEventHandler);
        }
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        if (this.fEventHandler != null) {
            return this.fEventHandler;
        }
        this.initFallbackUnmarshaller();
        return this.fFallbackUnmarshaller.getEventHandler();
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            UnmarshallerImpl.reportNullParameter(String.class);
        }
        try {
            this.initFallbackUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            throw new PropertyException((Throwable)jAXBException);
        }
        string = this.fPropertyKeyAdapter.adaptKey(string);
        if (this.fInitProperties == null) {
            this.fInitProperties = new HashMap();
        }
        boolean bl = this.fInitProperties.containsKey(string);
        Object object2 = null;
        if (!bl) {
            try {
                object2 = this.fFallbackUnmarshaller.getProperty(string);
            }
            catch (PropertyException propertyException) {
                object2 = null;
            }
        }
        this.fFallbackUnmarshaller.setProperty(string, object);
        if (!bl) {
            if (object2 != object) {
                this.fInitProperties.put(string, object2);
            }
        } else {
            Object object3 = this.fInitProperties.get(string);
            if (object3 == object) {
                this.fInitProperties.remove(string);
            }
        }
        this.setFlag(8, this.fInitProperties.size() > 0);
    }

    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            UnmarshallerImpl.reportNullParameter(String.class);
        }
        try {
            this.initFallbackUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            throw new PropertyException((Throwable)jAXBException);
        }
        return this.fFallbackUnmarshaller.getProperty(this.fPropertyKeyAdapter.adaptKey(string));
    }

    public void setSchema(Schema schema) {
        this.setFlag(2, schema != null);
        this.fSchema = schema;
        if (this.fFallbackUnmarshaller != null) {
            this.fFallbackUnmarshaller.setSchema(schema);
        }
    }

    public Schema getSchema() {
        return this.fSchema;
    }

    public void setAdapter(XmlAdapter xmlAdapter) {
        if (xmlAdapter == null) {
            UnmarshallerImpl.reportNullParameter(XmlAdapter.class);
        }
        this.setAdapter(xmlAdapter.getClass(), xmlAdapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        if (clazz == null) {
            UnmarshallerImpl.reportNullParameter(Class.class);
        }
        try {
            this.initFallbackUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            throw new RuntimeException(jAXBException);
        }
        this.setFlag(32, true);
        this.fFallbackUnmarshaller.setAdapter(clazz, a);
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> clazz) {
        if (clazz == null) {
            UnmarshallerImpl.reportNullParameter(Class.class);
        }
        if (this.fFallbackUnmarshaller != null) {
            return (A)this.fFallbackUnmarshaller.getAdapter(clazz);
        }
        return null;
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller attachmentUnmarshaller) {
        this.fAttachmentUnmarshaller = attachmentUnmarshaller;
        if (this.fFallbackUnmarshaller != null) {
            this.fFallbackUnmarshaller.setAttachmentUnmarshaller(attachmentUnmarshaller);
        }
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.fAttachmentUnmarshaller;
    }

    public void setListener(Unmarshaller.Listener listener) {
        this.setFlag(4, listener != null);
        this.fListener = listener;
        if (this.fFallbackUnmarshaller != null) {
            this.fFallbackUnmarshaller.setListener(listener);
        }
    }

    public Unmarshaller.Listener getListener() {
        return this.fListener;
    }

    private void initFallbackUnmarshaller() throws JAXBException {
        if (this.fFallbackUnmarshaller == null) {
            Unmarshaller unmarshaller = this.fFallbackContext.createUnmarshaller();
            if (this.fEventHandler != null) {
                unmarshaller.setEventHandler(this.fEventHandler);
            }
            if (this.fSchema != null) {
                unmarshaller.setSchema(this.fSchema);
            }
            if (this.fAttachmentUnmarshaller != null) {
                unmarshaller.setAttachmentUnmarshaller(this.fAttachmentUnmarshaller);
            }
            if (this.fListener != null) {
                unmarshaller.setListener(this.fListener);
            }
            this.fFallbackUnmarshaller = unmarshaller;
        }
    }

    private void setFlag(int n, boolean bl) {
        this.flags = bl ? this.flags | n : this.flags & ~n;
    }

    private static void reportNullParameter(Class<?> clazz) {
        throw new IllegalArgumentException(JAXBMessageProvider.createMessage(null, 24, clazz.getName()));
    }
}

