/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.model.converter;

import com.ibm.xml.xlxp2.datatype.TypeValidator;
import com.ibm.xml.xlxp2.datatype.ValidatedInfo;
import com.ibm.xml.xlxp2.datatype.ValidationContext;
import com.ibm.xml.xlxp2.datatype.validation.QNameDV;
import com.ibm.xml.xlxp2.grammar.Attribute;
import com.ibm.xml.xlxp2.grammar.Element;
import com.ibm.xml.xlxp2.grammar.ElementType;
import com.ibm.xml.xlxp2.grammar.Grammar;
import com.ibm.xml.xlxp2.grammar.NamedDeclaration;
import com.ibm.xml.xlxp2.grammar.Wildcard;
import com.ibm.xml.xlxp2.jaxb.model.AttributeProperty;
import com.ibm.xml.xlxp2.jaxb.model.ElementDeclaration;
import com.ibm.xml.xlxp2.jaxb.model.ElementProperty;
import com.ibm.xml.xlxp2.jaxb.model.ElementWildcardProperty;
import com.ibm.xml.xlxp2.jaxb.model.JAXBModel;
import com.ibm.xml.xlxp2.jaxb.model.QualifiedName;
import com.ibm.xml.xlxp2.jaxb.model.ValueClass;
import com.ibm.xml.xlxp2.jaxb.model.ValueTypeInformation;
import com.ibm.xml.xlxp2.jaxb.model.converter.BooleanDV;
import com.ibm.xml.xlxp2.jaxb.model.converter.DecimalDV;
import com.ibm.xml.xlxp2.jaxb.model.converter.IntDV;
import com.ibm.xml.xlxp2.jaxb.model.converter.IntegerDV;
import com.ibm.xml.xlxp2.jaxb.model.converter.LongDV;
import com.ibm.xml.xlxp2.jaxb.model.converter.XMLGregorianCalendarDV;
import com.ibm.xml.xlxp2.jaxb.unmarshal.impl.DeserializationContext;
import com.ibm.xml.xlxp2.runtime.VMContext;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import com.ibm.xml.xlxp2.util.BitSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class JAXBModelConverter {
    private static final int ST_COUNT = 31;
    private static final String URI_XS = "http://www.w3.org/2001/XMLSchema".intern();
    private static final String URI_XSI = "http://www.w3.org/2001/XMLSchema-instance".intern();
    private static final String NAME_TYPE = "type".intern();
    private static final String NAME_NIL = "nil".intern();
    private static final String NAME_SL = "schemaLocation".intern();
    private static final String NAME_NSL = "noNamespaceSchemaLocation".intern();
    private static final Wildcard JAXB_WILDCARD_SKIP = new Wildcard(2, false, null, null);
    private static final Wildcard JAXB_WILDCARD_LAX = new Wildcard(3, false, null, null);
    private final HashMap<ElementDeclaration, Element> fGlobalElemMap = new HashMap();
    private final ArrayList<Element> fGlobalElems = new ArrayList();
    private final HashMap<ValueTypeInformation, ElementType> fElementTypeMap = new HashMap();
    private final Vector<TypeValidator> fDVs = new Vector();
    private final Vector<ElementType> fSimpleTypes = new Vector();
    private final ArrayList<ValueTypeInformation> fGlobalTypes = new ArrayList();
    private final ArrayList<Object> fPendingCMs = new ArrayList();
    private final HashMap<Class<?>, BitSet> fTypeSubstitutionMap = new HashMap();
    private JAXBModel fModel;
    private Attribute[] fDefaultAttrs;

    public Grammar convert(JAXBModel jAXBModel) throws ConverterException {
        this.prepare(jAXBModel);
        Grammar grammar = new Grammar();
        this.analyzeSchema();
        this.createBuiltInSimpleTypes();
        this.prepareDefaultAttributes();
        this.convertGlobalElements();
        this.convertGlobalTypes();
        this.processPendingCMs();
        this.fillGrammar(grammar);
        this.finish();
        return grammar;
    }

    private void prepare(JAXBModel jAXBModel) {
        this.fModel = jAXBModel;
    }

    private void finish() {
        this.fGlobalElemMap.clear();
        this.fGlobalElems.clear();
        this.fElementTypeMap.clear();
        this.fDVs.clear();
        this.fSimpleTypes.clear();
        this.fModel = null;
        this.fDefaultAttrs = null;
        this.fGlobalTypes.clear();
        this.fPendingCMs.clear();
    }

    private void analyzeSchema() {
        for (ValueTypeInformation valueTypeInformation : this.fModel.typeInformation) {
            this.fGlobalTypes.add(valueTypeInformation);
        }
    }

    private void createBuiltInSimpleTypes() {
        this.fDVs.setSize(31);
        this.fSimpleTypes.setSize(31);
        this.fDVs.set(0, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(1, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(2, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(3, this.setDVNames(BooleanDV.INSTANCE));
        this.fDVs.set(4, this.setDVNames(DecimalDV.INSTANCE));
        this.fDVs.set(5, this.setDVNames(IntegerDV.INSTANCE));
        this.fDVs.set(6, this.setDVNames(LongDV.INSTANCE));
        this.fDVs.set(7, this.setDVNames(IntDV.INSTANCE));
        this.fDVs.set(8, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(9, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(10, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(11, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(12, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(13, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(14, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(15, this.setDVNames(XMLGregorianCalendarDV.INSTANCE));
        this.fDVs.set(16, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(17, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(18, this.setDVNames(new QNameDV(null, null)));
        this.fDVs.set(19, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(20, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(21, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(22, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(23, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(24, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(25, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(26, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(27, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(28, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(29, this.setDVNames(DefaultDV.INSTANCE));
        this.fDVs.set(30, this.setDVNames(DefaultDV.INSTANCE));
    }

    private TypeValidator setDVNames(TypeValidator typeValidator) {
        return typeValidator;
    }

    private void prepareDefaultAttributes() {
        this.fDefaultAttrs = ArrayAllocator.newObjectArray(Attribute.class, 4);
        TypeValidator typeValidator = this.fDVs.get(18);
        this.fDefaultAttrs[2] = new Attribute(URI_XSI, NAME_TYPE, typeValidator, null, false, null);
        typeValidator = this.fDVs.get(3);
        this.fDefaultAttrs[3] = new Attribute(URI_XSI, NAME_NIL, typeValidator, null, false, null);
        this.fDefaultAttrs[0] = new Attribute(URI_XSI, NAME_NSL, typeValidator, null, false, null);
        this.fDefaultAttrs[1] = new Attribute(URI_XSI, NAME_SL, typeValidator, null, false, null);
    }

    private void convertGlobalElements() {
        for (ElementDeclaration elementDeclaration : this.fModel.elementDeclarations) {
            Element element = this.convertElemD(elementDeclaration);
            this.fGlobalElems.add(element);
        }
    }

    private void convertGlobalTypes() {
        int n = this.fGlobalTypes.size() - 45;
        int n2 = 0;
        while (n2 < n) {
            ValueTypeInformation valueTypeInformation = this.fGlobalTypes.get(n2);
            ElementType elementType = this.convertType(valueTypeInformation);
            elementType.index = n2++;
        }
    }

    private void processPendingCMs() {
        for (int i = 0; i < this.fPendingCMs.size(); i += 3) {
            ElementType elementType = (ElementType)this.fPendingCMs.get(i);
            ElementProperty[] elementPropertyArray = (ElementProperty[])this.fPendingCMs.get(i + 1);
            ElementWildcardProperty elementWildcardProperty = (ElementWildcardProperty)this.fPendingCMs.get(i + 2);
            this.convertAll(elementType, elementPropertyArray, elementWildcardProperty);
        }
    }

    private Grammar fillGrammar(Grammar grammar) throws ConverterException {
        Object object;
        int n;
        ElementType.DFAState dFAState = new ElementType.DFAState();
        grammar.root = dFAState;
        ElementDeclaration[] elementDeclarationArray = this.fModel.elementDeclarations;
        int n2 = elementDeclarationArray.length;
        if (n2 > 0) {
            dFAState.elements = ArrayAllocator.newObjectArray(Element.class, n2);
            for (int i = 0; i < n2; ++i) {
                ElementDeclaration elementDeclaration = elementDeclarationArray[i];
                dFAState.elements[i] = this.fGlobalElemMap.get(elementDeclaration);
            }
            dFAState.elementTable = NamedDeclaration.createMap(dFAState.elements);
        }
        Wildcard wildcard = new Wildcard(1, true, null, null);
        dFAState.wc = ArrayAllocator.newObjectArray(Wildcard.class, 1);
        dFAState.wc[0] = wildcard;
        n2 = this.fGlobalTypes.size();
        int n3 = n2 - 45;
        grammar.globalTypes = ArrayAllocator.newObjectArray(ElementType.class, n2);
        for (n = 0; n < n3; ++n) {
            grammar.globalTypes[n] = object = this.fElementTypeMap.get(this.fGlobalTypes.get(n));
        }
        for (n = n3; n < n2; ++n) {
            object = this.fGlobalTypes.get(n);
            this.addBuiltIn(grammar.globalTypes, n, ((ValueTypeInformation)object).typeId, ((ValueTypeInformation)object).schemaType.local);
        }
        grammar.globalTypesTable = NamedDeclaration.createMap(grammar.globalTypes, true);
        return grammar;
    }

    private void addBuiltIn(ElementType[] elementTypeArray, int n, int n2, String string) {
        ElementType elementType;
        elementTypeArray[n] = elementType = new ElementType(URI_XS, string, n, n2, this.fDefaultAttrs, null, null, null, null, -1, null, 1, this.fDVs.get(n2), null, null, null);
    }

    private Attribute convertAttrUse(AttributeProperty attributeProperty) {
        QualifiedName qualifiedName = attributeProperty.schemaComponentName;
        String string = qualifiedName.ns;
        if (string == null) {
            string = "";
        }
        String string2 = qualifiedName.local;
        ValueTypeInformation valueTypeInformation = attributeProperty.propertyTypeInfo.valueType;
        while (valueTypeInformation.valueClass != null && valueTypeInformation.valueClass.hasSimpleContent()) {
            valueTypeInformation = valueTypeInformation.valueClass.simpleContentProperty.propertyTypeInfo.valueType;
        }
        int n = valueTypeInformation.enumClass != null ? valueTypeInformation.enumClass.getPrimitiveEnumConstantValueTypeId() : valueTypeInformation.typeId;
        TypeValidator typeValidator = this.fDVs.get(n);
        return new Attribute(string, string2, typeValidator, null, false, null);
    }

    private Element convertElemD(ElementDeclaration elementDeclaration) {
        Element element = this.fGlobalElemMap.get(elementDeclaration);
        if (element != null) {
            return element;
        }
        QualifiedName qualifiedName = elementDeclaration.elementName;
        String string = qualifiedName.ns;
        if (string == null) {
            string = "";
        }
        String string2 = qualifiedName.local;
        element = new Element(string, string2, null, null, null, null);
        ValueTypeInformation valueTypeInformation = elementDeclaration.typeInfo.valueType;
        element.type = this.convertType(valueTypeInformation);
        element.xsiTypes = this.getAllowedSubstitutions(valueTypeInformation);
        this.fGlobalElemMap.put(elementDeclaration, element);
        return element;
    }

    private Element convertElem(ElementProperty elementProperty) {
        QualifiedName qualifiedName = elementProperty.schemaComponentName;
        String string = qualifiedName.ns;
        if (string == null) {
            string = "";
        }
        String string2 = qualifiedName.local;
        XMLString xMLString = qualifiedName.localBytes;
        Element element = new Element(string, string2, null, null, null, null);
        ValueTypeInformation valueTypeInformation = elementProperty.propertyTypeInfo.valueType;
        element.type = this.convertType(valueTypeInformation);
        element.xsiTypes = this.getAllowedSubstitutions(valueTypeInformation);
        return element;
    }

    private ElementType convertType(ValueTypeInformation valueTypeInformation) {
        Object object;
        int n;
        int n2;
        Attribute[] attributeArray;
        ElementType elementType = this.fElementTypeMap.get(valueTypeInformation);
        if (elementType != null) {
            return elementType;
        }
        QualifiedName qualifiedName = valueTypeInformation.schemaType;
        String string = qualifiedName.ns;
        if (string == null) {
            string = "";
        }
        String string2 = qualifiedName.local;
        if (valueTypeInformation.valueClass == null) {
            if (valueTypeInformation.enumClass == null) {
                elementType = this.fSimpleTypes.get(valueTypeInformation.typeId);
                if (elementType == null) {
                    TypeValidator typeValidator = this.fDVs.get(valueTypeInformation.typeId);
                    elementType = new ElementType(string, string2, -1, valueTypeInformation.typeId, this.fDefaultAttrs, null, null, null, null, -1, null, 1, typeValidator, null, null, null);
                    this.fSimpleTypes.set(valueTypeInformation.typeId, elementType);
                }
            } else {
                TypeValidator typeValidator = this.fDVs.get(valueTypeInformation.enumClass.getPrimitiveEnumConstantValueTypeId());
                elementType = new ElementType(string, string2, -1, valueTypeInformation.enumClass.getPrimitiveEnumConstantValueTypeId(), this.fDefaultAttrs, null, null, null, null, -1, null, 0, typeValidator, null, null, null);
            }
            this.fElementTypeMap.put(valueTypeInformation, elementType);
            return elementType;
        }
        ValueClass valueClass = valueTypeInformation.valueClass;
        Wildcard wildcard = null;
        if (valueClass.attributeWildcardProperty != null) {
            wildcard = JAXB_WILDCARD_SKIP;
        }
        AttributeProperty[] attributePropertyArray = valueClass.attributeProperties;
        int n3 = attributePropertyArray.length;
        int n4 = n3 + 4;
        if (n3 > 0) {
            attributeArray = ArrayAllocator.newObjectArray(Attribute.class, n4);
            System.arraycopy(this.fDefaultAttrs, 0, attributeArray, 0, 4);
            n2 = 4;
            n = 0;
            while (n < n3) {
                object = attributePropertyArray[n];
                attributeArray[n2] = this.convertAttrUse((AttributeProperty)object);
                ++n;
                ++n2;
            }
        } else {
            attributeArray = this.fDefaultAttrs;
        }
        if (valueClass.simpleContentProperty != null) {
            ValueTypeInformation valueTypeInformation2 = valueClass.simpleContentProperty.propertyTypeInfo.valueType;
            while (valueTypeInformation2.valueClass != null && valueTypeInformation2.valueClass.hasSimpleContent()) {
                valueTypeInformation2 = valueTypeInformation2.valueClass.simpleContentProperty.propertyTypeInfo.valueType;
            }
            n = valueTypeInformation2.enumClass == null ? valueTypeInformation2.typeId : valueTypeInformation2.enumClass.getPrimitiveEnumConstantValueTypeId();
            object = this.fDVs.get(n);
            elementType = new ElementType(string, string2, -1, valueTypeInformation.typeId, attributeArray, null, null, null, null, -1, null, 3, (TypeValidator)object, null, null, null);
            this.fElementTypeMap.put(valueTypeInformation, elementType);
            return elementType;
        }
        n2 = valueClass.mixedContentProperty != null ? 3 : 2;
        elementType = new ElementType(string, string2, -1, valueTypeInformation.typeId, attributeArray, null, null, null, null, -1, null, n2, null, null, null, null);
        this.fElementTypeMap.put(valueTypeInformation, elementType);
        ElementProperty[] elementPropertyArray = valueClass.elementProperties;
        for (int i = 0; i < elementPropertyArray.length; ++i) {
            this.convertElem(elementPropertyArray[i]);
        }
        ElementWildcardProperty elementWildcardProperty = valueClass.elementWildcardProperty;
        if (elementPropertyArray != null || elementWildcardProperty != null) {
            this.fPendingCMs.add(elementType);
            this.fPendingCMs.add(elementPropertyArray);
            this.fPendingCMs.add(elementWildcardProperty);
        }
        return elementType;
    }

    private void convertAll(ElementType elementType, ElementProperty[] elementPropertyArray, ElementWildcardProperty elementWildcardProperty) {
        int n = elementPropertyArray.length;
        Element[] elementArray = ArrayAllocator.newObjectArray(Element.class, n);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Element element;
            ElementProperty elementProperty = elementPropertyArray[i];
            elementArray[elementProperty.propertyId] = element = this.convertElem(elementProperty);
            nArray[elementProperty.propertyId] = elementProperty.propertyId;
        }
        elementType.all = new ElementType.AllContent(elementArray, nArray, null);
        if (elementWildcardProperty != null) {
            (elementType.all.wc = ArrayAllocator.newObjectArray(Wildcard.class, (int)1))[0] = elementWildcardProperty.lax ? JAXB_WILDCARD_LAX : JAXB_WILDCARD_SKIP;
        }
    }

    private BitSet getAllowedSubstitutions(ValueTypeInformation valueTypeInformation) {
        ValueClass valueClass = valueTypeInformation.valueClass;
        if (valueClass == null) {
            return null;
        }
        Class<?> clazz = valueClass.javaType;
        if (this.fTypeSubstitutionMap.containsKey(clazz)) {
            return this.fTypeSubstitutionMap.get(clazz);
        }
        ValueTypeInformation[] valueTypeInformationArray = this.fModel.typeInformation;
        int n = valueTypeInformationArray != null ? valueTypeInformationArray.length : 0;
        BitSet bitSet = null;
        if (clazz == Object.class) {
            bitSet = new BitSet(n);
            for (int i = 0; i < n; ++i) {
                bitSet.setBit(i);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Class<?> clazz2;
                ValueTypeInformation valueTypeInformation2 = valueTypeInformationArray[i];
                ValueClass valueClass2 = valueTypeInformation2.valueClass;
                if (valueClass2 == null || clazz == (clazz2 = valueClass2.javaType) || !clazz.isAssignableFrom(clazz2)) continue;
                bitSet = new BitSet(n);
                bitSet.setBit(i);
                while (++i < n) {
                    valueTypeInformation2 = valueTypeInformationArray[i];
                    valueClass2 = valueTypeInformation2.valueClass;
                    if (valueClass2 == null || clazz == (clazz2 = valueClass2.javaType) || !clazz.isAssignableFrom(clazz2)) continue;
                    bitSet.setBit(i);
                }
            }
        }
        this.fTypeSubstitutionMap.put(clazz, bitSet);
        return bitSet;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class ScanUtil {
        public static int removeWhitespace(byte[] byArray, int n, int n2, boolean[] blArray) {
            while (n < n2) {
                byte by = byArray[n];
                if (by != 32) {
                    if (by != 10 && by != 9 && by != 13) break;
                    blArray[0] = false;
                }
                ++n;
            }
            return n;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class DefaultDV
    extends TypeValidator {
        private static final DefaultDV INSTANCE = new DefaultDV();

        private DefaultDV() {
            super(null, null, null, -1, -1, null, -1, false, false);
        }

        public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
            return xMLString;
        }

        public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
            validatedInfo2.actualValue = xMLString;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class StringDV
    extends TypeValidator {
        private StringDV() {
            super(null, null, null, -1, -1, null, -1, false);
        }

        public Object getActualValue(XMLString xMLString, ValidatedInfo validatedInfo) {
            return xMLString;
        }

        public void validate(XMLString xMLString, ValidatedInfo validatedInfo, ValidationContext validationContext, ValidatedInfo validatedInfo2) {
            validatedInfo2.actualValue = xMLString;
        }

        public boolean scanContent(ParsedEntity parsedEntity, XMLString xMLString, VMContext vMContext) {
            VMContext vMContext2 = vMContext;
            DeserializationContext deserializationContext = (DeserializationContext)vMContext2.dvContext;
            deserializationContext.elementContentDeserialized = true;
            vMContext2.isValidated = true;
            vMContext2.setContentScanner(null);
            if (vMContext2.scanContent()) {
                deserializationContext.currentStub.write(deserializationContext.currentPropertyId, xMLString.toString());
                return true;
            }
            return false;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2007, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static class ConverterException
    extends Exception {
        private static final long serialVersionUID = -4653878984336161387L;

        public ConverterException(String string) {
            super(string);
        }
    }
}

