/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.jaxb.model.builder;

import com.ibm.xml.xlxp2.jaxb.model.EnumClass;
import com.ibm.xml.xlxp2.jaxb.model.PropertyTypeInformation;
import com.ibm.xml.xlxp2.jaxb.model.QualifiedName;
import com.ibm.xml.xlxp2.jaxb.model.builder.Context;
import com.ibm.xml.xlxp2.jaxb.model.builder.ContextBuilder;
import com.ibm.xml.xlxp2.jaxb.model.builder.typeinfo.EnumInfo;
import com.ibm.xml.xlxp2.jaxb.model.builder.typeinfo.TypeInfo;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import javax.xml.bind.JAXBException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class EnumClassBuilder {
    private ContextBuilder fBuilder;
    private Context fContext;
    private EnumInfo fInfo;

    public EnumClassBuilder(ContextBuilder contextBuilder, Context context) throws JAXBException {
        this.fBuilder = contextBuilder;
        this.fContext = context;
    }

    public void reset() {
        this.fInfo = null;
    }

    public EnumClass buildEnumClass(EnumInfo enumInfo, String string) throws JAXBException {
        this.fInfo = enumInfo;
        EnumClass.Fields fields = new EnumClass.Fields();
        fields.enumId = this.fBuilder.nextEnumClassId();
        fields.schemaTypeName = this.makeSchemaTypeName(string);
        if (this.fInfo.isRootElement()) {
            fields.rootElementName = this.fInfo.getRootElementQName();
        }
        fields.javaType = (Class)this.fInfo.getBoundType();
        fields.enumConstantValueType = enumInfo.getEnumType();
        TypeInfo typeInfo = this.fContext.fTypeInfoFactory.getTypeInfo(fields.enumConstantValueType, false);
        PropertyTypeInformation propertyTypeInformation = this.fBuilder.buildPropertyTypeInformation(typeInfo, true, false, null, null);
        fields.enumConstantValueTypeId = propertyTypeInformation.valueType.typeId;
        EnumInfo enumInfo2 = enumInfo.getEnumTypeEnumInfo();
        if (enumInfo2 != null) {
            fields.enumConstantEnumClass = this.fBuilder.buildEnumClass(enumInfo2, string);
        }
        Enum[] enumArray = fields.javaType.getEnumConstants();
        fields.enumValues = new EnumClass.EnumValue[enumArray.length + 1];
        for (int i = 0; i < enumArray.length; ++i) {
            fields.enumValues[i + 1] = new EnumClass.EnumValue(this.fContext.getSymbol(enumArray[i].toString()), enumArray[i]);
        }
        fields.valueMethod = enumInfo.getValueMethod();
        fields.fromValueMethod = enumInfo.getFromValueMethod();
        EnumClass enumClass = new EnumClass(fields);
        return enumClass;
    }

    private QualifiedName makeSchemaTypeName(String string) {
        QualifiedName qualifiedName = this.fInfo.getTypeName();
        if (this.fInfo.isAnonymousType() && qualifiedName.ns.equals("##default") && !this.fInfo.isRootElement()) {
            XMLString xMLString = new XMLString();
            this.fContext.fXMLStringBuffer.addString(string, xMLString);
            return this.fContext.createQualifiedName(string, qualifiedName.local, xMLString, qualifiedName.localBytes);
        }
        return qualifiedName;
    }
}

