/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util.encoding;

import com.ibm.xml.xlxp2.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp2.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import java.io.IOException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UTF8EncodingSupport
implements EncodingSupport {
    private static final EncodingSupport fgSingleton = new UTF8EncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, ByteStreamDataSource byteStreamDataSource) {
        byteStreamDataSource.setEncodingSupport(this);
        byteStreamDataSource.createReadBuffer();
        return byteStreamDataSource.load(parsedEntity);
    }

    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n = dataBuffer.endOffset;
        int n2 = byteStreamDataSource.readOffset;
        int n3 = 0;
        try {
            int n4;
            if (byteStreamDataSource.stream != null && n2 < 4) {
                int n5 = byteStreamDataSource.stream.read(byArray, n2, n - n2);
                if (n5 == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                    if (n2 == 0) {
                        byteStreamDataSource.readOffset = 0;
                        dataBuffer.endOffset = n3;
                        return null;
                    }
                    n4 = 0;
                } else {
                    n4 = n5;
                }
            } else {
                n4 = 0;
            }
            n4 += n2;
            if (!byteStreamDataSource.normalizeLineBreaks) {
                byteStreamDataSource.readOffset = 0;
                dataBuffer.endOffset = n4;
                if (n4 == n) {
                    return null;
                }
            } else {
                dataBuffer.endOffset = byteStreamDataSource.isXML10 ? this.normalizeLineBreaksXML10(byArray, 0, n4, byteStreamDataSource) : this.normalizeLineBreaksXML11(byArray, 0, n4, byteStreamDataSource);
                if (byteStreamDataSource.readOffset < n4) {
                    n2 = byteStreamDataSource.readOffset;
                    byteStreamDataSource.readOffset = n4 - n2;
                    System.arraycopy(byArray, n2, byteStreamDataSource.readBuffer, 0, byteStreamDataSource.readOffset);
                    byteStreamDataSource.createReadBuffer();
                    return null;
                }
                byteStreamDataSource.readOffset = 0;
            }
            return null;
        }
        catch (IOException iOException) {
            return CharConversionError.runtimeIOError(iOException);
        }
    }

    private UTF8EncodingSupport() {
    }

    public int normalizeLineBreaksXML10(byte[] byArray, int n, int n2, ByteStreamDataSource byteStreamDataSource) {
        int n3 = 0;
        byArray[n2] = 13;
        while (byArray[n] != 13) {
            ++n;
        }
        if (n == n2) {
            byteStreamDataSource.readOffset = n;
            byArray[n2] = 0;
            return n;
        }
        n3 = n;
        while (++n < n2) {
            byte by;
            if ((by = byArray[n++]) != 10) {
                --n;
            }
            byArray[n3++] = 10;
            by = byArray[n];
            if (by == 13) continue;
            int n4 = n++;
            while (byArray[n] != 13) {
                ++n;
            }
            System.arraycopy(byArray, n4, byArray, n3, n - n4);
            n3 += n - n4;
        }
        if (n == n2 && byteStreamDataSource.stream == null) {
            byArray[n3++] = 10;
        } else {
            --n;
        }
        byteStreamDataSource.readOffset = n;
        byArray[n2] = 0;
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int normalizeLineBreaksXML11(byte[] byArray, int n, int n2, ByteStreamDataSource byteStreamDataSource) {
        byte by;
        int n3 = n;
        int n4 = 0;
        byArray[n2] = 13;
        while ((by = byArray[n3]) >= 0 && by != 13) {
            ++n3;
        }
        if (n3 == n2) {
            byteStreamDataSource.readOffset = n3;
            byArray[n2] = 0;
            return n3;
        }
        n4 = n3;
        while (true) {
            int n5;
            block24: {
                block26: {
                    block28: {
                        block27: {
                            block25: {
                                if (by >= 0) {
                                    if (++n3 < n2) {
                                        if ((by = byArray[n3++]) != 10) {
                                            if ((by & 0xFF) != 194) {
                                                --n3;
                                            } else if (n3 < n2) {
                                                if (((by = byArray[n3++]) & 0xFF) != 133) {
                                                    n3 -= 2;
                                                }
                                            } else {
                                                if (byteStreamDataSource.stream == null) {
                                                    byArray[n4++] = 13;
                                                    byArray[n4++] = by;
                                                    break;
                                                }
                                                n3 -= 2;
                                                break;
                                            }
                                        }
                                        byArray[n4++] = 10;
                                        break block24;
                                    } else {
                                        if (n3 == n2 && byteStreamDataSource.stream == null) {
                                            byArray[n4++] = 10;
                                            break;
                                        }
                                        --n3;
                                        break;
                                    }
                                }
                                ++n3;
                                if ((by & 0xDF) == 194) break block25;
                                byArray[n4++] = by;
                                break block24;
                            }
                            if (n3 >= n2) break block26;
                            n5 = byArray[n3++];
                            if ((by & 0xFF) != 194) break block27;
                            if ((n5 & 0xFF) == 133) {
                                byArray[n4++] = 10;
                                break block24;
                            } else {
                                byArray[n4++] = by;
                                byArray[n4++] = n5;
                            }
                            break block24;
                        }
                        if ((n5 & 0xFF) == 128) break block28;
                        byArray[n4++] = by;
                        byArray[n4++] = n5;
                        break block24;
                    }
                    if (n3 < n2) {
                        byte by2;
                        if (((by2 = byArray[n3++]) & 0xFF) == 168) {
                            byArray[n4++] = 10;
                            break block24;
                        } else {
                            byArray[n4++] = by;
                            byArray[n4++] = n5;
                            byArray[n4++] = by2;
                        }
                        break block24;
                    } else {
                        if (byteStreamDataSource.stream == null) {
                            byArray[n4++] = by;
                            byArray[n4++] = n5;
                            break;
                        }
                        n3 -= 2;
                        break;
                    }
                }
                if (n3 == n2 && byteStreamDataSource.stream == null) {
                    byArray[n4++] = by;
                    break;
                }
                --n3;
                break;
            }
            if ((by = byArray[n3]) < 0 || by == 13) continue;
            n5 = n3++;
            while ((by = byArray[n3]) >= 0 && by != 13) {
                ++n3;
            }
            if (n5 != n4) {
                System.arraycopy(byArray, n5, byArray, n4, n3 - n5);
            }
            n4 += n3 - n5;
        }
        byteStreamDataSource.readOffset = n3;
        byArray[n2] = 0;
        return n4;
    }
}

