/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util.encoding;

import com.ibm.xml.xlxp2.api.util.DataBufferHelper;
import com.ibm.xml.xlxp2.api.util.encoding.DataSourceFactory;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp2.scan.util.DataSource;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import java.io.IOException;
import java.io.Reader;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class CharacterStreamDataSource
implements DataSource {
    public int bufferLength;
    public boolean normalizeLineBreaks;
    public boolean isXML10;
    private static final boolean CLEAR_TO_END_OF_BUFFER = false;
    private CharacterStreamDataSource fNextFreeDataSource;
    private DataSourceFactory fSourceFactory;
    private DataBufferFactory fBufferFactory;
    private Reader fReader;
    private char[] fReadBuffer;
    private int fReadOffset;
    private int fReadLimit;
    private int fReadLength;
    private int fLoadCount;
    private int fReclaimBufferLimit;

    public CharacterStreamDataSource(DataSourceFactory dataSourceFactory, DataBufferFactory dataBufferFactory, int n) {
        this.fSourceFactory = dataSourceFactory;
        this.fBufferFactory = dataBufferFactory;
        this.bufferLength = n;
        this.fReadLength = n;
        this.fReadBuffer = ArrayAllocator.newCharArray(this.fReadLength + 1);
    }

    public void setNextFreeDataSource(CharacterStreamDataSource characterStreamDataSource) {
        this.fNextFreeDataSource = characterStreamDataSource;
    }

    public CharacterStreamDataSource getNextFreeDataSource() {
        return this.fNextFreeDataSource;
    }

    public void setCharacterStream(Reader reader) {
        this.fReader = reader;
        this.isXML10 = true;
        this.fReadLimit = 0;
        this.fReadOffset = 0;
        this.fLoadCount = 0;
        this.fReclaimBufferLimit = 524288 / this.bufferLength;
    }

    public int readMoreChars() throws IOException {
        int n;
        int n2 = this.fReadLength;
        if (this.fReadOffset == n2) {
            this.fReadLength <<= 1;
            this.fReadBuffer = ArrayAllocator.resizeCharArray(this.fReadBuffer, this.fReadLength + 1);
            n2 = this.fReadLength;
        }
        if ((n = this.fReader.read(this.fReadBuffer, this.fReadOffset, n2 - this.fReadOffset)) == -1) {
            this.fReader.close();
            this.fReader = null;
            return -1;
        }
        this.fReadLimit += n;
        return this.fReadBuffer[this.fReadOffset++];
    }

    public int readChar() throws IOException {
        if (this.fReadOffset < this.fReadLimit) {
            return this.fReadBuffer[this.fReadOffset++];
        }
        return this.readMoreChars();
    }

    public CharConversionError loadFromCharacterStream(ParsedEntity parsedEntity) {
        this.fReadOffset = this.fReadLimit;
        return this.load(parsedEntity);
    }

    public CharConversionError load(ParsedEntity parsedEntity) {
        if (++this.fLoadCount % this.fReclaimBufferLimit == 0) {
            this.fBufferFactory.reclaimBuffers(this.fReclaimBufferLimit);
        }
        DataBuffer dataBuffer = this.fBufferFactory.createBuffer();
        if (dataBuffer.bytes == null) {
            dataBuffer.bytes = ArrayAllocator.newByteArray(this.bufferLength + 1);
        } else if (dataBuffer.bytes.length < this.bufferLength + 1) {
            dataBuffer.bytes = ArrayAllocator.replaceByteArray(dataBuffer.bytes, this.bufferLength + 1);
        }
        dataBuffer.endOffset = this.bufferLength;
        parsedEntity.error = this.load(dataBuffer);
        int n = dataBuffer.endOffset;
        dataBuffer.bytes[n] = 0;
        dataBuffer.startOffset = 0;
        if (parsedEntity.isCoordinatesAware) {
            if (parsedEntity.buffer != null) {
                if (parsedEntity.isXML10) {
                    DataBufferHelper.computeCoords10(parsedEntity.buffer, dataBuffer);
                } else {
                    DataBufferHelper.computeCoords11(parsedEntity.buffer, dataBuffer);
                }
            } else {
                dataBuffer.byteOffset = 0;
            }
        }
        if (this.fReader == null && this.fReadOffset == 0) {
            parsedEntity.setValues(dataBuffer, 0, n, null);
            this.release();
        } else {
            parsedEntity.setValues(dataBuffer, 0, n, this);
        }
        return parsedEntity.error;
    }

    public void release() {
        if (this.fReader != null) {
            try {
                this.fReader.close();
                this.fReader = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fSourceFactory.releaseCharacterStreamDataSource(this);
    }

    private CharConversionError load(DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n = dataBuffer.endOffset;
        int n2 = 0;
        try {
            int n3;
            int n4 = 0;
            if (this.fReader != null && this.fReadOffset < this.fReadLength) {
                n3 = this.fReader.read(this.fReadBuffer, this.fReadOffset, this.fReadLength - this.fReadOffset);
                if (n3 == -1) {
                    this.fReader.close();
                    this.fReader = null;
                    if (this.fReadOffset == 0) {
                        dataBuffer.endOffset = n2;
                        return null;
                    }
                } else {
                    n4 = n3;
                }
            }
            n4 += this.fReadOffset;
            this.fReadOffset = 0;
            while (this.fReadOffset < n4 && n2 < n) {
                if ((n3 = this.fReadBuffer[this.fReadOffset++]) < 128) {
                    if (n3 != 13) {
                        byArray[n2++] = (byte)n3;
                        continue;
                    }
                    if (this.fReadOffset < n4) {
                        byArray[n2++] = 10;
                        if ((n3 = this.fReadBuffer[this.fReadOffset++]) == 10 || !this.isXML10 && n3 == 133) continue;
                        --this.fReadOffset;
                        continue;
                    }
                    if (this.fReader == null) {
                        byArray[n2++] = 10;
                        break;
                    }
                    --this.fReadOffset;
                    break;
                }
                if (!(this.isXML10 || n3 != 133 && n3 != 8232)) {
                    byArray[n2++] = 10;
                    continue;
                }
                if (n3 < 2048) {
                    if (n2 + 1 < n) {
                        byArray[n2++] = (byte)(0xC0 | n3 >> 6);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n3);
                        continue;
                    }
                    --this.fReadOffset;
                    break;
                }
                if (n3 < 55296 || n3 >= 57344) {
                    if (n2 + 2 < n) {
                        byArray[n2++] = (byte)(0xE0 | n3 >> 12);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n3 >> 6);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n3);
                        continue;
                    }
                    --this.fReadOffset;
                    break;
                }
                if (n3 < 56320) {
                    if (this.fReadOffset < n4 && n2 + 3 < n) {
                        char c;
                        if ((c = this.fReadBuffer[this.fReadOffset++]) >= '\udc00' && c < '\ue000') {
                            n3 = 65536 + (n3 - 55296 << 10) + (c - 56320);
                            byArray[n2++] = (byte)(0xF0 | n3 >> 18);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n3 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n3 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n3);
                            continue;
                        }
                        --this.fReadOffset;
                        return CharConversionError.invalidSecondHalfOfSurrogatePair();
                    }
                    --this.fReadOffset;
                    break;
                }
                --this.fReadOffset;
                return CharConversionError.invalidFirstHalfOfSurrogatePair();
            }
            if (this.fReadOffset < n4) {
                System.arraycopy(this.fReadBuffer, this.fReadOffset, this.fReadBuffer, 0, n4 -= this.fReadOffset);
                this.fReadOffset = n4;
            } else {
                this.fReadOffset = 0;
            }
            dataBuffer.endOffset = n2;
            return null;
        }
        catch (IOException iOException) {
            return CharConversionError.runtimeIOError(iOException);
        }
    }
}

