/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.platform.token;

import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class KRBAuthnTokenFactoryFactory {
    private static KRBAuthnTokenFactory _tokenFactory = null;
    private static final String FACTORY_KEY = "com.ibm.ws.wssecurity.platform.krbAuthnTokenFactory";
    private static final String PROXY_FACTORY_KEY = "com.ibm.ws.wssecurity.platform.websphere.token.ProxyKRBAuthnTokenFactoryImpl";
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public static KRBAuthnTokenFactory getFactory() {
        if (_tokenFactory == null && (_tokenFactory = (KRBAuthnTokenFactory)WSSecurityFactoryBuilder.getInstance(FACTORY_KEY)) == null) {
            _tokenFactory = KRBAuthnTokenFactoryFactory.getProxyKRBAuthnTokenFactory();
        }
        return _tokenFactory;
    }

    private static KRBAuthnTokenFactory getProxyKRBAuthnTokenFactory() {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
        try {
            _tokenFactory = cl != null ? (KRBAuthnTokenFactory)cl.loadClass(PROXY_FACTORY_KEY).newInstance() : (KRBAuthnTokenFactory)Class.forName(PROXY_FACTORY_KEY).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return _tokenFactory;
    }
}

