/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public class Serializer {
    private static final int ATTR_TAB_SIZE = 64;
    private static final String[] attrTab = new String[]{null, null, null, null, null, null, null, null, null, "&#x9;", "&#xA;", null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, null, null};
    private static final int TEXT_TAB_SIZE = 64;
    private static final String[] textTab = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;", null};

    static final void serializeAttribute(OMAttribute attr, Writer wr) throws IOException {
        Serializer.serializeAttribute(attr.getNamespace() == null ? null : attr.getNamespace().getPrefix(), attr.getLocalName(), attr.getAttributeValue(), wr);
    }

    static final void serializeAttribute(String prefix, String local, String value, Writer wr) throws IOException {
        int len = value.length();
        int start = -1;
        wr.write(" ");
        if (prefix != null && prefix.length() != 0) {
            wr.write(prefix);
            wr.write(":");
        }
        wr.write(local);
        wr.write("=\"");
        for (int j = 0; j < len; ++j) {
            String escaped;
            char ch = value.charAt(j);
            String string = escaped = ch < '@' ? attrTab[ch] : null;
            if (escaped != null) {
                if (start >= 0) {
                    wr.write(value, start, j - start);
                    start = -1;
                }
                wr.write(escaped);
                continue;
            }
            if (start >= 0) continue;
            start = j;
        }
        if (start >= 0) {
            wr.write(value, start, len - start);
        }
        wr.write("\"");
    }

    static final void serializeNamespaceDeclaration(OMNamespace ns, Writer wr) throws IOException {
        Serializer.serializeNamespaceDeclaration(ns.getPrefix(), ns.getName(), wr);
    }

    static final void serializeNamespaceDeclaration(String prefix, String value, Writer wr) throws IOException {
        int len = value.length();
        int start = -1;
        wr.write(" xmlns");
        if (prefix != null && prefix.length() != 0) {
            wr.write(":");
            wr.write(prefix);
        }
        wr.write("=\"");
        for (int j = 0; j < len; ++j) {
            String escaped;
            char ch = value.charAt(j);
            String string = escaped = ch < '@' ? attrTab[ch] : null;
            if (escaped != null) {
                if (start >= 0) {
                    wr.write(value, start, j - start);
                    start = -1;
                }
                wr.write(escaped);
                continue;
            }
            if (start >= 0) continue;
            start = j;
        }
        if (start >= 0) {
            wr.write(value, start, len - start);
        }
        wr.write("\"");
    }

    public static void serialize(OMNode node, Writer writer) throws IOException {
        switch (node.getType()) {
            case 1: {
                Iterator attrs;
                OMElement elem = (OMElement)node;
                String prefix = elem.getNamespace() == null ? null : elem.getNamespace().getPrefix();
                String local = elem.getLocalName();
                writer.write("<");
                if (prefix != null && prefix.length() != 0) {
                    writer.write(prefix);
                    writer.write(":");
                }
                writer.write(local);
                Iterator nss = elem.getAllDeclaredNamespaces();
                if (nss != null) {
                    while (nss.hasNext()) {
                        Serializer.serializeNamespaceDeclaration((OMNamespace)nss.next(), writer);
                    }
                }
                if ((attrs = elem.getAllAttributes()) != null) {
                    while (attrs.hasNext()) {
                        Serializer.serializeAttribute((OMAttribute)attrs.next(), writer);
                    }
                }
                writer.write(">");
                for (OMNode child = elem.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                    Serializer.serialize(child, writer);
                }
                writer.write("</");
                if (prefix != null && prefix.length() != 0) {
                    writer.write(prefix);
                    writer.write(":");
                }
                writer.write(local);
                writer.write(">");
                break;
            }
            case 9: {
                for (OMNode child = ((OMContainer)((Object)node)).getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
                    Serializer.serialize(child, writer);
                }
                break;
            }
            case 4: 
            case 12: {
                Serializer.serializeText(((OMText)node).getText(), writer);
                break;
            }
            case 5: {
                Serializer.serializeComment(node, writer);
                break;
            }
        }
    }

    public static byte[] serialize(OMNode node) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        Serializer.serialize(node, writer);
        ((Writer)writer).close();
        return out.toByteArray();
    }

    static final void serializeText(String text, Writer wr) throws IOException {
        int len = text.length();
        int start = -1;
        for (int i = 0; i < len; ++i) {
            String escaped;
            char ch = text.charAt(i);
            String string = escaped = ch < '@' ? textTab[ch] : null;
            if (escaped != null) {
                if (start >= 0) {
                    wr.write(text, start, i - start);
                    start = -1;
                }
                wr.write(escaped);
                continue;
            }
            if (start >= 0) continue;
            start = i;
        }
        if (start >= 0) {
            wr.write(text, start, len - start);
        }
    }

    static final void serializeComment(OMNode node, Writer wr) throws IOException {
        boolean lesser = false;
        boolean greater = false;
        if (node.getParent() instanceof OMDocument) {
            OMNode prev = node;
            while ((prev = prev.getPreviousOMSibling()) != null && prev.getType() != 1) {
            }
            if (prev == null) {
                lesser = true;
            } else {
                greater = true;
            }
        }
        if (greater) {
            wr.write("\n");
        }
        wr.write("<!--");
        wr.write(((OMComment)node).getValue());
        wr.write("-->");
        if (lesser) {
            wr.write("\n");
        }
    }
}

